/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins;

import com.fortify.plugin.jenkins.FPRSummary;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ChartAction
implements Action {
    private static long lastChanged;
    private String projectFullName;
    private String appName;
    private String appVersion;
    private boolean isPipeline;

    public ChartAction(Job<?, ?> project, boolean isPipeline, String appName, String appVersion) {
        this.projectFullName = project.getFullName();
        this.appName = appName;
        this.appVersion = appVersion;
        this.isPipeline = isPipeline;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getDisplayName() {
        String name = "Fortify Summary";
        if (this.appName != null || this.appVersion != null) {
            name = name + "(";
            if (this.appName != null) {
                name = name + this.appName;
                if (this.appVersion != null) {
                    name = name + "-";
                }
            }
            if (this.appVersion != null) {
                name = name + this.appVersion;
            }
            name = name + ")";
        }
        return name;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        String url = "fortify-chart";
        if (this.isPipeline) {
            try {
                url = url + URLEncoder.encode("-" + this.appName + "-" + this.appVersion, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return url;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        DataSetBuilder dsb = new DataSetBuilder();
        for (Run<?, ?> b : this.getBuilds()) {
            if (b.isBuilding()) continue;
            FPRSummary fprData = new FPRSummary();
            try {
                if (this.isPipeline) {
                    fprData.load(b.getRootDir(), this.appName, this.appVersion);
                } else {
                    fprData.load(b.getRootDir(), null, null);
                }
                dsb.add((Number)fprData.getNvs(), (Comparable)((Object)"NVS"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(b));
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {}
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)ChartAction.createChart(dsb.build(), this.appName, this.appVersion), (int)400, (int)200);
    }

    private Collection<Run<?, ?>> getBuilds() {
        if (this.projectFullName != null) {
            List allProjects = Jenkins.get().getAllItems(Job.class);
            for (Job next : allProjects) {
                if (next == null || !this.projectFullName.equals(next.getFullName())) continue;
                return next.getBuilds();
            }
        }
        return Collections.emptyList();
    }

    public static JFreeChart createChart(CategoryDataset dataset, String appName, String appVersion) throws IOException {
        String title = "Normalized Vulnerability Score (NVS)";
        if (appName != null || appVersion != null) {
            title = title + "(" + appName + " - " + appVersion + ")";
        }
        JFreeChart chart = ChartFactory.createLineChart((String)title, (String)"Build ID", null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(1.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        return chart;
    }

    public void doCheckUpdates(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        try {
            String stamp = req.getParameter("stamp");
            long lastUpdated = Long.parseLong(stamp);
            if (lastUpdated < lastChanged) {
                rsp.setHeader("go", "go");
            }
            rsp.setHeader("yourStampWas", String.valueOf(lastUpdated));
        }
        catch (NumberFormatException e) {
            rsp.setHeader("yourStampWas", "0");
        }
        rsp.setHeader("myStampWas", String.valueOf(lastChanged));
    }

    @Extension
    public static class RunListenerImpl
    extends RunListener<Run> {
        public void onCompleted(Run run, TaskListener listener) {
            lastChanged = System.currentTimeMillis();
        }
    }
}

