/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.Messages;
import hudson.util.FormValidation;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;

public class Validators {
    private static final String emailPattern = "^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$";

    public static FormValidation checkFieldNotEmpty(String value) {
        if ((value = StringUtils.strip((String)value)) == null || value.equals("")) {
            return FormValidation.error((String)Messages.FortifySCAStep_Check_Required());
        }
        return FormValidation.ok();
    }

    public static FormValidation checkValidInteger(String value) {
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.ok();
        }
        int testInt = 0;
        try {
            testInt = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)Messages.FortifySCAStep_Check_Integer());
        }
        if (testInt < 1) {
            return FormValidation.error((String)Messages.FortifySCAStep_Check_Integer());
        }
        return FormValidation.ok();
    }

    public static FormValidation checkValidNumber(String value) {
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.ok();
        }
        double testNum = 0.0;
        try {
            testNum = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)Messages.FortifySCAStep_Check_Number());
        }
        if (testNum < 1.0) {
            return FormValidation.error((String)Messages.FortifySCAStep_Check_Number());
        }
        return FormValidation.ok();
    }

    public static FormValidation checkValidEmail(String value) {
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.ok();
        }
        Pattern pat = Pattern.compile(emailPattern);
        try {
            InternetAddress emailAddr = new InternetAddress(value);
            emailAddr.validate();
            if (pat.matcher(value).matches()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid email address");
        }
        catch (AddressException ex) {
            return FormValidation.error((String)"Invalid email address");
        }
    }
}

