/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.Messages;
import com.fortify.plugin.jenkins.steps.FortifyStep;
import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class FortifyUpdate
extends FortifyStep {
    private String updateServerURL;
    private String locale;
    private transient String proxyURL;
    private transient String proxyUsername;
    private transient String proxyPassword;
    private transient boolean useProxy;

    @DataBoundConstructor
    public FortifyUpdate(String updateServerURL, String locale) {
        this.updateServerURL = updateServerURL;
        this.locale = locale;
    }

    @Deprecated
    public FortifyUpdate(String updateServerURL, String proxyURL, String proxyUsername, String proxyPassword, boolean useProxy) {
        this.updateServerURL = updateServerURL;
        this.proxyURL = proxyURL;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.useProxy = useProxy;
    }

    public String getUpdateServerURL() {
        return this.updateServerURL;
    }

    public String getLocale() {
        return this.locale;
    }

    @Deprecated
    public String getProxyURL() {
        return this.proxyURL;
    }

    @Deprecated
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Deprecated
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Deprecated
    public boolean getUseProxy() {
        return this.useProxy;
    }

    @DataBoundSetter
    public void setUpdateServerURL(String updateServerURL) {
        this.updateServerURL = updateServerURL;
    }

    @DataBoundSetter
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @DataBoundSetter
    @Deprecated
    public void setProxyURL(String proxyURL) {
        this.proxyURL = proxyURL;
    }

    @DataBoundSetter
    @Deprecated
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @DataBoundSetter
    @Deprecated
    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @DataBoundSetter
    @Deprecated
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public String getResolvedUpdateServerURL(TaskListener listener) {
        return this.resolve(this.getUpdateServerURL(), listener);
    }

    public String getResolvedLocale(TaskListener listener) {
        return this.resolve(this.getLocale(), listener);
    }

    @Deprecated
    public String getResolvedUpdateProxyURL(TaskListener listener) {
        return this.resolve(this.getProxyURL(), listener);
    }

    @Deprecated
    public String getResolvedUpdateProxyUsername(TaskListener listener) {
        return this.resolve(this.getProxyUsername(), listener);
    }

    @Deprecated
    public String getResolvedUpdateProxyPassword(TaskListener listener) {
        return this.resolve(this.getProxyPassword(), listener);
    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String localeStr;
        PrintStream log = listener.getLogger();
        log.println("Fortify Jenkins plugin v " + VERSION);
        log.println("Launching fortifyupdate command");
        ArrayList<String> args = new ArrayList<String>();
        String fortifyUpdate = this.getFortifyUpdateExecutable(build, workspace, launcher, listener);
        args.add(fortifyUpdate);
        String updateServerUrl = this.getResolvedUpdateServerURL(listener);
        if (!"".equals(updateServerUrl)) {
            try {
                URL url = new URL(updateServerUrl);
                if ("http".equalsIgnoreCase(url.getProtocol()) || "https".equalsIgnoreCase(url.getProtocol())) {
                    args.add("-url");
                    args.add(updateServerUrl);
                } else {
                    log.println(Messages.ForitfyUpdate_URL_Protocol_Warning(updateServerUrl));
                }
            }
            catch (MalformedURLException mue) {
                log.println(Messages.FortifyUpdate_URL_Invalid(updateServerUrl));
            }
        }
        if (!"".equals(localeStr = this.getResolvedLocale(listener))) {
            args.add("-locale");
            args.add(localeStr);
        }
        EnvVars vars = build.getEnvironment(listener);
        Launcher.ProcStarter ps = launcher.decorateByEnv(vars).launch().pwd(workspace).cmds(args).envs((Map)vars).stdout((OutputStream)listener.getLogger()).stderr((OutputStream)listener.getLogger());
        int exitcode = ps.join();
        log.println(Messages.FortifyUpdate_Result(exitcode));
        if (exitcode != 0) {
            build.setResult(Result.FAILURE);
            throw new AbortException(Messages.FortifyUpdate_Error());
        }
    }

    private String getFortifyUpdateExecutable(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        return this.getExecutable("fortifyupdate" + (launcher.isUnix() ? "" : ".cmd"), build, workspace, listener, "FORTIFY_HOME");
    }

    public static class Builder {
        private String updateServerURL;
        private String locale;

        public Builder updateServerURL(String updateServerURL) {
            if (StringUtils.isNotBlank((String)updateServerURL)) {
                this.updateServerURL = updateServerURL;
            }
            return this;
        }

        public Builder locale(String localeString) {
            if (StringUtils.isNotBlank((String)localeString)) {
                this.locale = localeString;
            }
            return this;
        }

        public FortifyUpdate build() {
            return new FortifyUpdate(this.updateServerURL, this.locale);
        }
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private transient FortifyUpdate fu;
        private static final long serialVersionUID = 1L;

        protected Execution(FortifyUpdate fu, StepContext context) {
            super(context);
            this.fu = fu;
        }

        protected Void run() throws Exception {
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Running FortifyUpdate step");
            if (!((FilePath)this.getContext().get(FilePath.class)).exists()) {
                ((FilePath)this.getContext().get(FilePath.class)).mkdirs();
            }
            this.fu.perform((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        private static final String DEFAULT_URL = "https://update.fortify.com";

        public String getDefaultURL() {
            return DEFAULT_URL;
        }

        public String getFunctionName() {
            return "fortifyUpdate";
        }

        public String getDisplayName() {
            return Messages.FortifyUpdate_DisplayName();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, Launcher.class, TaskListener.class);
        }

        public ListBoxModel doFillLocaleItems(String value) {
            ListBoxModel items = new ListBoxModel();
            items.add("English", "en");
            items.add("Chinese Simplified", "zh_CN");
            items.add("Chinese Traditional", "zh_TW");
            items.add("Japanese", "ja");
            items.add("Korean", "ko");
            items.add("Portuguese (Brazil)", "pt_BR");
            items.add("Spanish", "es");
            if (null == value || 0 == value.length()) {
                ((ListBoxModel.Option)items.get((int)0)).selected = true;
            }
            return items;
        }
    }
}

