/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.FindExecutableRemoteService;
import com.fortify.plugin.jenkins.FortifyPlugin;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public abstract class FortifyStep
extends Step
implements SimpleBuildStep {
    public static final String VERSION = FortifyPlugin.getPluginVersion();
    protected Run<?, ?> lastBuild;

    protected void setLastBuild(Run<?, ?> lastBuild) {
        this.lastBuild = lastBuild;
    }

    protected String getExecutable(String filename, Run<?, ?> build, FilePath workspace, TaskListener listener, String targetEnvVarName) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        EnvVars env = build.getEnvironment(listener);
        String home = null;
        String path = null;
        boolean isEnvVarSetProperly = true;
        for (Map.Entry entry : env.entrySet()) {
            String envVarName = (String)entry.getKey();
            String envVarValue = (String)entry.getValue();
            if (targetEnvVarName != null && targetEnvVarName.equals(envVarName)) {
                if ("PATH".equalsIgnoreCase(targetEnvVarName)) {
                    path = envVarValue;
                    continue;
                }
                home = envVarValue;
                if (!FortifyStep.endsWithBin(envVarValue)) continue;
                logger.println("WARNING: Environment variable " + envVarName + " should not point to bin directory");
                isEnvVarSetProperly = false;
                continue;
            }
            if (!"PATH".equalsIgnoreCase(envVarName)) continue;
            path = envVarValue;
        }
        String errorMsg = "make sure that either ";
        if (targetEnvVarName != null) {
            errorMsg = errorMsg + targetEnvVarName + " environment variable is set" + (!isEnvVarSetProperly ? " properly" : "") + " or ";
        }
        errorMsg = errorMsg + filename + " is on the PATH or in workspace";
        return this.findExecutablePath(filename, home, path, workspace, logger, errorMsg);
    }

    private static boolean endsWithBin(String str) {
        return str.endsWith("bin") || str.endsWith("bin/") || str.endsWith("bin\\");
    }

    private String findExecutablePath(String filename, String home, String path, FilePath workspace, PrintStream logger, String errorMsg) throws IOException, InterruptedException {
        String executablePath = (String)workspace.act((FilePath.FileCallable)new FindExecutableRemoteService(filename, home, path, workspace));
        if (executablePath == null) {
            throw new FileNotFoundException("ERROR: executable not found: " + filename + "; " + errorMsg);
        }
        logger.printf("Found executable: %s%n", executablePath);
        return executablePath;
    }

    protected String resolve(String param, TaskListener listener) {
        if (param == null) {
            return "";
        }
        if (this.lastBuild == null) {
            return param;
        }
        listener = listener == null ? new StreamBuildListener(System.out, Charset.defaultCharset()) : listener;
        try {
            EnvVars vars = this.lastBuild.getEnvironment(listener);
            return vars.expand(param);
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return param;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return false;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build != null && launcher != null && listener != null && build.getWorkspace() != null) {
            this.perform((Run)build, build.getWorkspace(), launcher, (TaskListener)listener);
        }
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.emptyList();
    }

    public StepExecution start(StepContext arg0) throws Exception {
        return null;
    }

    protected void addAllArguments(List<String> args, String argsToAdd) {
        for (String s : Util.tokenize((String)argsToAdd)) {
            args.add(s);
        }
    }

    protected void addAllArguments(List<String> args, String argsToAdd, String flag) {
        for (String s : Util.tokenize((String)argsToAdd)) {
            args.add(flag);
            args.add(s);
        }
    }
}

