/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.Messages;
import com.fortify.plugin.jenkins.steps.FortifySCAStep;
import com.fortify.plugin.jenkins.steps.Validators;
import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FortifyClean
extends FortifySCAStep
implements SimpleBuildStep {
    @DataBoundConstructor
    public FortifyClean(String buildID) {
        this.buildID = buildID;
    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String option;
        this.setLastBuild(build);
        PrintStream log = listener.getLogger();
        log.println("Fortify Jenkins plugin v " + VERSION);
        log.println("Launching Fortify SCA clean command");
        String projectRoot = workspace.getRemote() + File.separator + ".fortify";
        String sourceanalyzer = null;
        if (sourceanalyzer == null) {
            sourceanalyzer = this.getSourceAnalyzerExecutable(build, workspace, launcher, listener);
        }
        EnvVars vars = build.getEnvironment(listener);
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(sourceanalyzer);
        args.add("-Dcom.fortify.sca.ProjectRoot=" + projectRoot);
        args.add("-clean");
        args.add("-b");
        args.add(this.getResolvedBuildID(listener));
        Integer intOption = this.getResolvedMaxHeap(listener);
        if (intOption != null) {
            args.add("-Xmx" + intOption + "M");
        }
        if (StringUtils.isNotEmpty((String)(option = this.getResolvedAddJVMOptions(listener)))) {
            this.addAllArguments(args, option);
        }
        if (StringUtils.isNotEmpty((String)(option = this.getResolvedLogFile(listener)))) {
            args.add("-logfile");
            args.add(option);
        }
        if (this.getDebug()) {
            args.add("-debug");
        }
        if (this.getVerbose()) {
            args.add("-verbose");
        }
        Launcher.ProcStarter ps = launcher.decorateByEnv(vars).launch().pwd(workspace).cmds(args).envs((Map)vars).stdout((OutputStream)listener.getLogger()).stderr((OutputStream)listener.getLogger());
        int exitcode = ps.join();
        log.println(Messages.FortifyClean_Result(exitcode));
        if (exitcode != 0) {
            build.setResult(Result.FAILURE);
            throw new AbortException(Messages.FortifyClean_Error());
        }
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private transient FortifyClean fc;
        private static final long serialVersionUID = 1L;

        protected Execution(FortifyClean fc, StepContext context) {
            super(context);
            this.fc = fc;
        }

        protected Void run() throws Exception {
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Running FortifyClean step");
            if (!((FilePath)this.getContext().get(FilePath.class)).exists()) {
                ((FilePath)this.getContext().get(FilePath.class)).mkdirs();
            }
            this.fc.perform((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "fortifyClean";
        }

        public String getDisplayName() {
            return Messages.FortifyClean_DisplayName();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, Launcher.class, TaskListener.class);
        }

        public FormValidation doCheckBuildID(@QueryParameter String value) {
            return Validators.checkFieldNotEmpty(value);
        }

        public FormValidation doCheckMaxHeap(@QueryParameter String value) {
            return Validators.checkValidInteger(value);
        }
    }
}

