/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.FortifyPlugin;
import com.fortify.plugin.jenkins.steps.FortifyCloudScanStep;
import com.fortify.plugin.jenkins.steps.remote.GradleProjectType;
import com.fortify.plugin.jenkins.steps.remote.MavenProjectType;
import com.fortify.plugin.jenkins.steps.remote.PhpProjectType;
import com.fortify.plugin.jenkins.steps.remote.PythonProjectType;
import com.fortify.plugin.jenkins.steps.remote.RemoteAnalysisProjectType;
import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ComboBoxModel;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CloudScanStart
extends FortifyCloudScanStep
implements SimpleBuildStep {
    private RemoteAnalysisProjectType remoteAnalysisProjectType;
    private FortifyPlugin.RemoteOptionalConfigBlock remoteOptionalConfig;
    private FortifyPlugin.UploadSSCBlock uploadSSC;
    private String buildID;

    @DataBoundConstructor
    public CloudScanStart(RemoteAnalysisProjectType remoteAnalysisProjectType) {
        this.remoteAnalysisProjectType = remoteAnalysisProjectType;
    }

    public RemoteAnalysisProjectType getRemoteAnalysisProjectType() {
        return this.remoteAnalysisProjectType;
    }

    public FortifyPlugin.RemoteOptionalConfigBlock getRemoteOptionalConfig() {
        return this.remoteOptionalConfig;
    }

    @DataBoundSetter
    public void setRemoteOptionalConfig(FortifyPlugin.RemoteOptionalConfigBlock remoteOptionalConfig) {
        this.remoteOptionalConfig = remoteOptionalConfig;
    }

    public FortifyPlugin.UploadSSCBlock getUploadSSC() {
        return this.uploadSSC;
    }

    @DataBoundSetter
    public void setUploadSSC(FortifyPlugin.UploadSSCBlock uploadSSC) {
        this.uploadSSC = uploadSSC;
    }

    public String getBuildTool() {
        if (this.remoteAnalysisProjectType == null) {
            return null;
        }
        if (this.getRemoteAnalysisProjectType() instanceof GradleProjectType) {
            return "gradle";
        }
        if (this.getRemoteAnalysisProjectType() instanceof MavenProjectType) {
            return "mvn";
        }
        return "none";
    }

    public String getBuildFile() {
        if (this.getRemoteAnalysisProjectType() instanceof GradleProjectType) {
            return ((GradleProjectType)this.remoteAnalysisProjectType).getBuildFile();
        }
        if (this.getRemoteAnalysisProjectType() instanceof MavenProjectType) {
            return ((MavenProjectType)this.remoteAnalysisProjectType).getBuildFile();
        }
        return "";
    }

    public boolean isIncludeTests() {
        if (this.getRemoteAnalysisProjectType() instanceof GradleProjectType) {
            return ((GradleProjectType)this.remoteAnalysisProjectType).getIncludeTests();
        }
        if (this.getRemoteAnalysisProjectType() instanceof MavenProjectType) {
            return ((MavenProjectType)this.remoteAnalysisProjectType).getIncludeTests();
        }
        return false;
    }

    public String getSensorPoolName() {
        return this.getRemoteOptionalConfig() == null ? "" : this.getRemoteOptionalConfig().getSensorPoolUUID();
    }

    public String getEmailAddr() {
        return this.getRemoteOptionalConfig() == null ? "" : this.getRemoteOptionalConfig().getNotifyEmail();
    }

    public String getRulepacks() {
        return this.getRemoteOptionalConfig() == null ? "" : this.getRemoteOptionalConfig().getCustomRulepacks();
    }

    public String getFilterFile() {
        return this.getRemoteOptionalConfig() == null ? "" : this.getRemoteOptionalConfig().getFilterFile();
    }

    public String getApplicationName() {
        return this.getUploadSSC() == null ? "" : this.getUploadSSC().getAppName();
    }

    public String getApplicationVersion() {
        return this.getUploadSSC() == null ? "" : this.getUploadSSC().getAppVersion();
    }

    public String getPythonRequirementsFile() {
        return this.getRemoteAnalysisProjectType() instanceof PythonProjectType ? ((PythonProjectType)this.remoteAnalysisProjectType).getPythonRequirementsFile() : "";
    }

    public String getPythonVersion() {
        return this.getRemoteAnalysisProjectType() instanceof PythonProjectType ? ((PythonProjectType)this.remoteAnalysisProjectType).getPythonVersion() : "";
    }

    public String getPythonVirtualEnv() {
        return this.getRemoteAnalysisProjectType() instanceof PythonProjectType ? ((PythonProjectType)this.remoteAnalysisProjectType).getPythonVirtualEnv() : "";
    }

    public String getPhpVersion() {
        return this.getRemoteAnalysisProjectType() instanceof PhpProjectType ? ((PhpProjectType)this.remoteAnalysisProjectType).getPhpVersion() : "";
    }

    public String getBuildID() {
        return this.buildID;
    }

    public void setBuildID(String buildID) {
        this.buildID = buildID;
    }

    public String getResolvedBuildTool(TaskListener listener) {
        return this.resolve(this.getBuildTool(), listener);
    }

    public String getResolvedBuildFile(TaskListener listener) {
        return this.resolve(this.getBuildFile(), listener);
    }

    public String getResolvedSensorPoolName(TaskListener listener) {
        return this.resolve(this.getSensorPoolName(), listener);
    }

    public String getResolvedEmailAddr(TaskListener listener) {
        return this.resolve(this.getEmailAddr(), listener);
    }

    public String getResolvedRulepacks(TaskListener listener) {
        return this.resolve(this.getRulepacks(), listener);
    }

    public String getResolvedFilterFile(TaskListener listener) {
        return this.resolve(this.getFilterFile(), listener);
    }

    public String getResolvedBuildID(TaskListener listener) {
        return this.resolve(this.getBuildID(), listener);
    }

    public String getResolvedApplicationName(TaskListener listener) {
        return this.resolve(this.getApplicationName(), listener);
    }

    public String getResolvedApplicationVersion(TaskListener listener) {
        return this.resolve(this.getApplicationVersion(), listener);
    }

    public String getResolvedPythonRequirementsFile(TaskListener listener) {
        return this.resolve(this.getPythonRequirementsFile(), listener);
    }

    public String getResolvedPythonVersion(TaskListener listener) {
        return this.resolve(this.getPythonVersion(), listener);
    }

    public String getResolvedPythonVirtualEnv(TaskListener listener) {
        return this.resolve(this.getPythonVirtualEnv(), listener);
    }

    public String getResolvedPhpVersion(TaskListener listener) {
        return this.resolve(this.getPhpVersion(), listener);
    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        String cloudscanExec;
        this.setLastBuild(run);
        PrintStream log = taskListener.getLogger();
        log.println("Fortify Jenkins plugin v " + VERSION);
        log.println("Performing Fortify remote analysis");
        String projectRoot = filePath.getRemote() + File.separator + ".fortify";
        try {
            cloudscanExec = this.getScancentralExecutable(run, filePath, launcher, taskListener);
        }
        catch (FileNotFoundException ex) {
            log.println("WARNING: Cannot find scancentral executable");
            try {
                cloudscanExec = this.getCloudScanExecutable(run, filePath, launcher, taskListener);
            }
            catch (FileNotFoundException exception) {
                throw new RuntimeException("Cannot find cloudscan executable");
            }
        }
        EnvVars vars = run.getEnvironment(taskListener);
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(cloudscanExec);
        if (FortifyPlugin.DESCRIPTOR.getUrl() != null) {
            args.add("-sscurl");
            args.add(FortifyPlugin.DESCRIPTOR.getUrl());
            args.add("-ssctoken");
            args.add(FortifyPlugin.DESCRIPTOR.getCtrlToken());
        } else if (FortifyPlugin.DESCRIPTOR.getCtrlUrl() != null) {
            args.add("-url");
            args.add(FortifyPlugin.DESCRIPTOR.getCtrlUrl());
        } else {
            throw new AbortException("Fortify remote analysis execution failed: No SSC or Controller URL found");
        }
        args.add("start");
        if (StringUtils.isNotEmpty((String)this.getResolvedBuildTool(taskListener))) {
            args.add("-bt");
            args.add(this.getResolvedBuildTool(taskListener));
            if (this.getResolvedBuildTool(taskListener).equals("none")) {
                if (StringUtils.isNotEmpty((String)this.getResolvedPhpVersion(taskListener))) {
                    args.add("-hv");
                    args.add(this.getResolvedPhpVersion(taskListener));
                }
                if (StringUtils.isNotEmpty((String)this.getResolvedPythonRequirementsFile(taskListener))) {
                    args.add("-pyr");
                    args.add(this.getResolvedPythonRequirementsFile(taskListener));
                }
                if (StringUtils.isNotEmpty((String)this.getResolvedPythonVersion(taskListener))) {
                    args.add("-yv");
                    args.add(this.getResolvedPythonVersion(taskListener));
                }
                if (StringUtils.isNotEmpty((String)this.getResolvedPythonVirtualEnv(taskListener))) {
                    args.add("-pyv");
                    args.add(this.getResolvedPythonVirtualEnv(taskListener));
                }
            } else {
                if (StringUtils.isNotEmpty((String)this.getResolvedBuildFile(taskListener))) {
                    args.add("-bf");
                    args.add(this.getResolvedBuildFile(taskListener));
                }
                if (this.isIncludeTests()) {
                    args.add("-t");
                }
            }
        } else {
            args.add("-b");
            args.add(this.getResolvedBuildID(taskListener));
            args.add("-project-root");
            args.add(projectRoot);
        }
        if (StringUtils.isNotEmpty((String)this.getResolvedEmailAddr(taskListener))) {
            args.add("-email");
            args.add(this.getResolvedEmailAddr(taskListener));
        }
        if (StringUtils.isNotEmpty((String)this.getResolvedSensorPoolName(taskListener))) {
            args.add("-pool");
            args.add(this.getResolvedSensorPoolName(taskListener));
        }
        if (StringUtils.isNotEmpty((String)this.getResolvedApplicationName(taskListener))) {
            args.add("-upload");
            args.add("-application");
            args.add(this.getResolvedApplicationName(taskListener));
            args.add("-version");
            args.add(this.getResolvedApplicationVersion(taskListener));
            args.add("-uptoken");
            args.add(FortifyPlugin.DESCRIPTOR.getCtrlToken());
        }
        if (StringUtils.isNotEmpty((String)this.getResolvedRulepacks(taskListener))) {
            this.addAllArguments(args, this.getResolvedRulepacks(taskListener), "-rules");
        }
        if (StringUtils.isNotEmpty((String)this.getResolvedFilterFile(taskListener))) {
            this.addAllArguments(args, this.getResolvedFilterFile(taskListener), "-filter");
        }
        if (StringUtils.isEmpty((String)this.getResolvedBuildTool(taskListener))) {
            args.add("-scan");
            if (StringUtils.isNotEmpty((String)this.getResolvedScanArgs(taskListener))) {
                args.add(this.getResolvedScanArgs(taskListener));
            }
        }
        Launcher.ProcStarter ps = launcher.decorateByEnv(vars).launch().pwd(filePath).cmds(args).envs((Map)vars).stdout((OutputStream)taskListener.getLogger()).stderr((OutputStream)taskListener.getLogger());
        int exitcode = ps.join();
        log.println("Fortify remote analysis completed with exit code: " + exitcode);
        if (exitcode != 0) {
            run.setResult(Result.FAILURE);
            throw new AbortException("Fortify remote analysis execution failed.");
        }
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private transient CloudScanStart csStart;
        private static final long serialVersionUID = 1L;

        protected Execution(CloudScanStart csStart, StepContext context) {
            super(context);
            this.csStart = csStart;
        }

        protected Void run() throws Exception {
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Running Fortify remote analysis step");
            if (!((FilePath)this.getContext().get(FilePath.class)).exists()) {
                ((FilePath)this.getContext().get(FilePath.class)).mkdirs();
            }
            this.csStart.perform((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getFunctionName() {
            return "fortifyRemoteAnalysis";
        }

        public String getDisplayName() {
            return "Upload a project for remote Fortify SCA analysis";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, Launcher.class, TaskListener.class);
        }

        public void doRefreshProjects(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value) throws Exception {
            FortifyPlugin.DESCRIPTOR.doRefreshProjects(req, rsp, value);
        }

        public void doRefreshVersions(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value) throws Exception {
            FortifyPlugin.DESCRIPTOR.doRefreshVersions(req, rsp, value);
        }

        public ComboBoxModel doFillAppNameItems() {
            return FortifyPlugin.DESCRIPTOR.doFillAppNameItems();
        }

        public ComboBoxModel doFillAppVersionItems(@QueryParameter String appName) {
            return FortifyPlugin.DESCRIPTOR.doFillAppVersionItems(appName);
        }

        public ListBoxModel doFillSensorPoolUUIDItems() {
            return FortifyPlugin.DESCRIPTOR.doFillSensorPoolUUIDItems();
        }
    }
}

