/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.steps;

import com.fortify.plugin.jenkins.steps.FortifyCloudScanStep;
import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CloudScanArguments
extends FortifyCloudScanStep
implements SimpleBuildStep {
    protected String transOptions;

    @DataBoundConstructor
    public CloudScanArguments() {
    }

    public String getTransOptions() {
        return this.transOptions;
    }

    @DataBoundSetter
    public void setTransOptions(String transOptions) {
        this.transOptions = transOptions;
    }

    public String getResolvedTransArgs(TaskListener listener) {
        return this.resolve(this.getTransOptions(), listener);
    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        String cloudscanExec;
        this.setLastBuild(run);
        PrintStream log = taskListener.getLogger();
        log.println("Fortify Jenkins plugin v " + VERSION);
        log.println("Launching Fortify scancentral arguments command");
        try {
            cloudscanExec = this.getScancentralExecutable(run, filePath, launcher, taskListener);
        }
        catch (FileNotFoundException ex) {
            log.println("WARNING: Cannot find scancentral executable");
            try {
                cloudscanExec = this.getCloudScanExecutable(run, filePath, launcher, taskListener);
            }
            catch (FileNotFoundException exception) {
                throw new RuntimeException("Cannot find cloudscan executable");
            }
        }
        EnvVars vars = run.getEnvironment(taskListener);
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(cloudscanExec);
        args.add("arguments");
        args.add("-o");
        String option = this.getResolvedTransArgs(taskListener);
        if (StringUtils.isNotEmpty((String)option)) {
            this.addAllArguments(args, option, "-targs");
        }
        if (StringUtils.isNotEmpty((String)(option = this.getResolvedScanArgs(taskListener)))) {
            this.addAllArguments(args, option, "-sargs");
        }
        Launcher.ProcStarter ps = launcher.decorateByEnv(vars).launch().pwd(filePath).cmds(args).envs((Map)vars).stdout((OutputStream)taskListener.getLogger()).stderr((OutputStream)taskListener.getLogger());
        int exitcode = ps.join();
        log.println("Fortify scancentral arguments command completed with exit code: " + exitcode);
        if (exitcode != 0) {
            run.setResult(Result.FAILURE);
            throw new AbortException("Fortify scancentral arguments command execution failed.");
        }
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private transient CloudScanArguments csArguments;
        private static final long serialVersionUID = 1L;

        protected Execution(CloudScanArguments csArguments, StepContext context) {
            super(context);
            this.csArguments = csArguments;
        }

        protected Void run() throws Exception {
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Running ScanCentral arguments step");
            if (!((FilePath)this.getContext().get(FilePath.class)).exists()) {
                ((FilePath)this.getContext().get(FilePath.class)).mkdirs();
            }
            this.csArguments.perform((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getFunctionName() {
            return "fortifyRemoteArguments";
        }

        public String getDisplayName() {
            return "Set options for remote Fortify SCA analysis";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, Launcher.class, TaskListener.class);
        }
    }
}

