/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.bean;

import com.fortify.plugin.jenkins.FortifyPlugin;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

public class IssueFolderBean
implements Comparable {
    public static final String ATTRIBUTE_VALUE_ALL = "All";
    public static final String NAME_CRITICAL = "Critical";
    public static final String NAME_HIGH = "High";
    public static final String NAME_MEDIUM = "Medium";
    public static final String NAME_LOW = "Low";
    public static final String NAME_HOT = "Hot";
    public static final String NAME_WARNING = "Warning";
    public static final String NAME_INFO = "Info";
    private final String id;
    private final String projectName;
    private final String projectVersion;
    private final String name;
    private final String description;
    private final String color;
    private int issueCount;
    private int issueNewCount;
    private String url;

    public IssueFolderBean(String id, String projectName, String projectVersion, List<String> attributes) {
        this.id = id;
        this.projectName = projectName;
        this.projectVersion = projectVersion;
        this.name = attributes.get(0);
        this.description = attributes.get(1);
        this.color = attributes.get(2);
        try {
            this.issueCount = Integer.parseInt(attributes.get(3));
            this.issueNewCount = Integer.parseInt(attributes.get(4));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.url = FortifyPlugin.DESCRIPTOR.getUrl() + "/html/ssc/html/index.jsp?projectName=" + URLEncoder.encode(projectName, "UTF-8") + "&projectVersionName=" + URLEncoder.encode(projectVersion, "UTF-8") + "&folder=" + id;
        }
        catch (UnsupportedEncodingException e) {
            this.url = FortifyPlugin.DESCRIPTOR.getUrl() + "/html/ssc/html/index.jsp";
        }
    }

    public String getId() {
        return this.id;
    }

    public String getURL() {
        return this.url;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getColor() {
        return this.color;
    }

    public int getIssueCount() {
        return this.issueCount;
    }

    public int getIssueNewCount() {
        return this.issueNewCount;
    }

    public boolean isEmpty() {
        return this.issueCount == 0;
    }

    public int compareTo(Object o) {
        IssueFolderBean otherBean = (IssueFolderBean)o;
        return otherBean.getId().compareTo(this.getId());
    }

    public boolean equals(Object obj) {
        if (obj instanceof IssueFolderBean) {
            return ((IssueFolderBean)obj).getId().equals(this.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

