/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins.bean;

import com.fortify.plugin.jenkins.FortifyPlugin;
import com.fortify.plugin.jenkins.PathUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;

public class IssueBean
implements Comparable {
    public static final String ATTRIBUTE_VALUE_NONE = "<none>";
    private Long projectVersionId;
    private Long issueId;
    private String issueInstanceId;
    private String projectName;
    private String projectVersionName;
    private String sourceFilePath;
    private String filePath;
    private String lineNumber;
    private String packageName;
    private String className;
    private String function;
    private String groupName;
    private String category;
    private String mappedCategory;
    private String type;
    private String subType;
    private String confidence;
    private String severity;
    private String engineType;
    private String assignedUser;

    public static String escapeHtmlTags(String unsafeString) {
        if (unsafeString != null) {
            unsafeString = unsafeString.replaceAll("<", "&lt;");
            unsafeString = unsafeString.replaceAll(">", "&gt;");
        }
        return unsafeString;
    }

    public String getDisplayName() {
        StringBuffer label = new StringBuffer();
        String shortfilename = PathUtils.getShortFileName(this.getFilePath());
        if (StringUtils.isBlank((String)shortfilename)) {
            shortfilename = ATTRIBUTE_VALUE_NONE;
        }
        label.append(shortfilename).append(':').append(this.lineNumber);
        return IssueBean.escapeHtmlTags(label.toString());
    }

    public String getDisplayTypeName() {
        StringBuffer label = new StringBuffer();
        label.append(this.type);
        if (StringUtils.isNotBlank((String)this.subType)) {
            label.append(':').append(this.subType);
        }
        return IssueBean.escapeHtmlTags(label.toString());
    }

    public String getDisplayMappedCategory() {
        return IssueBean.escapeHtmlTags(this.mappedCategory);
    }

    public String getDisplayPath() {
        return IssueBean.escapeHtmlTags(PathUtils.getPath(this.getFilePath()));
    }

    public String getURL() {
        try {
            return FortifyPlugin.DESCRIPTOR.getUrl() + "/html/ssc/version/" + this.projectVersionId + "/fix/" + this.issueId + "/?projectName=" + URLEncoder.encode(this.projectName, "UTF-8") + "&projectVersionName=" + URLEncoder.encode(this.projectVersionName, "UTF-8") + "&issue=" + this.issueInstanceId + "&engineType=" + URLEncoder.encode(this.engineType, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public Long getProjectVersionId() {
        return this.projectVersionId;
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public String getIssueInstanceId() {
        return this.issueInstanceId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersionName() {
        return this.projectVersionName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getLineNumber() {
        return this.lineNumber;
    }

    public boolean isNew() {
        return true;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFunction() {
        return this.function;
    }

    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getAssignedUser() {
        return this.assignedUser;
    }

    public String getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public String getConfidence() {
        return this.confidence;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getMappedCategory() {
        return this.mappedCategory;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public void setProjectVersionId(Long projectVersionId) {
        this.projectVersionId = projectVersionId;
    }

    public void setIssueId(Long issueId) {
        this.issueId = issueId;
    }

    public void setIssueInstanceId(String issueInstanceId) {
        this.issueInstanceId = issueInstanceId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setProjectVersionName(String projectVersionName) {
        this.projectVersionName = projectVersionName;
    }

    public void setSourceFilePath(String sourceFilePath) {
        this.sourceFilePath = sourceFilePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setMappedCategory(String mappedCategory) {
        this.mappedCategory = mappedCategory;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public void setConfidence(String confidence) {
        this.confidence = confidence;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public void setAssignedUser(String assignedUser) {
        this.assignedUser = assignedUser;
    }

    public int compareTo(Object o) {
        IssueBean otherBean = (IssueBean)o;
        return otherBean.getIssueInstanceId().compareTo(this.getIssueInstanceId());
    }

    public boolean equals(Object obj) {
        if (obj instanceof IssueBean) {
            return ((IssueBean)obj).getIssueInstanceId().equals(this.getIssueInstanceId());
        }
        return false;
    }

    public int hashCode() {
        return this.getIssueInstanceId().hashCode();
    }
}

