/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins;

import java.util.logging.Level;

public class Message {
    public static final int NONE = 0;
    public static final int INFORMATIONAL = 1;
    public static final int INFO_VERBOSE = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    public static final int LOG = 5;
    public static final int INTERNAL_WARNING = 6;
    public static final int EXCEPTION = 7;
    public static final int BUG = 8;
    public static final int LOG_VERBOSE = 9;
    public static final int LOG_STATUS = 10;
    public static final int DEFAULT_ERROR_CODE = -1;
    private Level level;
    private Throwable throwable;
    private String message;
    private int severity;
    private final int errorCode;

    public Message(int errorCode, Level level, int severity, Throwable throwable, String message) {
        this.level = level;
        this.throwable = throwable;
        this.message = message;
        this.severity = severity;
        this.errorCode = errorCode;
    }

    public Message(int severity, String message) {
        this(-1, Level.OFF, severity, null, message);
    }

    public Message(int severity, int errorCode, Object ... parameters) {
        this(errorCode, Level.OFF, severity, null, null);
    }

    public String getMessage() {
        return this.message;
    }

    public Level getLogLevel() {
        if (this.level != Level.OFF) {
            return this.level;
        }
        switch (this.severity) {
            case 0: {
                return Level.ALL;
            }
            case 1: {
                return Level.INFO;
            }
            case 2: {
                return Level.INFO;
            }
            case 3: {
                return Level.WARNING;
            }
            case 4: {
                return Level.SEVERE;
            }
            case 5: {
                return Level.FINE;
            }
            case 6: {
                return Level.WARNING;
            }
            case 7: {
                return Level.SEVERE;
            }
            case 8: {
                return Level.SEVERE;
            }
            case 9: {
                return Level.FINE;
            }
            case 10: {
                return Level.INFO;
            }
        }
        return Level.WARNING;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public boolean hasErrorCode() {
        return this.errorCode != -1;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public static Message mk(int ec) {
        return new Message(0, ec, new Object[0]);
    }
}

