/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins;

import com.fortify.plugin.jenkins.FortifyException;
import com.fortify.plugin.jenkins.Message;
import com.fortify.plugin.jenkins.bean.ProjectTemplateBean;
import com.fortify.plugin.jenkins.bean.SensorPoolBean;
import com.fortify.plugin.jenkins.fortifyclient.FortifyClient;
import com.fortify.plugin.jenkins.steps.CloudScanArguments;
import com.fortify.plugin.jenkins.steps.CloudScanMbs;
import com.fortify.plugin.jenkins.steps.CloudScanStart;
import com.fortify.plugin.jenkins.steps.FortifyClean;
import com.fortify.plugin.jenkins.steps.FortifyScan;
import com.fortify.plugin.jenkins.steps.FortifyTranslate;
import com.fortify.plugin.jenkins.steps.FortifyUpdate;
import com.fortify.plugin.jenkins.steps.FortifyUpload;
import com.fortify.plugin.jenkins.steps.remote.GradleProjectType;
import com.fortify.plugin.jenkins.steps.remote.MavenProjectType;
import com.fortify.plugin.jenkins.steps.remote.RemoteAnalysisProjectType;
import com.fortify.plugin.jenkins.steps.types.AdvancedScanType;
import com.fortify.plugin.jenkins.steps.types.DevenvScanType;
import com.fortify.plugin.jenkins.steps.types.DotnetSourceScanType;
import com.fortify.plugin.jenkins.steps.types.GradleScanType;
import com.fortify.plugin.jenkins.steps.types.JavaScanType;
import com.fortify.plugin.jenkins.steps.types.MavenScanType;
import com.fortify.plugin.jenkins.steps.types.MsbuildScanType;
import com.fortify.plugin.jenkins.steps.types.OtherScanType;
import com.fortify.plugin.jenkins.steps.types.ProjectScanType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import hudson.Extension;
import hudson.Launcher;
import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class FortifyPlugin
extends Recorder {
    private static String pluginVersion;
    private static Object syncObj;
    public static final int DEFAULT_PAGE_SIZE = 50;
    private transient UploadSSCBlock uploadSSC;
    private transient RunTranslationBlock runTranslation;
    private transient RunScanBlock runScan;
    private transient UpdateContentBlock updateContent;
    private transient boolean runSCAClean;
    private transient String buildId;
    private transient String scanFile;
    private transient String maxHeap;
    private transient String addJVMOptions;
    private AnalysisRunType analysisRunType;
    @Extension
    public static final DescriptorImpl DESCRIPTOR;

    public static String getPluginVersion() {
        Plugin plugin;
        if (pluginVersion == null && (plugin = Jenkins.get().getPlugin("fortify")) != null) {
            pluginVersion = plugin.getWrapper().getVersion();
        }
        return pluginVersion;
    }

    @DataBoundConstructor
    public FortifyPlugin(AnalysisRunType analysisRunType) {
        this.analysisRunType = analysisRunType;
    }

    @Deprecated
    public FortifyPlugin(String buildId, String scanFile, String maxHeap, String addJVMOptions, UpdateContentBlock updateContent, boolean runSCAClean, RunTranslationBlock runTranslation, RunScanBlock runScan, UploadSSCBlock uploadSSC) {
        this.buildId = buildId;
        this.scanFile = scanFile;
        this.maxHeap = maxHeap;
        this.addJVMOptions = addJVMOptions;
        this.updateContent = updateContent;
        this.runSCAClean = runSCAClean;
        this.runTranslation = runTranslation;
        this.runScan = runScan;
        this.uploadSSC = uploadSSC;
    }

    protected Object readResolve() {
        if (this.runTranslation != null) {
            this.analysisRunType = new AnalysisRunType("local");
            if (this.updateContent != null) {
                this.analysisRunType.setUpdateContent(this.updateContent);
            }
            if (this.buildId != null) {
                this.analysisRunType.setBuildId(this.buildId);
            }
            if (this.scanFile != null) {
                this.analysisRunType.setScanFile(this.scanFile);
            }
            if (this.maxHeap != null) {
                this.analysisRunType.setMaxHeap(this.maxHeap);
            }
            if (this.addJVMOptions != null) {
                this.analysisRunType.setAddJVMOptions(this.addJVMOptions);
            }
            this.analysisRunType.setTranslationDebug(this.runTranslation.getTranslationDebug());
            this.analysisRunType.setTranslationVerbose(this.runTranslation.getTranslationVerbose());
            this.analysisRunType.setTranslationLogFile(this.runTranslation.getTranslationLogFile());
            this.analysisRunType.setTranslationExcludeList(this.runTranslation.getTranslationExcludeList());
            ProjectScanType scanType = null;
            if (this.runTranslation.isAdvancedTranslationType()) {
                scanType = new AdvancedScanType();
                scanType.setAdvOptions(this.runTranslation.getTranslationOptions());
            }
            if (this.runTranslation.isBasicMaven3TranslationType()) {
                scanType = new MavenScanType();
                ((MavenScanType)scanType).setMavenOptions(this.runTranslation.getMaven3Options());
            }
            if (this.runTranslation.isBasicGradleTranslationType()) {
                scanType = new GradleScanType();
                ((GradleScanType)scanType).setUseWrapper(this.runTranslation.getGradleUseWrapper());
                ((GradleScanType)scanType).setGradleTasks(this.runTranslation.getGradleTasks());
                ((GradleScanType)scanType).setGradleOptions(this.runTranslation.getGradleOptions());
            }
            if (this.runTranslation.isBasicJavaTranslationType()) {
                scanType = new JavaScanType();
                ((JavaScanType)scanType).setJavaVersion(this.runTranslation.getTranslationJavaVersion());
                ((JavaScanType)scanType).setJavaClasspath(this.runTranslation.getTranslationClasspath());
                ((JavaScanType)scanType).setJavaSrcFiles(this.runTranslation.getTranslationSourceFiles());
                ((JavaScanType)scanType).setJavaAddOptions(this.runTranslation.getTranslationAddOptions());
            }
            if (this.runTranslation.isBasicDotNetDevenvBuildType()) {
                scanType = new DevenvScanType();
                ((DevenvScanType)scanType).setDotnetProject(this.runTranslation.getDotNetDevenvProjects());
                ((DevenvScanType)scanType).setDotnetAddOptions(this.runTranslation.getDotNetDevenvAddOptions());
            }
            if (this.runTranslation.isBasicDotNetMSBuildBuildType()) {
                scanType = new MsbuildScanType();
                ((MsbuildScanType)scanType).setDotnetProject(this.runTranslation.getDotNetMSBuildProjects());
                ((MsbuildScanType)scanType).setDotnetAddOptions(this.runTranslation.getDotNetMSBuildAddOptions());
            }
            if (this.runTranslation.isBasicDotNetSourceCodeScanType()) {
                scanType = new DotnetSourceScanType();
                ((DotnetSourceScanType)scanType).setDotnetFrameworkVersion(this.runTranslation.getDotNetSourceCodeFrameworkVersion());
                ((DotnetSourceScanType)scanType).setDotnetLibdirs(this.runTranslation.getDotNetSourceCodeLibdirs());
                ((DotnetSourceScanType)scanType).setDotnetSrcFiles(this.runTranslation.getDotNetSourceCodeSrcFiles());
                ((DotnetSourceScanType)scanType).setDotnetAddOptions(this.runTranslation.getDotNetSourceCodeAddOptions());
            }
            if (this.runTranslation.isBasicOtherTranslationType()) {
                scanType = new OtherScanType();
                ((OtherScanType)scanType).setOtherIncludesList(this.runTranslation.getOtherIncludesList());
                ((OtherScanType)scanType).setOtherOptions(this.runTranslation.getOtherOptions());
            }
            if (scanType != null) {
                this.analysisRunType.setProjectScanType(scanType);
            }
        }
        if (this.runScan != null) {
            this.analysisRunType.setRunScan(this.runScan);
        }
        if (this.uploadSSC != null) {
            this.analysisRunType.setUploadSSC(this.uploadSSC);
        }
        return this;
    }

    public boolean getAnalysisRunType() {
        return this.analysisRunType != null;
    }

    public RemoteAnalysisProjectType getRemoteAnalysisProjectType() {
        return this.getAnalysisRunType() ? this.analysisRunType.getRemoteAnalysisProjectType() : null;
    }

    public ProjectScanType getProjectScanType() {
        return this.getAnalysisRunType() ? this.analysisRunType.getProjectScanType() : null;
    }

    public boolean isRemote() {
        return this.getAnalysisRunType() && this.analysisRunType.value.equals("remote");
    }

    public boolean isMixed() {
        return this.getAnalysisRunType() && this.analysisRunType.value.equals("mixed");
    }

    public boolean isLocal() {
        return this.getAnalysisRunType() && this.analysisRunType.value.equals("local");
    }

    public boolean isUploadOnly() {
        return this.getAnalysisRunType() && this.analysisRunType.value.equals("uploadOnly");
    }

    public boolean isTranslationDebug() {
        return this.getAnalysisRunType() && this.analysisRunType.isTranslationDebug();
    }

    public boolean isTranslationVerbose() {
        return this.getAnalysisRunType() && this.analysisRunType.isTranslationVerbose();
    }

    public String getBuildId() {
        return this.getAnalysisRunType() ? this.analysisRunType.getBuildId() : "";
    }

    public String getScanFile() {
        return this.getAnalysisRunType() ? this.analysisRunType.getScanFile() : "";
    }

    public String getMaxHeap() {
        return this.getAnalysisRunType() ? this.analysisRunType.getMaxHeap() : "";
    }

    public String getAddJVMOptions() {
        return this.getAnalysisRunType() ? this.analysisRunType.getAddJVMOptions() : "";
    }

    public boolean getUpdateContent() {
        return this.getAnalysisRunType() && this.analysisRunType.getUpdateContent() != null;
    }

    @Deprecated
    public boolean getRunTranslation() {
        return this.runTranslation != null;
    }

    public boolean getRunScan() {
        return this.getAnalysisRunType() && this.analysisRunType.getRunScan() != null;
    }

    public boolean getUploadSSC() {
        return this.getAnalysisRunType() && this.analysisRunType.getUploadSSC() != null;
    }

    public String getUpdateServerUrl() {
        return this.getUpdateContent() ? this.analysisRunType.getUpdateContent().getUpdateServerUrl() : "";
    }

    public String getLocale() {
        return this.getUpdateContent() ? this.analysisRunType.getUpdateContent().getLocale() : "";
    }

    @Deprecated
    public boolean getUpdateUseProxy() {
        return this.getUpdateContent() && this.updateContent.getUpdateUseProxy();
    }

    @Deprecated
    public String getUpdateProxyUrl() {
        return this.getUpdateUseProxy() ? this.updateContent.getUpdateProxyUrl() : "";
    }

    @Deprecated
    public String getUpdateProxyUsername() {
        return this.getUpdateUseProxy() ? this.updateContent.getUpdateProxyUsername() : "";
    }

    @Deprecated
    public String getUpdateProxyPassword() {
        return this.getUpdateUseProxy() ? this.updateContent.getUpdateProxyPassword() : "";
    }

    @Deprecated
    public String getTranslationType() {
        return this.getRunTranslation() ? this.runTranslation.getTranslationType() : "";
    }

    @Deprecated
    public boolean getIsBasicTranslationType() {
        return this.getRunTranslation() && this.runTranslation.isBasicTranslationType();
    }

    @Deprecated
    public boolean getIsAdvancedTranslationType() {
        return this.getRunTranslation() && this.runTranslation.isAdvancedTranslationType();
    }

    @Deprecated
    public boolean getIsBasicJavaTranslationType() {
        return this.getRunTranslation() && this.runTranslation.isBasicJavaTranslationType();
    }

    @Deprecated
    public boolean getIsBasicDotNetTranslationType() {
        return this.getRunTranslation() && this.runTranslation.isBasicDotNetTranslationType();
    }

    @Deprecated
    public boolean getIsBasicMaven3TranslationType() {
        return this.getRunTranslation() && this.runTranslation.isBasicMaven3TranslationType();
    }

    @Deprecated
    public boolean getIsBasicGradleTranslationType() {
        return this.getRunTranslation() && this.runTranslation.isBasicGradleTranslationType();
    }

    @Deprecated
    public boolean getIsBasicOtherTranslationType() {
        return this.getRunTranslation() && this.runTranslation.isBasicOtherTranslationType();
    }

    @Deprecated
    public String getTranslationJavaVersion() {
        return this.getRunTranslation() ? this.runTranslation.getTranslationJavaVersion() : "";
    }

    @Deprecated
    public String getTranslationJavaClasspath() {
        return this.getRunTranslation() ? this.runTranslation.getTranslationClasspath() : "";
    }

    @Deprecated
    public String getTranslationJavaSourceFiles() {
        return this.getRunTranslation() ? this.runTranslation.getTranslationSourceFiles() : "";
    }

    @Deprecated
    public String getTranslationJavaAddOptions() {
        return this.getRunTranslation() ? this.runTranslation.getTranslationAddOptions() : "";
    }

    public String getTranslationExcludeList() {
        return this.getAnalysisRunType() ? this.analysisRunType.getTranslationExcludeList() : "";
    }

    @Deprecated
    public String getTranslationOptions() {
        return this.getRunTranslation() ? this.runTranslation.getTranslationOptions() : "";
    }

    @Deprecated
    public boolean getTranslationDebug() {
        return this.getRunTranslation() && this.runTranslation.getTranslationDebug();
    }

    @Deprecated
    public boolean getTranslationVerbose() {
        return this.getRunTranslation() && this.runTranslation.getTranslationVerbose();
    }

    public String getTranslationLogFile() {
        return this.getAnalysisRunType() ? this.analysisRunType.getTranslationLogFile() : "";
    }

    @Deprecated
    public boolean getIsBasicDotNetProjectSolutionScanType() {
        return this.getRunTranslation() && this.runTranslation.isBasicDotNetProjectSolutionScanType();
    }

    @Deprecated
    public boolean getIsBasicDotNetSourceCodeScanType() {
        return this.getRunTranslation() && this.runTranslation.isBasicDotNetSourceCodeScanType();
    }

    @Deprecated
    public boolean getIsBasicDotNetDevenvBuildType() {
        return this.getRunTranslation() && this.runTranslation.isBasicDotNetDevenvBuildType();
    }

    @Deprecated
    public boolean getIsBasicDotNetMSBuildBuildType() {
        return this.getRunTranslation() && this.runTranslation.isBasicDotNetMSBuildBuildType();
    }

    @Deprecated
    public String getDotNetDevenvProjects() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetDevenvProjects() : "";
    }

    @Deprecated
    public String getDotNetDevenvAddOptions() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetDevenvAddOptions() : "";
    }

    @Deprecated
    public String getDotNetMSBuildProjects() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetMSBuildProjects() : "";
    }

    @Deprecated
    public String getDotNetMSBuildAddOptions() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetMSBuildAddOptions() : "";
    }

    @Deprecated
    public String getDotNetSourceCodeFrameworkVersion() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetSourceCodeFrameworkVersion() : "";
    }

    @Deprecated
    public String getDotNetSourceCodeLibdirs() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetSourceCodeLibdirs() : "";
    }

    @Deprecated
    public String getDotNetSourceCodeAddOptions() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetSourceCodeAddOptions() : "";
    }

    @Deprecated
    public String getDotNetSourceCodeSrcFiles() {
        return this.getRunTranslation() ? this.runTranslation.getDotNetSourceCodeSrcFiles() : "";
    }

    @Deprecated
    public String getMaven3Options() {
        return this.getRunTranslation() ? this.runTranslation.getMaven3Options() : "";
    }

    @Deprecated
    public boolean getGradleUseWrapper() {
        return this.getRunTranslation() && this.runTranslation.getGradleUseWrapper();
    }

    @Deprecated
    public String getGradleTasks() {
        return this.getRunTranslation() ? this.runTranslation.getGradleTasks() : "";
    }

    @Deprecated
    public String getGradleOptions() {
        return this.getRunTranslation() ? this.runTranslation.getGradleOptions() : "";
    }

    @Deprecated
    public String getOtherOptions() {
        return this.getRunTranslation() ? this.runTranslation.getOtherOptions() : "";
    }

    @Deprecated
    public String getOtherIncludesList() {
        return this.getRunTranslation() ? this.runTranslation.getOtherIncludesList() : "";
    }

    public String getScanCustomRulepacks() {
        return this.getRunScan() ? this.analysisRunType.getRunScan().getScanCustomRulepacks() : "";
    }

    public String getScanAddOptions() {
        return this.getRunScan() ? this.analysisRunType.getRunScan().getScanAddOptions() : "";
    }

    public boolean getScanDebug() {
        return this.getRunScan() && this.analysisRunType.getRunScan().getScanDebug();
    }

    public boolean getScanVerbose() {
        return this.getRunScan() && this.analysisRunType.getRunScan().getScanVerbose();
    }

    public String getScanLogFile() {
        return this.getRunScan() ? this.analysisRunType.getRunScan().getScanLogFile() : "";
    }

    public String getFilterSet() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getFilterSet() : "";
    }

    public String getSearchCondition() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getSearchCondition() : "";
    }

    @Deprecated
    public String getProjectName() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getProjectName() : "";
    }

    public String getAppName() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getAppName() : "";
    }

    @Deprecated
    public String getProjectVersion() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getProjectVersion() : "";
    }

    public String getAppVersion() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getAppVersion() : "";
    }

    @Deprecated
    public String getUploadWaitTime() {
        return this.uploadSSC == null ? null : this.uploadSSC.getPollingInterval();
    }

    public String getTimeout() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getTimeout() : "";
    }

    public String getPollingInterval() {
        return this.getUploadSSC() ? this.analysisRunType.getUploadSSC().getPollingInterval() : "";
    }

    public boolean getRemoteOptionalConfig() {
        return !this.isLocal() && !this.isUploadOnly() && this.analysisRunType.getRemoteOptionalConfig() != null;
    }

    public String getSensorPoolUUID() {
        return this.getRemoteOptionalConfig() ? this.analysisRunType.getRemoteOptionalConfig().getSensorPoolUUID() : "";
    }

    public String getNotifyEmail() {
        return this.getRemoteOptionalConfig() ? this.analysisRunType.getRemoteOptionalConfig().getNotifyEmail() : "";
    }

    public String getScanOptions() {
        return this.getRemoteOptionalConfig() ? this.analysisRunType.getRemoteOptionalConfig().getScanOptions() : "";
    }

    public String getCustomRulepacks() {
        return this.getRemoteOptionalConfig() ? this.analysisRunType.getRemoteOptionalConfig().getCustomRulepacks() : "";
    }

    public String getFilterFile() {
        return this.getRemoteOptionalConfig() ? this.analysisRunType.getRemoteOptionalConfig().getFilterFile() : "";
    }

    public String getBuildTool() {
        if (!this.getAnalysisRunType()) {
            return "";
        }
        if (this.getRemoteAnalysisProjectType() instanceof GradleProjectType) {
            return "gradle";
        }
        if (this.getRemoteAnalysisProjectType() instanceof MavenProjectType) {
            return "mvn";
        }
        return "none";
    }

    public String getBuildFile() {
        if (!this.getAnalysisRunType()) {
            return "";
        }
        if (this.getRemoteAnalysisProjectType() instanceof GradleProjectType) {
            return ((GradleProjectType)this.getRemoteAnalysisProjectType()).getBuildFile();
        }
        if (this.getRemoteAnalysisProjectType() instanceof MavenProjectType) {
            return ((MavenProjectType)this.getRemoteAnalysisProjectType()).getBuildFile();
        }
        return "";
    }

    public boolean getIncludeTests() {
        if (this.getAnalysisRunType()) {
            if (this.getRemoteAnalysisProjectType() instanceof GradleProjectType) {
                return ((GradleProjectType)this.getRemoteAnalysisProjectType()).getIncludeTests();
            }
            if (this.getRemoteAnalysisProjectType() instanceof MavenProjectType) {
                return ((MavenProjectType)this.getRemoteAnalysisProjectType()).getIncludeTests();
            }
        }
        return false;
    }

    public String getTransArgs() {
        return this.getRemoteAnalysisProjectType() == null ? "" : this.analysisRunType.getTransArgs();
    }

    public String getScanArgs() {
        return this.getRemoteOptionalConfig() ? this.getScanOptions() : "";
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.emptyList();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream log = listener.getLogger();
        log.println("Fortify Jenkins plugin v " + FortifyPlugin.getPluginVersion());
        if (this.isRemote()) {
            this.runRemote(build, launcher, listener);
        } else if (this.isMixed()) {
            this.runMixed(build, launcher, listener);
        } else if (this.isLocal()) {
            this.runLocal(build, launcher, listener);
        } else if (this.isUploadOnly()) {
            this.runUploadOnly(build, launcher, listener);
        }
        return true;
    }

    private void runRemote(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream log = listener.getLogger();
        log.println("Running remote translation and scan.");
        RemoteAnalysisProjectType remoteAnalysisProjectType = this.getRemoteAnalysisProjectType();
        CloudScanStart csStart = new CloudScanStart(remoteAnalysisProjectType);
        CloudScanArguments csArguments = new CloudScanArguments();
        if (this.getRemoteOptionalConfig()) {
            csStart.setRemoteOptionalConfig(this.analysisRunType.getRemoteOptionalConfig());
            csArguments.setScanOptions(this.getScanArgs());
        }
        csArguments.setTransOptions(this.getTransArgs());
        if (StringUtils.isNotEmpty((String)csArguments.getTransOptions()) || StringUtils.isNotEmpty((String)csArguments.getScanOptions())) {
            csArguments.perform(build, launcher, listener);
        }
        if (this.getUploadSSC()) {
            csStart.setUploadSSC(this.analysisRunType.getUploadSSC());
        }
        csStart.perform(build, launcher, listener);
    }

    private void runMixed(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream log = listener.getLogger();
        log.println("Running local translation and remote scan.");
        this.performLocalTranslation(build, launcher, listener);
        CloudScanMbs csMbs = new CloudScanMbs(this.getBuildId());
        if (this.getRemoteOptionalConfig()) {
            csMbs.setRemoteOptionalConfig(this.analysisRunType.getRemoteOptionalConfig());
        }
        if (this.getUploadSSC()) {
            csMbs.setUploadSSC(this.analysisRunType.getUploadSSC());
        }
        csMbs.perform(build, launcher, listener);
    }

    private void runLocal(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        log.println("Running local translation and scan.");
        this.performLocalTranslation(build, launcher, listener);
        if (this.getRunScan()) {
            FortifyScan fs = new FortifyScan(this.getBuildId());
            fs.setAddJVMOptions(this.getAddJVMOptions());
            fs.setMaxHeap(this.getMaxHeap());
            fs.setDebug(this.getScanDebug());
            fs.setVerbose(this.getScanVerbose());
            fs.setLogFile(this.getScanLogFile());
            fs.setResultsFile(this.getScanFile());
            fs.setCustomRulepacks(this.getScanCustomRulepacks());
            fs.setAddOptions(this.getScanAddOptions());
            fs.perform(build, launcher, listener);
        }
        if (this.getUploadSSC()) {
            FortifyUpload upload = new FortifyUpload(false, this.getAppName(), this.getAppVersion());
            upload.setFailureCriteria(this.getSearchCondition());
            upload.setFilterSet(this.getFilterSet());
            upload.setResultsFile(this.getScanFile());
            upload.setTimeout(this.getTimeout());
            upload.setPollingInterval(this.getPollingInterval());
            upload.perform(build, launcher, listener);
        }
    }

    private void runUploadOnly(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        log.println("Running upload-only step.");
        FortifyUpload upload = new FortifyUpload(false, this.getAppName(), this.getAppVersion());
        upload.setFailureCriteria(this.getSearchCondition());
        upload.setFilterSet(this.getFilterSet());
        upload.setResultsFile(this.getScanFile());
        upload.setPollingInterval(this.getPollingInterval());
        upload.perform(build, launcher, listener);
    }

    private void performLocalTranslation(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.getUpdateContent()) {
            FortifyUpdate fu = new FortifyUpdate.Builder().updateServerURL(this.getUpdateServerUrl()).locale(this.getLocale()).build();
            fu.perform(build, launcher, listener);
        }
        FortifyClean fc = new FortifyClean(this.getBuildId());
        fc.perform(build, launcher, listener);
        ProjectScanType projectScanType = this.getProjectScanType();
        if (projectScanType != null) {
            FortifyTranslate ft = new FortifyTranslate(this.getBuildId(), projectScanType);
            ft.setMaxHeap(this.getMaxHeap());
            ft.setAddJVMOptions(this.getAddJVMOptions());
            ft.setDebug(this.isTranslationDebug());
            ft.setVerbose(this.isTranslationVerbose());
            ft.setLogFile(this.getTranslationLogFile());
            ft.setExcludeList(this.getTranslationExcludeList());
            if (projectScanType instanceof JavaScanType) {
                ft.setJavaVersion(((JavaScanType)projectScanType).getJavaVersion());
                ft.setJavaClasspath(((JavaScanType)projectScanType).getJavaClasspath());
                ft.setJavaSrcFiles(((JavaScanType)projectScanType).getJavaSrcFiles());
                ft.setJavaAddOptions(((JavaScanType)projectScanType).getJavaAddOptions());
            } else if (projectScanType instanceof DevenvScanType) {
                ft.setDotnetProject(((DevenvScanType)projectScanType).getDotnetProject());
                ft.setDotnetAddOptions(((DevenvScanType)projectScanType).getDotnetAddOptions());
            } else if (projectScanType instanceof MsbuildScanType) {
                ft.setDotnetProject(((MsbuildScanType)projectScanType).getDotnetProject());
                ft.setDotnetAddOptions(((MsbuildScanType)projectScanType).getDotnetAddOptions());
            } else if (projectScanType instanceof DotnetSourceScanType) {
                ft.setDotnetFrameworkVersion(((DotnetSourceScanType)projectScanType).getDotnetFrameworkVersion());
                ft.setDotnetLibdirs(((DotnetSourceScanType)projectScanType).getDotnetLibdirs());
                ft.setDotnetAddOptions(((DotnetSourceScanType)projectScanType).getDotnetAddOptions());
                ft.setDotnetSrcFiles(((DotnetSourceScanType)projectScanType).getDotnetSrcFiles());
            } else if (projectScanType instanceof MavenScanType) {
                ft.setMavenOptions(((MavenScanType)projectScanType).getMavenOptions());
            } else if (projectScanType instanceof GradleScanType) {
                ft.setUseWrapper(((GradleScanType)projectScanType).getUseWrapper());
                ft.setGradleTasks(((GradleScanType)projectScanType).getGradleTasks());
                ft.setGradleOptions(((GradleScanType)projectScanType).getGradleOptions());
            } else if (projectScanType instanceof OtherScanType) {
                ft.setOtherIncludesList(((OtherScanType)projectScanType).getOtherIncludesList());
                ft.setOtherOptions(((OtherScanType)projectScanType).getOtherOptions());
            } else if (projectScanType instanceof AdvancedScanType) {
                ft.setAdvOptions(((AdvancedScanType)projectScanType).getAdvOptions());
            }
            ft.perform(build, launcher, listener);
        }
    }

    private ProjectScanType calculateProjectScanType() {
        if (this.getIsAdvancedTranslationType()) {
            return new AdvancedScanType();
        }
        if (this.getIsBasicJavaTranslationType()) {
            return new JavaScanType();
        }
        if (this.getIsBasicDotNetTranslationType()) {
            if (this.getIsBasicDotNetProjectSolutionScanType()) {
                if (this.getIsBasicDotNetMSBuildBuildType()) {
                    return new MsbuildScanType();
                }
                return new DevenvScanType();
            }
            return new DotnetSourceScanType();
        }
        if (this.getIsBasicMaven3TranslationType()) {
            return new MavenScanType();
        }
        if (this.getIsBasicGradleTranslationType()) {
            return new GradleScanType();
        }
        return new OtherScanType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T runWithFortifyClient(String token, FortifyClient.Command<T> cmd) throws Exception {
        if (cmd != null) {
            Object object;
            block12: {
                String url = DESCRIPTOR.getUrl();
                ClassLoader contextClassLoader = null;
                try {
                    FortifyClient client = null;
                    object = syncObj;
                    synchronized (object) {
                        contextClassLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(FortifyPlugin.class.getClassLoader());
                        client = new FortifyClient();
                        boolean useProxy = DESCRIPTOR.getUseProxy();
                        String proxyUrl = DESCRIPTOR.getProxyUrl();
                        if (!useProxy || StringUtils.isEmpty((String)proxyUrl)) {
                            client.init(url, token, DESCRIPTOR.getConnectTimeout(), DESCRIPTOR.getReadTimeout(), DESCRIPTOR.getWriteTimeout());
                        } else {
                            String[] proxyUrlSplit = proxyUrl.split(":");
                            String proxyHost = proxyUrlSplit[0];
                            int proxyPort = 80;
                            if (proxyUrlSplit.length > 1) {
                                try {
                                    proxyPort = Integer.parseInt(proxyUrlSplit[1]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            client.init(url, token, proxyHost, proxyPort, DESCRIPTOR.getProxyUsername(), DESCRIPTOR.getProxyPassword(), DESCRIPTOR.getConnectTimeout(), DESCRIPTOR.getReadTimeout(), DESCRIPTOR.getWriteTimeout());
                        }
                    }
                    object = cmd.runWith(client);
                    if (contextClassLoader == null) break block12;
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
                catch (Throwable throwable) {
                    if (contextClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(contextClassLoader);
                    }
                    throw throwable;
                }
            }
            return (T)object;
        }
        return null;
    }

    static {
        syncObj = new Object();
        DESCRIPTOR = new DescriptorImpl();
    }

    public static class RemoteOptionalConfigBlock {
        private String sensorPoolUUID;
        private String notifyEmail;
        private String scanOptions;
        private String customRulepacks;
        private String filterFile;

        @DataBoundConstructor
        public RemoteOptionalConfigBlock() {
        }

        public String getSensorPoolUUID() {
            return this.sensorPoolUUID;
        }

        @DataBoundSetter
        public void setSensorPoolUUID(String sensorPoolUUID) {
            this.sensorPoolUUID = sensorPoolUUID;
        }

        public String getNotifyEmail() {
            return this.notifyEmail;
        }

        @DataBoundSetter
        public void setNotifyEmail(String notifyEmail) {
            this.notifyEmail = notifyEmail;
        }

        public String getScanOptions() {
            return this.scanOptions;
        }

        @DataBoundSetter
        public void setScanOptions(String scanOptions) {
            this.scanOptions = scanOptions;
        }

        public String getCustomRulepacks() {
            return this.customRulepacks;
        }

        @DataBoundSetter
        public void setCustomRulepacks(String customRulepacks) {
            this.customRulepacks = customRulepacks;
        }

        public String getFilterFile() {
            return this.filterFile;
        }

        @DataBoundSetter
        public void setFilterFile(String filterFile) {
            this.filterFile = filterFile;
        }
    }

    public static class AnalysisRunType {
        private String value;
        private RemoteAnalysisProjectType remoteAnalysisProjectType;
        private RemoteOptionalConfigBlock remoteOptionalConfig;
        private String transArgs;
        private ProjectScanType projectScanType;
        private UpdateContentBlock updateContent;
        private String buildId;
        private String scanFile;
        private String maxHeap;
        private String addJVMOptions;
        private String translationExcludeList;
        private boolean translationDebug;
        private boolean translationVerbose;
        private String translationLogFile;
        private RunScanBlock runScan;
        private UploadSSCBlock uploadSSC;

        @DataBoundConstructor
        public AnalysisRunType(String value) {
            this.value = value;
        }

        public RemoteAnalysisProjectType getRemoteAnalysisProjectType() {
            return this.remoteAnalysisProjectType;
        }

        @DataBoundSetter
        public void setRemoteAnalysisProjectType(RemoteAnalysisProjectType remoteAnalysisProjectType) {
            this.remoteAnalysisProjectType = remoteAnalysisProjectType;
        }

        public RemoteOptionalConfigBlock getRemoteOptionalConfig() {
            return this.remoteOptionalConfig;
        }

        @DataBoundSetter
        public void setRemoteOptionalConfig(RemoteOptionalConfigBlock remoteOptionalConfig) {
            this.remoteOptionalConfig = remoteOptionalConfig;
        }

        public String getTransArgs() {
            return this.transArgs;
        }

        @DataBoundSetter
        public void setTransArgs(String transArgs) {
            this.transArgs = transArgs;
        }

        public ProjectScanType getProjectScanType() {
            return this.projectScanType;
        }

        @DataBoundSetter
        public void setProjectScanType(ProjectScanType projectScanType) {
            this.projectScanType = projectScanType;
        }

        public UpdateContentBlock getUpdateContent() {
            return this.updateContent;
        }

        @DataBoundSetter
        public void setUpdateContent(UpdateContentBlock updateContent) {
            this.updateContent = updateContent;
        }

        public String getBuildId() {
            return this.buildId;
        }

        @DataBoundSetter
        public void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        public String getScanFile() {
            return this.scanFile;
        }

        @DataBoundSetter
        public void setScanFile(String scanFile) {
            this.scanFile = scanFile;
        }

        public String getMaxHeap() {
            return this.maxHeap;
        }

        @DataBoundSetter
        public void setMaxHeap(String maxHeap) {
            this.maxHeap = maxHeap;
        }

        public String getAddJVMOptions() {
            return this.addJVMOptions;
        }

        @DataBoundSetter
        public void setAddJVMOptions(String addJVMOptions) {
            this.addJVMOptions = addJVMOptions;
        }

        public String getTranslationExcludeList() {
            return this.translationExcludeList;
        }

        @DataBoundSetter
        public void setTranslationExcludeList(String translationExcludeList) {
            this.translationExcludeList = translationExcludeList;
        }

        public boolean isTranslationDebug() {
            return this.translationDebug;
        }

        @DataBoundSetter
        public void setTranslationDebug(boolean translationDebug) {
            this.translationDebug = translationDebug;
        }

        public boolean isTranslationVerbose() {
            return this.translationVerbose;
        }

        @DataBoundSetter
        public void setTranslationVerbose(boolean translationVerbose) {
            this.translationVerbose = translationVerbose;
        }

        public String getTranslationLogFile() {
            return this.translationLogFile;
        }

        @DataBoundSetter
        public void setTranslationLogFile(String translationLogFile) {
            this.translationLogFile = translationLogFile;
        }

        public RunScanBlock getRunScan() {
            return this.runScan;
        }

        @DataBoundSetter
        public void setRunScan(RunScanBlock runScan) {
            this.runScan = runScan;
        }

        public UploadSSCBlock getUploadSSC() {
            return this.uploadSSC;
        }

        @DataBoundSetter
        public void setUploadSSC(UploadSSCBlock uploadSSC) {
            this.uploadSSC = uploadSSC;
        }
    }

    @Deprecated
    public static class UseProxyBlock {
        private String proxyUrl;
        private Secret proxyUsername;
        private Secret proxyPassword;

        @DataBoundConstructor
        public UseProxyBlock(String updateProxyUrl, String updateProxyUsername, String updateProxyPassword) {
            this.proxyUrl = updateProxyUrl != null ? updateProxyUrl.trim() : "";
            this.proxyUsername = updateProxyUsername != null ? Secret.fromString((String)updateProxyUsername.trim()) : null;
            this.proxyPassword = updateProxyPassword != null ? Secret.fromString((String)updateProxyPassword.trim()) : null;
        }

        public String getProxyUrl() {
            return this.proxyUrl;
        }

        public String getProxyUsername() {
            return this.proxyUsername == null ? "" : this.proxyUsername.getPlainText();
        }

        public String getProxyPassword() {
            return this.proxyPassword == null ? "" : this.proxyPassword.getPlainText();
        }
    }

    public static class UpdateContentBlock {
        private String updateServerUrl;
        private String locale;
        private UseProxyBlock useProxy;

        @DataBoundConstructor
        public UpdateContentBlock() {
        }

        @Deprecated
        public UpdateContentBlock(String updateServerUrl, UseProxyBlock updateUseProxy) {
            this.updateServerUrl = updateServerUrl != null ? updateServerUrl.trim() : "";
            this.useProxy = updateUseProxy;
        }

        public String getUpdateServerUrl() {
            return this.updateServerUrl;
        }

        @DataBoundSetter
        public void setUpdateServerUrl(String updateServerUrl) {
            this.updateServerUrl = updateServerUrl;
        }

        public String getLocale() {
            return this.locale;
        }

        @DataBoundSetter
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @Deprecated
        public boolean getUpdateUseProxy() {
            return this.useProxy != null;
        }

        @Deprecated
        public String getUpdateProxyUrl() {
            return this.useProxy == null ? "" : this.useProxy.getProxyUrl();
        }

        @Deprecated
        public String getUpdateProxyUsername() {
            return this.useProxy == null ? "" : this.useProxy.getProxyUsername();
        }

        @Deprecated
        public String getUpdateProxyPassword() {
            return this.useProxy == null ? "" : this.useProxy.getProxyPassword();
        }
    }

    public static class RunScanBlock {
        private String customRulepacks;
        private String additionalOptions;
        private boolean debug;
        private boolean verbose;
        private String logFile;

        @DataBoundConstructor
        public RunScanBlock() {
        }

        @Deprecated
        public RunScanBlock(String scanCustomRulepacks, String scanAddOptions, boolean scanDebug, boolean scanVerbose, String scanLogFile) {
            this.customRulepacks = scanCustomRulepacks != null ? scanCustomRulepacks.trim() : "";
            this.additionalOptions = scanAddOptions != null ? scanAddOptions.trim() : "";
            this.debug = scanDebug;
            this.verbose = scanVerbose;
            this.logFile = scanLogFile != null ? scanLogFile.trim() : "";
        }

        public String getScanCustomRulepacks() {
            return this.customRulepacks;
        }

        @DataBoundSetter
        public void setScanCustomRulepacks(String scanCustomRulepacks) {
            this.customRulepacks = scanCustomRulepacks;
        }

        public String getScanAddOptions() {
            return this.additionalOptions;
        }

        @DataBoundSetter
        public void setScanAddOptions(String scanAddOptions) {
            this.additionalOptions = scanAddOptions;
        }

        public boolean getScanDebug() {
            return this.debug;
        }

        @DataBoundSetter
        public void setScanDebug(boolean scanDebug) {
            this.debug = scanDebug;
        }

        public boolean getScanVerbose() {
            return this.verbose;
        }

        @DataBoundSetter
        public void setScanVerbose(boolean scanVerbose) {
            this.verbose = scanVerbose;
        }

        public String getScanLogFile() {
            return this.logFile;
        }

        @DataBoundSetter
        public void setScanLogFile(String scanLogFile) {
            this.logFile = scanLogFile;
        }
    }

    @Deprecated
    public static class BasicOtherTranslationAppTypeBlock
    implements BasicTranslationAppTypeBlock {
        private String options;
        private String includesList;

        @DataBoundConstructor
        public BasicOtherTranslationAppTypeBlock(String otherOptions, String otherIncludesList) {
            this.options = otherOptions;
            this.includesList = otherIncludesList;
        }

        public String getOptions() {
            return this.options;
        }

        public String getIncludesList() {
            return this.includesList;
        }
    }

    @Deprecated
    public static class BasicGradleTranslationAppTypeBlock
    implements BasicTranslationAppTypeBlock {
        private boolean useWrapper;
        private String tasks;
        private String options;

        @DataBoundConstructor
        public BasicGradleTranslationAppTypeBlock(boolean gradleUseWrapper, String gradleTasks, String gradleOptions) {
            this.useWrapper = gradleUseWrapper;
            this.tasks = gradleTasks;
            this.options = gradleOptions;
        }

        public boolean getUseWrapper() {
            return this.useWrapper;
        }

        public String getTasks() {
            return this.tasks;
        }

        public String getOptions() {
            return this.options;
        }
    }

    @Deprecated
    public static class BasicMaven3TranslationAppTypeBlock
    implements BasicTranslationAppTypeBlock {
        private String options;

        @DataBoundConstructor
        public BasicMaven3TranslationAppTypeBlock(String maven3Options) {
            this.options = maven3Options;
        }

        public String getOptions() {
            return this.options;
        }
    }

    @Deprecated
    public static class BasicDotNetMSBuildBuildTypeBlock
    implements BasicDotNetBuildTypeBlock {
        private String projects;
        private String addOptions;

        @DataBoundConstructor
        public BasicDotNetMSBuildBuildTypeBlock(String dotNetMSBuildProjects, String dotNetMSBuildAddOptions) {
            this.projects = dotNetMSBuildProjects;
            this.addOptions = dotNetMSBuildAddOptions;
        }

        public String getProjects() {
            return this.projects;
        }

        public String getAddOptions() {
            return this.addOptions;
        }
    }

    @Deprecated
    public static class BasicDotNetDevenvBuildTypeBlock
    implements BasicDotNetBuildTypeBlock {
        private String projects;
        private String addOptions;

        @DataBoundConstructor
        public BasicDotNetDevenvBuildTypeBlock(String dotNetDevenvProjects, String dotNetDevenvAddOptions) {
            this.projects = dotNetDevenvProjects;
            this.addOptions = dotNetDevenvAddOptions;
        }

        public String getProjects() {
            return this.projects;
        }

        public String getAddOptions() {
            return this.addOptions;
        }
    }

    @Deprecated
    public static interface BasicDotNetBuildTypeBlock {
    }

    @Deprecated
    public static class BasicDotNetSourceCodeScanTypeBlock
    implements BasicDotNetScanTypeBlock {
        private String dotNetVersion;
        private String libdirs;
        private String addOptions;
        private String dotNetSrcFiles;

        @DataBoundConstructor
        public BasicDotNetSourceCodeScanTypeBlock(String dotNetSourceCodeFrameworkVersion, String dotNetSourceCodeLibdirs, String dotNetSourceCodeAddOptions, String dotNetSourceCodeSrcFiles) {
            this.dotNetVersion = dotNetSourceCodeFrameworkVersion;
            this.libdirs = dotNetSourceCodeLibdirs;
            this.addOptions = dotNetSourceCodeAddOptions;
            this.dotNetSrcFiles = dotNetSourceCodeSrcFiles;
        }

        public String getDotNetVersion() {
            return this.dotNetVersion;
        }

        public String getLibdirs() {
            return this.libdirs;
        }

        public String getAddOptions() {
            return this.addOptions;
        }

        public String getDotNetSrcFiles() {
            return this.dotNetSrcFiles;
        }
    }

    @Deprecated
    public static class BasicDotNetProjectSolutionScanTypeBlock
    implements BasicDotNetScanTypeBlock {
        private BasicDotNetBuildTypeBlock buildType;

        @DataBoundConstructor
        public BasicDotNetProjectSolutionScanTypeBlock(BasicDotNetBuildTypeBlock dotNetBuildType) {
            this.buildType = dotNetBuildType;
        }

        public boolean isDevenvBuildType() {
            return this.buildType != null && this.buildType instanceof BasicDotNetDevenvBuildTypeBlock;
        }

        public boolean isMSBuildBuildType() {
            return this.buildType != null && this.buildType instanceof BasicDotNetMSBuildBuildTypeBlock;
        }

        public String getDevenvProjects() {
            return this.isDevenvBuildType() ? ((BasicDotNetDevenvBuildTypeBlock)this.buildType).getProjects() : "";
        }

        public String getDevenvAddOptions() {
            return this.isDevenvBuildType() ? ((BasicDotNetDevenvBuildTypeBlock)this.buildType).getAddOptions() : "";
        }

        public String getMSBuildProjects() {
            return this.isMSBuildBuildType() ? ((BasicDotNetMSBuildBuildTypeBlock)this.buildType).getProjects() : "";
        }

        public String getMSBuildAddOptions() {
            return this.isMSBuildBuildType() ? ((BasicDotNetMSBuildBuildTypeBlock)this.buildType).getAddOptions() : "";
        }
    }

    @Deprecated
    public static interface BasicDotNetScanTypeBlock {
    }

    @Deprecated
    public static class BasicDotNetTranslationAppTypeBlock
    implements BasicTranslationAppTypeBlock {
        private BasicDotNetScanTypeBlock scanType;

        @DataBoundConstructor
        public BasicDotNetTranslationAppTypeBlock(BasicDotNetScanTypeBlock dotNetScanType) {
            this.scanType = dotNetScanType;
        }

        public boolean isProjectSolutionScanType() {
            return this.scanType != null && this.scanType instanceof BasicDotNetProjectSolutionScanTypeBlock;
        }

        public boolean isSourceCodeScanType() {
            return this.scanType != null && this.scanType instanceof BasicDotNetSourceCodeScanTypeBlock;
        }

        public BasicDotNetScanTypeBlock getScanTypeBlock() {
            return this.scanType;
        }

        public boolean isDevenvBuildType() {
            return this.isProjectSolutionScanType() && ((BasicDotNetProjectSolutionScanTypeBlock)this.scanType).isDevenvBuildType();
        }

        public boolean isMSBuildBuildType() {
            return this.isProjectSolutionScanType() && ((BasicDotNetProjectSolutionScanTypeBlock)this.scanType).isMSBuildBuildType();
        }

        public String getDevenvProjects() {
            return this.isProjectSolutionScanType() ? ((BasicDotNetProjectSolutionScanTypeBlock)this.scanType).getDevenvProjects() : "";
        }

        public String getDevenvAddOptions() {
            return this.isProjectSolutionScanType() ? ((BasicDotNetProjectSolutionScanTypeBlock)this.scanType).getDevenvAddOptions() : "";
        }

        public String getMSBuildProjects() {
            return this.isProjectSolutionScanType() ? ((BasicDotNetProjectSolutionScanTypeBlock)this.scanType).getMSBuildProjects() : "";
        }

        public String getMSBuildAddOptions() {
            return this.isProjectSolutionScanType() ? ((BasicDotNetProjectSolutionScanTypeBlock)this.scanType).getMSBuildAddOptions() : "";
        }

        public String getSourceCodeFrameworkVersion() {
            return this.isSourceCodeScanType() ? ((BasicDotNetSourceCodeScanTypeBlock)this.scanType).getDotNetVersion() : "";
        }

        public String getSourceCodeLibdirs() {
            return this.isSourceCodeScanType() ? ((BasicDotNetSourceCodeScanTypeBlock)this.scanType).getLibdirs() : "";
        }

        public String getSourceCodeAddOptions() {
            return this.isSourceCodeScanType() ? ((BasicDotNetSourceCodeScanTypeBlock)this.scanType).getAddOptions() : "";
        }

        public String getSourceCodeSrcFiles() {
            return this.isSourceCodeScanType() ? ((BasicDotNetSourceCodeScanTypeBlock)this.scanType).getDotNetSrcFiles() : "";
        }
    }

    @Deprecated
    public static class BasicJavaTranslationAppTypeBlock
    implements BasicTranslationAppTypeBlock {
        private String javaVersion;
        private String classpath;
        private String sourceFiles;
        private String additionalOptions;

        @DataBoundConstructor
        public BasicJavaTranslationAppTypeBlock(String translationJavaVersion, String translationJavaClasspath, String translationJavaSourceFiles, String translationJavaAddOptions) {
            this.javaVersion = translationJavaVersion != null ? translationJavaVersion.trim() : "";
            this.classpath = translationJavaClasspath != null ? translationJavaClasspath.trim() : "";
            this.sourceFiles = translationJavaSourceFiles != null ? translationJavaSourceFiles.trim() : "";
            this.additionalOptions = translationJavaAddOptions != null ? translationJavaAddOptions.trim() : "";
        }

        public String getTranslationJavaVersion() {
            return this.javaVersion;
        }

        public String getTranslationClasspath() {
            return this.classpath;
        }

        public String getTranslationSourceFiles() {
            return this.sourceFiles;
        }

        public String getTranslationAddOptions() {
            return this.additionalOptions;
        }
    }

    @Deprecated
    public static interface BasicTranslationAppTypeBlock {
    }

    @Deprecated
    public static class AdvancedTranslationBlock
    implements TranslationTypeBlock {
        private String translationOptions;

        @DataBoundConstructor
        public AdvancedTranslationBlock(String translationOptions) {
            this.translationOptions = translationOptions != null ? translationOptions.trim() : "";
        }

        public String getTranslationOptions() {
            return this.translationOptions;
        }
    }

    @Deprecated
    public static class BasicTranslationBlock
    implements TranslationTypeBlock {
        private BasicTranslationAppTypeBlock appTypeBlock;
        private String excludeList;

        @DataBoundConstructor
        public BasicTranslationBlock(BasicTranslationAppTypeBlock translationAppType, String translationExcludeList) {
            this.appTypeBlock = translationAppType;
            this.excludeList = translationExcludeList != null ? translationExcludeList.trim() : "";
        }

        public BasicTranslationAppTypeBlock getTranslationApplicationTypeBlock() {
            return this.appTypeBlock;
        }

        public String getTranslationExcludeList() {
            return this.excludeList;
        }
    }

    @Deprecated
    public static interface TranslationTypeBlock {
    }

    @Deprecated
    public static class RunTranslationBlock {
        private TranslationTypeBlock translationType;
        private boolean debug;
        private boolean verbose;
        private String logFile;

        @DataBoundConstructor
        public RunTranslationBlock(TranslationTypeBlock translationType, boolean translationDebug, boolean translationVerbose, String translationLogFile) {
            this.translationType = translationType;
            this.debug = translationDebug;
            this.verbose = translationVerbose;
            this.logFile = translationLogFile != null ? translationLogFile.trim() : "";
        }

        public boolean isBasicTranslationType() {
            return this.translationType instanceof BasicTranslationBlock;
        }

        public boolean isAdvancedTranslationType() {
            return this.translationType instanceof AdvancedTranslationBlock;
        }

        public boolean isBasicJavaTranslationType() {
            return this.isBasicTranslationType() && ((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() instanceof BasicJavaTranslationAppTypeBlock;
        }

        public boolean isBasicDotNetTranslationType() {
            return this.isBasicTranslationType() && ((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() instanceof BasicDotNetTranslationAppTypeBlock;
        }

        public boolean isBasicMaven3TranslationType() {
            return this.isBasicTranslationType() && ((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() instanceof BasicMaven3TranslationAppTypeBlock;
        }

        public boolean isBasicGradleTranslationType() {
            return this.isBasicTranslationType() && ((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() instanceof BasicGradleTranslationAppTypeBlock;
        }

        public boolean isBasicOtherTranslationType() {
            return this.isBasicTranslationType() && ((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() instanceof BasicOtherTranslationAppTypeBlock;
        }

        public boolean isBasicDotNetProjectSolutionScanType() {
            return this.isBasicDotNetTranslationType() && this.getBasicDotNetTranslationAppTypeBlock().isProjectSolutionScanType();
        }

        public boolean isBasicDotNetSourceCodeScanType() {
            return this.isBasicDotNetTranslationType() && this.getBasicDotNetTranslationAppTypeBlock().isSourceCodeScanType();
        }

        public boolean isBasicDotNetDevenvBuildType() {
            return this.isBasicDotNetProjectSolutionScanType() && this.getBasicDotNetTranslationAppTypeBlock().isDevenvBuildType();
        }

        public boolean isBasicDotNetMSBuildBuildType() {
            return this.isBasicDotNetProjectSolutionScanType() && this.getBasicDotNetTranslationAppTypeBlock().isMSBuildBuildType();
        }

        private BasicJavaTranslationAppTypeBlock getBasicJavaTranslationAppTypeBlock() {
            return this.isBasicJavaTranslationType() ? (BasicJavaTranslationAppTypeBlock)((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() : null;
        }

        private BasicDotNetTranslationAppTypeBlock getBasicDotNetTranslationAppTypeBlock() {
            return this.isBasicDotNetTranslationType() ? (BasicDotNetTranslationAppTypeBlock)((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() : null;
        }

        private BasicMaven3TranslationAppTypeBlock getBasicMaven3TranslationAppTypeBlock() {
            return this.isBasicMaven3TranslationType() ? (BasicMaven3TranslationAppTypeBlock)((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() : null;
        }

        private BasicGradleTranslationAppTypeBlock getBasicGradleTranslationAppTypeBlock() {
            return this.isBasicGradleTranslationType() ? (BasicGradleTranslationAppTypeBlock)((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() : null;
        }

        private BasicOtherTranslationAppTypeBlock getBasicOtherTranslationAppTypeBlock() {
            return this.isBasicOtherTranslationType() ? (BasicOtherTranslationAppTypeBlock)((BasicTranslationBlock)this.translationType).getTranslationApplicationTypeBlock() : null;
        }

        public String getTranslationType() {
            return this.isBasicTranslationType() ? "translationBasic" : "translationAdvanced";
        }

        public String getTranslationOptions() {
            return this.isAdvancedTranslationType() ? ((AdvancedTranslationBlock)this.translationType).getTranslationOptions() : "";
        }

        public String getTranslationExcludeList() {
            return this.isBasicTranslationType() ? ((BasicTranslationBlock)this.translationType).getTranslationExcludeList() : "";
        }

        public String getTranslationJavaVersion() {
            return this.isBasicJavaTranslationType() ? this.getBasicJavaTranslationAppTypeBlock().getTranslationJavaVersion() : "";
        }

        public String getTranslationClasspath() {
            return this.isBasicJavaTranslationType() ? this.getBasicJavaTranslationAppTypeBlock().getTranslationClasspath() : "";
        }

        public String getTranslationSourceFiles() {
            return this.isBasicJavaTranslationType() ? this.getBasicJavaTranslationAppTypeBlock().getTranslationSourceFiles() : "";
        }

        public String getTranslationAddOptions() {
            return this.isBasicJavaTranslationType() ? this.getBasicJavaTranslationAppTypeBlock().getTranslationAddOptions() : "";
        }

        public String getDotNetDevenvProjects() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getDevenvProjects() : "";
        }

        public String getDotNetDevenvAddOptions() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getDevenvAddOptions() : "";
        }

        public String getDotNetMSBuildProjects() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getMSBuildProjects() : "";
        }

        public String getDotNetMSBuildAddOptions() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getMSBuildAddOptions() : "";
        }

        public String getDotNetSourceCodeFrameworkVersion() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getSourceCodeFrameworkVersion() : "";
        }

        public String getDotNetSourceCodeLibdirs() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getSourceCodeLibdirs() : "";
        }

        public String getDotNetSourceCodeAddOptions() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getSourceCodeAddOptions() : "";
        }

        public String getDotNetSourceCodeSrcFiles() {
            return this.isBasicDotNetTranslationType() ? this.getBasicDotNetTranslationAppTypeBlock().getSourceCodeSrcFiles() : "";
        }

        public String getMaven3Options() {
            return this.isBasicMaven3TranslationType() ? this.getBasicMaven3TranslationAppTypeBlock().getOptions() : "";
        }

        public boolean getGradleUseWrapper() {
            return this.isBasicGradleTranslationType() && this.getBasicGradleTranslationAppTypeBlock().getUseWrapper();
        }

        public String getGradleTasks() {
            return this.isBasicGradleTranslationType() ? this.getBasicGradleTranslationAppTypeBlock().getTasks() : "";
        }

        public String getGradleOptions() {
            return this.isBasicGradleTranslationType() ? this.getBasicGradleTranslationAppTypeBlock().getOptions() : "";
        }

        public String getOtherOptions() {
            return this.isBasicOtherTranslationType() ? this.getBasicOtherTranslationAppTypeBlock().getOptions() : "";
        }

        public String getOtherIncludesList() {
            return this.isBasicOtherTranslationType() ? this.getBasicOtherTranslationAppTypeBlock().getIncludesList() : "";
        }

        public boolean getTranslationDebug() {
            return this.debug;
        }

        public boolean getTranslationVerbose() {
            return this.verbose;
        }

        public String getTranslationLogFile() {
            return this.logFile;
        }
    }

    public static class UploadSSCBlock {
        private transient String projectName;
        private transient String projectVersion;
        private String appName;
        private String appVersion;
        private String filterSet;
        private String searchCondition;
        private String timeout;
        private String pollingInterval;

        @DataBoundConstructor
        public UploadSSCBlock(String appName, String appVersion) {
            this.appName = appName != null ? appName.trim() : "";
            this.appVersion = appVersion != null ? appVersion.trim() : "";
        }

        @Deprecated
        public UploadSSCBlock(String projectName, String projectVersion, String filterSet, String searchCondition, String timeout, String pollingInterval) {
            this.projectName = projectName != null ? projectName.trim() : "";
            this.projectVersion = projectName != null ? projectVersion.trim() : "";
            this.filterSet = filterSet != null ? filterSet.trim() : "";
            this.searchCondition = searchCondition != null ? searchCondition.trim() : "";
            this.timeout = timeout != null ? timeout.trim() : "";
            this.pollingInterval = pollingInterval != null ? pollingInterval.trim() : "";
        }

        protected Object readResolve() {
            if (this.projectName != null) {
                this.appName = this.projectName;
            }
            if (this.projectVersion != null) {
                this.appVersion = this.projectVersion;
            }
            return this;
        }

        @Deprecated
        public String getProjectName() {
            return this.projectName;
        }

        @Deprecated
        public String getProjectVersion() {
            return this.projectVersion;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public String getFilterSet() {
            return this.filterSet;
        }

        @DataBoundSetter
        public void setFilterSet(String filterSet) {
            this.filterSet = filterSet;
        }

        public String getSearchCondition() {
            return this.searchCondition;
        }

        @DataBoundSetter
        public void setSearchCondition(String searchCondition) {
            this.searchCondition = searchCondition;
        }

        public String getTimeout() {
            return this.timeout;
        }

        @DataBoundSetter
        public void setTimeout(String timeout) {
            this.timeout = timeout;
        }

        public String getPollingInterval() {
            return this.pollingInterval;
        }

        @DataBoundSetter
        public void setPollingInterval(String pollingInterval) {
            this.pollingInterval = pollingInterval;
        }
    }

    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String url;
        private boolean useProxy;
        private String proxyUrl;
        private Secret proxyUsername;
        private Secret proxyPassword;
        private Secret token;
        private String projectTemplate;
        private Integer breakdownPageSize;
        private Integer connectTimeout;
        private Integer readTimeout;
        private Integer writeTimeout;
        private List<ProjectTemplateBean> projTemplateList = Collections.emptyList();
        private Map<String, Map<String, Long>> allProjects = Collections.emptyMap();
        private List<SensorPoolBean> sensorPoolList = Collections.emptyList();
        private String ctrlUrl;
        private Secret ctrlToken;
        private boolean isSettingUpdated = false;

        public DescriptorImpl() {
            super(FortifyPlugin.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Fortify Assessment";
        }

        public String getUrl() {
            return this.url;
        }

        public boolean getUseProxy() {
            return this.useProxy;
        }

        public String getProxyUrl() {
            return this.proxyUrl;
        }

        public String getProxyUsername() {
            return this.proxyUsername == null ? "" : this.proxyUsername.getPlainText();
        }

        public String getProxyPassword() {
            return this.proxyPassword == null ? "" : this.proxyPassword.getPlainText();
        }

        public String getToken() {
            return this.token == null ? "" : this.token.getPlainText();
        }

        public boolean canUploadToSsc() {
            return !StringUtils.isBlank((String)this.getUrl()) && !StringUtils.isBlank((String)this.getToken());
        }

        public String getProjectTemplate() {
            return this.projectTemplate;
        }

        public Integer getBreakdownPageSize() {
            return this.breakdownPageSize;
        }

        public Integer getConnectTimeout() {
            return this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        public Integer getWriteTimeout() {
            return this.writeTimeout;
        }

        public String getCtrlUrl() {
            return this.ctrlUrl;
        }

        public String getCtrlToken() {
            return this.ctrlToken == null ? "" : this.ctrlToken.getPlainText();
        }

        public FormValidation doCheckBreakdownPageSize(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            int pageSize = 0;
            try {
                pageSize = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.warning((String)"Expected an integer value greater than zero.");
            }
            if (pageSize < 1) {
                return FormValidation.warning((String)"Expected an integer value greater than zero.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUrl(@QueryParameter String value) {
            try {
                this.checkUrlValue(value.trim());
            }
            catch (FortifyException e) {
                return FormValidation.warning((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProxyUrl(@QueryParameter String value) {
            try {
                this.checkProxyUrlValue(value.trim());
            }
            catch (FortifyException e) {
                return FormValidation.warning((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckProxyUsername(@QueryParameter String value) {
            try {
                this.checkProxyUsernameValue(value.trim());
            }
            catch (FortifyException e) {
                return FormValidation.warning((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckProxyPassword(@QueryParameter String value) {
            try {
                this.checkProxyPasswordValue(value);
            }
            catch (FortifyException e) {
                return FormValidation.warning((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckToken(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)"Authentication token cannot be empty");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckCtrlToken(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)"Controller token cannot be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFpr(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value) || value.charAt(0) == '$') {
                return FormValidation.ok();
            }
            if (value.contains("/") || value.contains("\\") || !FilenameUtils.isExtension((String)value.toLowerCase(), (String[])new String[]{"fpr"})) {
                return FormValidation.error((String)"The FPR filename should be in basename *ONLY*, with extension FPR");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectTemplate(@QueryParameter String value) {
            try {
                this.checkProjectTemplateName(value.trim());
            }
            catch (FortifyException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectName(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectVersion(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            try {
                int x = Integer.parseInt(value);
                if (x >= 0 && x <= 10080) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"Timeout must be in the range of 0 to 10080");
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Timeout is invalid");
            }
        }

        public FormValidation doCheckPollingInterval(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value) || value.charAt(0) == '$') {
                return FormValidation.ok();
            }
            int x = -1;
            try {
                x = Integer.parseInt(value);
                if (x >= 0 && x <= 60) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"The unit is in minutes, and in the range of 0 to 60");
        }

        public FormValidation doCheckCtrlUrl(@QueryParameter String value, @QueryParameter String url) {
            if (this.doCheckUrl(url) == FormValidation.ok()) {
                return FormValidation.okWithMarkup((String)"<font color=\"blue\">Will use the SSC URL to determine the Controller location</font>");
            }
            try {
                this.checkCtrlUrlValue(value.trim());
            }
            catch (FortifyException e) {
                return FormValidation.warning((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        private FormValidation doTestConnection(String url, String token, String jarsPath) {
            return this.doTestConnection(url, token, jarsPath, this.useProxy, this.proxyUrl, this.getProxyUsername(), this.getProxyPassword());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doTestConnection(@QueryParameter String url, @QueryParameter String token, @QueryParameter String jarsPath, @QueryParameter boolean useProxy, @QueryParameter String proxyUrl, @QueryParameter String proxyUsername, @QueryParameter String proxyPassword) {
            String userToken;
            String sscUrl = url == null ? "" : url.trim();
            try {
                this.checkUrlValue(sscUrl);
            }
            catch (FortifyException e) {
                return FormValidation.error((String)e.getMessage());
            }
            String string = userToken = token == null ? "" : token.trim();
            if (StringUtils.isBlank((String)userToken)) {
                return FormValidation.error((String)"Authentication token cannot be empty");
            }
            if (userToken.indexOf(32) != -1) {
                return FormValidation.error((String)"Authentication token should not contain spaces");
            }
            String orig_url = this.url;
            Secret orig_token = this.token;
            boolean orig_useProxy = this.useProxy;
            String orig_proxyUrl = this.proxyUrl;
            Secret orig_proxyUsername = this.proxyUsername;
            Secret orig_proxyPassword = this.proxyPassword;
            this.url = sscUrl;
            this.token = userToken.isEmpty() ? null : Secret.fromString((String)userToken);
            this.useProxy = useProxy;
            this.proxyUrl = proxyUrl;
            this.proxyUsername = proxyUsername == null ? null : Secret.fromString((String)proxyUsername);
            this.proxyPassword = proxyPassword == null ? null : Secret.fromString((String)proxyPassword);
            try {
                FortifyPlugin.runWithFortifyClient(userToken, new FortifyClient.Command<FortifyClient.NoReturn>(){

                    @Override
                    public FortifyClient.NoReturn runWith(FortifyClient client) throws Exception {
                        client.getProjectList();
                        return FortifyClient.NoReturn.INSTANCE;
                    }
                });
                FormValidation formValidation = FormValidation.okWithMarkup((String)"<font color=\"blue\">Connection successful!</font>");
                return formValidation;
            }
            catch (Throwable t) {
                if (t.getMessage().contains("Access Denied")) {
                    FormValidation formValidation = FormValidation.error((Throwable)t, (String)"Invalid token");
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.error((Throwable)t, (String)"Cannot connect to SSC server");
                return formValidation;
            }
            finally {
                this.url = orig_url;
                this.token = orig_token;
                this.useProxy = orig_useProxy;
                this.proxyUrl = orig_proxyUrl;
                this.proxyUsername = orig_proxyUsername;
                this.proxyPassword = orig_proxyPassword;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doTestCtrlConnection(@QueryParameter String ctrlUrl) throws IOException {
            String controllerUrl = ctrlUrl == null ? "" : ctrlUrl.trim();
            try {
                this.checkUrlValue(controllerUrl);
            }
            catch (FortifyException e) {
                return FormValidation.error((String)e.getMessage());
            }
            String orig_url = this.ctrlUrl;
            this.ctrlUrl = controllerUrl;
            OkHttpClient client = new OkHttpClient();
            Request request = new Request.Builder().url(controllerUrl).build();
            Response response = null;
            try {
                response = client.newCall(request).execute();
                if (response.isSuccessful() && (response.body().string().contains("Fortify ScanCentral Controller") || response.body().string().contains("Fortify CloudScan Controller"))) {
                    FormValidation formValidation = FormValidation.okWithMarkup((String)"<font color=\"blue\">Connection successful!</font>");
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.error((String)"Connection failed. Check the Controller URL.");
                return formValidation;
            }
            catch (Throwable t) {
                FormValidation formValidation = FormValidation.error((Throwable)t, (String)"Cannot connect to Controller");
                return formValidation;
            }
            finally {
                this.ctrlUrl = orig_url;
                if (response != null && response.body() != null) {
                    response.body().close();
                }
            }
        }

        private void checkUrlValue(String sscUrl) throws FortifyException {
            if (StringUtils.isBlank((String)sscUrl)) {
                throw new FortifyException(new Message(4, "URL cannot be empty"));
            }
            if (StringUtils.startsWith((String)sscUrl, (String)"http://") || StringUtils.startsWith((String)sscUrl, (String)"https://")) {
                if (sscUrl.trim().equalsIgnoreCase("http://") || sscUrl.trim().equalsIgnoreCase("https://")) {
                    throw new FortifyException(new Message(4, "URL host is required"));
                }
            } else {
                throw new FortifyException(new Message(4, "Invalid protocol"));
            }
            if (sscUrl.indexOf(32) != -1) {
                throw new FortifyException(new Message(4, "URL cannot have spaces"));
            }
        }

        private void checkProxyUrlValue(String proxyUrl) throws FortifyException {
            if (StringUtils.isNotBlank((String)proxyUrl)) {
                String[] splits = proxyUrl.split(":");
                if (splits.length > 2) {
                    throw new FortifyException(new Message(4, "Invalid proxy url.  Format is <hostname>[:<port>]"));
                }
                Pattern hostPattern = Pattern.compile("([\\w\\-]+\\.)*[\\w\\-]+");
                Matcher hostMatcher = hostPattern.matcher(splits[0]);
                if (!hostMatcher.matches()) {
                    throw new FortifyException(new Message(4, "Invalid proxy host"));
                }
                if (splits.length == 2) {
                    try {
                        Integer.parseInt(splits[1]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new FortifyException(new Message(4, "Invalid proxy port"));
                    }
                }
            }
        }

        private void checkProxyUsernameValue(String proxyUsername) throws FortifyException {
        }

        private void checkProxyPasswordValue(String proxyPassword) throws FortifyException {
        }

        private void checkProjectTemplateName(String projectTemplateName) throws FortifyException {
            if (!StringUtils.isEmpty((String)projectTemplateName)) {
                boolean valid = false;
                List<ProjectTemplateBean> projectTemplateList = this.getProjTemplateListList();
                if (projectTemplateList != null) {
                    for (ProjectTemplateBean projectTemplateBean : projectTemplateList) {
                        if (!projectTemplateBean.getName().equals(projectTemplateName)) continue;
                        valid = true;
                    }
                    if (!valid) {
                        throw new FortifyException(new Message(4, "Invalid Issue Template \"" + projectTemplateName + "\"."));
                    }
                }
            }
        }

        private void checkCtrlUrlValue(String url) throws FortifyException {
            if (StringUtils.isBlank((String)url)) {
                throw new FortifyException(new Message(4, "Controller URL cannot be empty"));
            }
            if (StringUtils.startsWith((String)url, (String)"http://") || StringUtils.startsWith((String)url, (String)"https://")) {
                if (url.trim().equalsIgnoreCase("http://") || url.trim().equalsIgnoreCase("https://")) {
                    throw new FortifyException(new Message(4, "URL host is required"));
                }
                if (!StringUtils.endsWith((String)url, (String)"/scancentral-ctrl") && !StringUtils.endsWith((String)url, (String)"/cloud-ctrl")) {
                    throw new FortifyException(new Message(4, "Invalid context"));
                }
            } else {
                throw new FortifyException(new Message(4, "Invalid protocol"));
            }
            if (url.indexOf(32) != -1) {
                throw new FortifyException(new Message(4, "URL cannot have spaces"));
            }
        }

        public void doRefreshProjects(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value) throws Exception {
            try {
                this.allProjects = this.getAllProjectsNoCache();
                StringBuilder buf = new StringBuilder();
                ArrayList<String> projects = new ArrayList<String>(this.allProjects.keySet());
                Collections.sort(projects, String.CASE_INSENSITIVE_ORDER);
                for (String prjName : projects) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append("{ \"name\": \"" + prjName + "\" }\n");
                }
                buf.insert(0, "{ \"list\" : [\n");
                buf.append("]}");
                rsp.setContentType("text/html;charset=UTF-8");
                rsp.getWriter().print(buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void doRefreshVersions(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value) throws Exception {
            try {
                this.allProjects = this.getAllProjects();
                StringBuilder buf = new StringBuilder();
                for (Map.Entry<String, Map<String, Long>> prj : this.allProjects.entrySet()) {
                    ArrayList<String> versions = new ArrayList<String>(prj.getValue().keySet());
                    Collections.sort(versions, String.CASE_INSENSITIVE_ORDER);
                    for (String prjVersion : versions) {
                        if (buf.length() > 0) {
                            buf.append(",");
                        }
                        buf.append("{ \"name\": \"" + prjVersion + "\", \"prj\": \"" + prj + "\" }\n");
                    }
                }
                buf.insert(0, "{ \"list\" : [\n");
                buf.append("]}");
                rsp.setContentType("text/html;charset=UTF-8");
                rsp.getWriter().print(buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void doRefreshProjectTemplates(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value) throws Exception {
            String orig_url = this.url;
            boolean orig_useProxy = this.useProxy;
            String orig_proxyUrl = this.proxyUrl;
            Secret orig_proxyUsername = this.proxyUsername;
            Secret orig_proxyPassword = this.proxyPassword;
            Secret orig_token = this.token;
            String url = req.getParameter("url");
            boolean useProxy = "true".equals(req.getParameter("useProxy"));
            String proxyUrl = req.getParameter("proxyUrl");
            String proxyUsername = req.getParameter("proxyUsername");
            String proxyPassword = req.getParameter("proxyPassword");
            String token = req.getParameter("token");
            this.url = url != null ? url.trim() : "";
            this.useProxy = useProxy;
            if (useProxy) {
                this.proxyUrl = proxyUrl != null ? proxyUrl.trim() : "";
                this.proxyUsername = proxyUsername != null ? Secret.fromString((String)proxyUsername.trim()) : null;
                this.proxyPassword = proxyPassword != null ? Secret.fromString((String)proxyPassword) : null;
            } else {
                this.proxyUrl = "";
                this.proxyUsername = null;
                this.proxyPassword = null;
            }
            Secret secret = this.token = token != null ? Secret.fromString((String)token.trim()) : null;
            if (!this.doTestConnection((String)this.url, (String)this.getToken(), null).kind.equals((Object)FormValidation.Kind.OK)) {
                return;
            }
            try {
                this.projTemplateList = this.getProjTemplateListNoCache();
                StringBuilder buf = new StringBuilder();
                buf.append("{ \"list\" : [\n");
                for (int i = 0; i < this.projTemplateList.size(); ++i) {
                    ProjectTemplateBean b = this.projTemplateList.get(i);
                    buf.append("{ \"name\": \"" + b.getName() + "\", \"id\": \"" + b.getId() + "\" }");
                    if (i != this.projTemplateList.size() - 1) {
                        buf.append(",\n");
                        continue;
                    }
                    buf.append("\n");
                }
                buf.append("]}");
                rsp.setContentType("text/html;charset=UTF-8");
                rsp.getWriter().print(buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                this.url = orig_url;
                this.useProxy = orig_useProxy;
                this.proxyUrl = orig_proxyUrl;
                this.proxyUsername = orig_proxyUsername;
                this.proxyPassword = orig_proxyPassword;
                this.token = orig_token;
            }
        }

        public void doRefreshSensorPools(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value) throws Exception {
            String orig_url = this.url;
            boolean orig_useProxy = this.useProxy;
            String orig_proxyUrl = this.proxyUrl;
            Secret orig_proxyUsername = this.proxyUsername;
            Secret orig_proxyPassword = this.proxyPassword;
            Secret orig_token = this.token;
            String url = req.getParameter("url");
            boolean useProxy = "true".equals(req.getParameter("useProxy"));
            String proxyUrl = req.getParameter("proxyUrl");
            String proxyUsername = req.getParameter("proxyUsername");
            String proxyPassword = req.getParameter("proxyPassword");
            String token = req.getParameter("token");
            this.url = url != null ? url.trim() : "";
            this.useProxy = useProxy;
            if (useProxy) {
                this.proxyUrl = proxyUrl != null ? proxyUrl.trim() : "";
                this.proxyUsername = proxyUsername != null ? Secret.fromString((String)proxyUsername.trim()) : null;
                this.proxyPassword = proxyPassword != null ? Secret.fromString((String)proxyPassword) : null;
            } else {
                this.proxyUrl = "";
                this.proxyUsername = null;
                this.proxyPassword = null;
            }
            Secret secret = this.token = token != null ? Secret.fromString((String)token.trim()) : null;
            if (!this.doTestConnection((String)this.url, (String)this.getToken(), null).kind.equals((Object)FormValidation.Kind.OK)) {
                return;
            }
            try {
                this.sensorPoolList = this.getSensorPoolListNoCache();
                StringBuilder buf = new StringBuilder();
                buf.append("{ \"list\" : [\n");
                for (int i = 0; i < this.sensorPoolList.size(); ++i) {
                    SensorPoolBean b = this.sensorPoolList.get(i);
                    buf.append("{ \"name\": \"" + b.getName() + "\", \"uuid\": \"" + b.getUuid() + "\" }");
                    if (i != this.sensorPoolList.size() - 1) {
                        buf.append(",\n");
                        continue;
                    }
                    buf.append("\n");
                }
                buf.append("]}");
                rsp.setContentType("text/html;charset=UTF-8");
                rsp.getWriter().print(buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                this.url = orig_url;
                this.useProxy = orig_useProxy;
                this.proxyUrl = orig_proxyUrl;
                this.proxyUsername = orig_proxyUsername;
                this.proxyPassword = orig_proxyPassword;
                this.token = orig_token;
            }
        }

        public void doCreateNewProject(final StaplerRequest req, StaplerResponse rsp, @QueryParameter String value) throws Exception {
            try {
                FortifyPlugin.runWithFortifyClient(this.getToken(), new FortifyClient.Command<FortifyClient.NoReturn>(){

                    @Override
                    public FortifyClient.NoReturn runWith(FortifyClient client) throws Exception {
                        OutputStreamWriter w = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
                        client.createProject(req.getParameter("newprojName"), req.getParameter("newprojVersion"), req.getParameter("newprojTemplate"), Collections.emptyMap(), new PrintWriter(w));
                        return FortifyClient.NoReturn.INSTANCE;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.doRefreshProjects(req, rsp, value);
        }

        public boolean configure(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            try {
                this.url = jsonObject.getString("url").trim();
                this.checkUrlValue(this.url);
            }
            catch (JSONException e) {
                System.out.println("Cannot restore 'URL' property. Will use default (empty) values.");
                this.url = null;
            }
            catch (FortifyException e) {
                System.out.println(e.getMessage());
                this.url = null;
            }
            JSONObject useProxy = null;
            try {
                useProxy = jsonObject.getJSONObject("useProxy");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (useProxy == null || useProxy.isNullObject()) {
                this.useProxy = false;
            } else {
                this.useProxy = true;
                try {
                    this.proxyUrl = useProxy.getString("proxyUrl").trim();
                    this.checkProxyUrlValue(this.proxyUrl);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    System.out.println("Cannot restore 'proxyUrl' property.  Will use default (empty) values.");
                    this.proxyUrl = null;
                }
                catch (FortifyException e) {
                    System.out.println(e.getMessage());
                    this.proxyUrl = null;
                }
                try {
                    String usernameParam = useProxy.getString("proxyUsername").trim();
                    this.checkProxyUsernameValue(usernameParam);
                    this.proxyUsername = usernameParam.isEmpty() ? null : Secret.fromString((String)usernameParam);
                }
                catch (JSONException e) {
                    System.out.println("Cannot restore 'proxyUsername' property.  Will use default (empty) values.");
                    this.proxyUsername = null;
                }
                catch (FortifyException e) {
                    System.out.println(e.getMessage());
                    this.proxyUsername = null;
                }
                try {
                    String pwdParam = useProxy.getString("proxyPassword").trim();
                    this.checkProxyPasswordValue(pwdParam);
                    this.proxyPassword = pwdParam.isEmpty() ? null : Secret.fromString((String)pwdParam);
                }
                catch (JSONException e) {
                    System.out.println("Cannot restore 'proxyPassword' property.  Will use default (empty) values.");
                    this.proxyPassword = null;
                }
                catch (FortifyException e) {
                    System.out.println(e.getMessage());
                    this.proxyPassword = null;
                }
            }
            try {
                String tokenParam = jsonObject.getString("token").trim();
                this.token = tokenParam.isEmpty() ? null : Secret.fromString((String)tokenParam);
            }
            catch (JSONException e) {
                System.out.println("Cannot restore 'Authentication Token' property. Will use default (empty) values.");
                this.token = null;
            }
            try {
                this.projectTemplate = jsonObject.getString("projectTemplate").trim();
            }
            catch (JSONException e) {
                System.out.println("Cannot restore 'Issue template' property. Will use default (empty) values.");
                this.projectTemplate = null;
            }
            try {
                String pageSizeString = jsonObject.getString("breakdownPageSize");
                this.breakdownPageSize = pageSizeString != null && pageSizeString.trim().length() > 0 ? Integer.valueOf(Integer.parseInt(pageSizeString.trim())) : Integer.valueOf(50);
            }
            catch (NumberFormatException | JSONException e) {
                System.out.println("Cannot restore 'Issue breakdown page size' property. Will use default (50) value.");
                this.breakdownPageSize = 50;
            }
            try {
                String connectTimeoutString = jsonObject.getString("connectTimeout");
                this.connectTimeout = connectTimeoutString != null && connectTimeoutString.trim().length() > 0 ? Integer.valueOf(Integer.parseInt(connectTimeoutString.trim())) : null;
            }
            catch (NumberFormatException | JSONException e) {
                System.out.println("Cannot restore 'Connection timeout' property.");
                this.connectTimeout = null;
            }
            try {
                String readTimeoutString = jsonObject.getString("readTimeout");
                this.readTimeout = readTimeoutString != null && readTimeoutString.trim().length() > 0 ? Integer.valueOf(Integer.parseInt(readTimeoutString.trim())) : null;
            }
            catch (NumberFormatException | JSONException e) {
                System.out.println("Cannot restore 'Read timeout' property.");
                this.readTimeout = null;
            }
            try {
                String writeTimeoutString = jsonObject.getString("writeTimeout");
                this.writeTimeout = writeTimeoutString != null && writeTimeoutString.trim().length() > 0 ? Integer.valueOf(Integer.parseInt(writeTimeoutString.trim())) : null;
            }
            catch (NumberFormatException | JSONException e) {
                System.out.println("Cannot restore 'Write timeout' property.");
                this.writeTimeout = null;
            }
            try {
                this.ctrlUrl = jsonObject.getString("ctrlUrl").trim();
                this.checkCtrlUrlValue(this.ctrlUrl);
            }
            catch (JSONException e) {
                System.out.println("Cannot restore 'CTRLURL' property. Will use default (empty) values.");
                this.ctrlUrl = null;
            }
            catch (FortifyException e) {
                System.out.println(e.getMessage());
                this.ctrlUrl = null;
            }
            try {
                String ctrlTokenParam = jsonObject.getString("ctrlToken").trim();
                this.ctrlToken = ctrlTokenParam.isEmpty() ? null : Secret.fromString((String)ctrlTokenParam);
            }
            catch (JSONException e) {
                System.out.println("Cannot restore 'Controller token' property. Will use default (empty) values.");
                this.ctrlToken = null;
            }
            this.save();
            this.isSettingUpdated = true;
            return super.configure(req, jsonObject);
        }

        public boolean isSettingUpdated() {
            try {
                boolean bl = this.isSettingUpdated;
                return bl;
            }
            finally {
                this.isSettingUpdated = false;
            }
        }

        public ComboBoxModel doFillAppNameItems() {
            Map<String, Map<String, Long>> allPrj = this.getAllProjects();
            return new ComboBoxModel(allPrj.keySet());
        }

        public ComboBoxModel getAppNameItems() {
            return this.doFillAppNameItems();
        }

        public ComboBoxModel doFillAppVersionItems(@QueryParameter String appName) {
            Map<String, Long> allPrjVersions = this.getAllProjects().get(appName);
            if (null == allPrjVersions) {
                return new ComboBoxModel(Collections.emptyList());
            }
            return new ComboBoxModel(allPrjVersions.keySet());
        }

        public ComboBoxModel getAppVersionItems(@QueryParameter String appName) {
            return this.doFillAppVersionItems(appName);
        }

        private Map<String, Map<String, Long>> getAllProjects() {
            if (this.allProjects.isEmpty()) {
                this.allProjects = this.getAllProjectsNoCache();
            }
            return this.allProjects;
        }

        private Map<String, Map<String, Long>> getAllProjectsNoCache() {
            if (this.canUploadToSsc()) {
                try {
                    Map map = (Map)FortifyPlugin.runWithFortifyClient(this.getToken(), new FortifyClient.Command<Map<String, Map<String, Long>>>(){

                        @Override
                        public Map<String, Map<String, Long>> runWith(FortifyClient client) throws Exception {
                            return client.getProjectListEx();
                        }
                    });
                    return map;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return Collections.emptyMap();
                }
            }
            return Collections.emptyMap();
        }

        public ComboBoxModel doFillProjectTemplateItems() {
            if (this.projTemplateList.isEmpty()) {
                this.projTemplateList = this.getProjTemplateListNoCache();
            }
            ArrayList<String> names = new ArrayList<String>(this.projTemplateList.size());
            for (ProjectTemplateBean b : this.projTemplateList) {
                names.add(b.getName());
            }
            return new ComboBoxModel(names);
        }

        public ComboBoxModel getProjectTemplateItems() {
            return this.doFillProjectTemplateItems();
        }

        public List<ProjectTemplateBean> getProjTemplateListList() {
            if (this.projTemplateList.isEmpty()) {
                this.projTemplateList = this.getProjTemplateListNoCache();
            }
            return this.projTemplateList;
        }

        private List<ProjectTemplateBean> getProjTemplateListNoCache() {
            if (this.canUploadToSsc()) {
                try {
                    Map map = (Map)FortifyPlugin.runWithFortifyClient(this.getToken(), new FortifyClient.Command<Map<String, String>>(){

                        @Override
                        public Map<String, String> runWith(FortifyClient client) throws Exception {
                            return client.getProjectTemplateList();
                        }
                    });
                    ArrayList<ProjectTemplateBean> list = new ArrayList<ProjectTemplateBean>(map.size());
                    for (Map.Entry entry : map.entrySet()) {
                        ProjectTemplateBean proj = new ProjectTemplateBean((String)entry.getKey(), (String)entry.getValue());
                        list.add(proj);
                    }
                    Collections.sort(list);
                    return list;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return Collections.emptyList();
        }

        public ListBoxModel doFillSensorPoolUUIDItems() {
            this.sensorPoolList = this.getSensorPoolListNoCache();
            ArrayList<ListBoxModel.Option> optionList = new ArrayList<ListBoxModel.Option>();
            for (SensorPoolBean sensorPoolBean : this.sensorPoolList) {
                ListBoxModel.Option option = new ListBoxModel.Option(sensorPoolBean.getName(), sensorPoolBean.getUuid());
                optionList.add(option);
            }
            return new ListBoxModel(optionList);
        }

        public List<SensorPoolBean> getSensorPoolList() {
            if (this.sensorPoolList.isEmpty()) {
                this.sensorPoolList = this.getSensorPoolListNoCache();
            }
            return this.sensorPoolList;
        }

        private List<SensorPoolBean> getSensorPoolListNoCache() {
            if (DESCRIPTOR.getUrl() == null) {
                return Collections.emptyList();
            }
            try {
                Map map = (Map)FortifyPlugin.runWithFortifyClient(this.getToken(), new FortifyClient.Command<Map<String, String>>(){

                    @Override
                    public Map<String, String> runWith(FortifyClient client) throws Exception {
                        return client.getCloudScanPoolList();
                    }
                });
                ArrayList<SensorPoolBean> list = new ArrayList<SensorPoolBean>(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    SensorPoolBean proj = new SensorPoolBean((String)entry.getKey(), (String)entry.getValue());
                    list.add(proj);
                }
                Collections.sort(list);
                return list;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }

        public ListBoxModel doFillLocaleItems(String value) {
            ListBoxModel items = new ListBoxModel();
            items.add("English", "en");
            items.add("Chinese Simplified", "zh_CN");
            items.add("Chinese Traditional", "zh_TW");
            items.add("Japanese", "ja");
            items.add("Korean", "ko");
            items.add("Portuguese (Brazil)", "pt_BR");
            items.add("Spanish", "es");
            if (null == value || 0 == value.length()) {
                ((ListBoxModel.Option)items.get((int)0)).selected = true;
            }
            return items;
        }
    }
}

