/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins;

import com.fortify.plugin.jenkins.PathUtils;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import org.jenkinsci.remoting.RoleChecker;

public class FindExecutableRemoteService
implements FilePath.FileCallable<String> {
    private final String filename;
    private String home;
    private String path;
    private final FilePath workspace;

    public FindExecutableRemoteService(String filename, String home, String path, FilePath workspace) {
        this.filename = filename;
        this.home = home;
        this.path = path;
        this.workspace = workspace;
    }

    public String invoke(File file, VirtualChannel channel) throws IOException {
        File f;
        if (this.home != null) {
            String s;
            File f2;
            if (!this.home.endsWith(File.separator)) {
                this.home = this.home + File.separator;
            }
            if ((f2 = new File(s = this.home + "bin" + File.separator + this.filename)).isFile()) {
                return s;
            }
        }
        if (this.path == null) {
            this.path = System.getenv("PATH");
        }
        if ((f = PathUtils.locateFileInPath(this.filename, this.path)) != null) {
            return f.getPath();
        }
        if (this.workspace != null && (f = PathUtils.locateFileInPath(this.filename, this.workspace.getRemote())) != null) {
            return f.getPath();
        }
        return null;
    }

    public void checkRoles(RoleChecker arg0) throws SecurityException {
    }
}

