/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.plugin.jenkins;

import com.fortify.plugin.jenkins.bean.IssueFolderBean;
import com.thoughtworks.xstream.XStream;
import hudson.FilePath;
import hudson.XmlFile;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class FPRSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FILE_BASENAME = "fortify";
    private static final String FILE_EXTENSION = ".xml";
    private FilePath fprFile;
    private String logMsg;
    private transient PersistentSummary persistentSummary = new PersistentSummary();

    private String buildFilename(String appName, String appVersion) {
        String filename = FILE_BASENAME;
        if (appName != null) {
            filename = filename + "-" + appName;
        }
        if (appVersion != null) {
            filename = filename + "-" + appVersion;
        }
        filename = filename + FILE_EXTENSION;
        return filename;
    }

    public void load(File parent, String appName, String appVersion) throws IOException {
        File file = new File(parent, this.buildFilename(appName, appVersion));
        XmlFile xml = new XmlFile(this.getXStream(), file);
        this.persistentSummary = (PersistentSummary)xml.read();
    }

    public void save(File parent, String appName, String appVersion) throws IOException {
        File file = new File(parent, this.buildFilename(appName, appVersion));
        XmlFile xml = new XmlFile(this.getXStream(), file);
        xml.write((Object)this.persistentSummary);
    }

    public double getNvs() {
        return this.persistentSummary.nvs;
    }

    public void setNvs(double nvs) {
        this.persistentSummary.nvs = nvs;
    }

    public void setFolderBeans(List<IssueFolderBean> folderBeans) {
        this.persistentSummary.folderBeans = folderBeans;
    }

    public List<IssueFolderBean> getFolderBeans() {
        return null == this.persistentSummary.folderBeans ? Collections.emptyList() : this.persistentSummary.folderBeans;
    }

    public FilePath getFprFile() {
        return this.fprFile;
    }

    public void setFprFile(FilePath fprFile) {
        this.fprFile = fprFile;
    }

    public int getFailedCount() {
        return this.persistentSummary.failedCount;
    }

    public void setFailedCount(int failedCount) {
        this.persistentSummary.failedCount = failedCount;
    }

    public int getTotalIssues() {
        return this.persistentSummary.totalIssues;
    }

    public void setTotalIssues(int totalIssues) {
        this.persistentSummary.totalIssues = totalIssues;
    }

    public void log(String msg) {
        if (null == this.logMsg) {
            this.logMsg = msg;
        } else if (null != msg) {
            this.logMsg = this.logMsg + msg;
        }
    }

    public String getLogMessage() {
        return this.logMsg;
    }

    private XStream getXStream() {
        XStream2 stream = new XStream2();
        stream.alias("issueFolder", IssueFolderBean.class);
        stream.alias("fortifySummary", PersistentSummary.class);
        return stream;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.persistentSummary = new PersistentSummary();
    }

    private static class PersistentSummary {
        private int failedCount;
        private double nvs;
        private List<IssueFolderBean> folderBeans;
        private int totalIssues;

        private PersistentSummary() {
        }
    }
}

