/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.fogbugz.notifications;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public class LogMessageSearcher {
    private AbstractBuild build;
    public static String DEFAULT_MESSAGE_KEYWORD = "[BuildReportMessage]";

    public LogMessageSearcher(AbstractBuild build) {
        this.build = build;
    }

    public static void logMessage(BuildListener listener, String message) {
        listener.getLogger().append(LogMessageSearcher.getMessagePrefix() + message + "\n");
    }

    public static String getMessagePrefix() {
        return DEFAULT_MESSAGE_KEYWORD + " ";
    }

    public List<String> searchForMessages() throws IOException {
        return this.searchForMessages(DEFAULT_MESSAGE_KEYWORD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> searchForMessages(String keyword) throws IOException {
        File logFile = this.build.getLogFile();
        ArrayList<String> resultList = new ArrayList<String>();
        try (LineIterator it = FileUtils.lineIterator((File)logFile, (String)"UTF-8");){
            while (it.hasNext()) {
                String line = it.nextLine();
                if (!line.contains(keyword)) continue;
                resultList.add(line);
            }
        }
        return resultList;
    }
}

