/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.fogbugz.notifications;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.fogbugz.FogbugzProjectProperty;
import jenkins.plugins.fogbugz.notifications.LogMessageSearcher;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.paylogic.fogbugz.FogbugzCase;
import org.paylogic.fogbugz.FogbugzEvent;
import org.paylogic.fogbugz.FogbugzManager;

public class FogbugzNotifier
extends Notifier {
    private static final Logger log = Logger.getLogger(FogbugzNotifier.class.getName());

    @DataBoundConstructor
    public FogbugzNotifier() {
    }

    public String getDisplayName() {
        return "Fogbugz notification settings";
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    private String stringOrEmpty(int param) {
        return param == 0 ? Integer.toString(param) : "";
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        Template mustacheTemplate;
        log.info("Now performing post-build action for Fogbugz reporting.");
        PrintStream l = listener.getLogger();
        l.println("----------------------------------------------------------");
        l.println("----------- Now sending build status to FogBugz ----------");
        l.println("----------------------------------------------------------");
        EnvVars envVars = null;
        try {
            envVars = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception while fetching environment variables.", e);
        }
        String givenCaseId = envVars.get("CASE_ID", "");
        if (givenCaseId.isEmpty() || givenCaseId.equals("0")) {
            log.info("No case branch found, currently not reporting to fogbugz.");
            return false;
        }
        log.info("Using given case ID for reporting.");
        int usableCaseId = 0;
        if (!givenCaseId.isEmpty()) {
            usableCaseId = Integer.parseInt(givenCaseId);
        }
        LogMessageSearcher messageSearcher = new LogMessageSearcher(build);
        String reportingExtraMessage = "";
        try {
            for (String line : messageSearcher.searchForMessages()) {
                reportingExtraMessage = reportingExtraMessage + line.replace(LogMessageSearcher.getMessagePrefix(), "") + "\n";
            }
        }
        catch (IOException e) {
            reportingExtraMessage = "Failure while retrieving messages from logfile.";
            log.log(Level.SEVERE, "Failure while retrieving messages from logfile.", e);
        }
        if (build.getResult() != Result.SUCCESS) {
            reportingExtraMessage = reportingExtraMessage + "\nGatekeepering and Upmerging have been aborted, and no further actions were performed, because the build failed.";
        }
        FogbugzManager caseManager = this.getFogbugzManager();
        FogbugzCase fbCase = null;
        try {
            fbCase = caseManager.getCaseById(usableCaseId);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Fetching case from fogbugz failed. Please check your settings.", e);
            listener.getLogger().append("Fetching case from Fogbugz failed. Please check your settings.");
            return false;
        }
        if (fbCase == null) {
            log.log(Level.SEVERE, "Fetching case from fogbugz failed. Please check your settings.");
            return false;
        }
        FogbugzEvent lastAssignmentEvent = caseManager.getLastAssignedTo(fbCase.getId(), this.getDescriptor().getGatekeeperUserId());
        if (lastAssignmentEvent == null) {
            lastAssignmentEvent = caseManager.getLastAssignedTo(fbCase.getId(), this.getDescriptor().getMergekeeperUserId());
        }
        Context templateContext = Context.newContext(null);
        templateContext.data("url", (Object)build.getAbsoluteUrl());
        templateContext.data("buildNumber", (Object)Integer.toString(build.getNumber()));
        templateContext.data("buildResult", (Object)build.getResult().toString());
        templateContext.data("buildTime", (Object)build.getDurationString());
        templateContext.data("builtOn", (Object)build.getBuiltOnStr());
        log.log(Level.FINE, "ReportingExtraMessage: " + reportingExtraMessage);
        templateContext.data("messages", (Object)StringEscapeUtils.unescapeXml((String)StringEscapeUtils.unescapeHtml((String)reportingExtraMessage)));
        try {
            AbstractTestResultAction testResultAction = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class);
            if (testResultAction != null) {
                templateContext.data("tests_failed", (Object)testResultAction.getFailCount());
                templateContext.data("tests_skipped", (Object)testResultAction.getSkipCount());
                templateContext.data("tests_total", (Object)testResultAction.getTotalCount());
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception during fetching of test results:", e);
            templateContext.data("tests_failed", (Object)"");
            templateContext.data("tests_skipped", (Object)"");
            templateContext.data("tests_total", (Object)"");
        }
        if (this.getDescriptor().doAssignBaseCase()) {
            try {
                fbCase.setAssignedTo(lastAssignmentEvent.getPerson());
            }
            catch (Exception e) {
                fbCase.setAssignedTo(this.getDescriptor().getGatekeeperUserId());
            }
        }
        Handlebars handlebars = new Handlebars();
        if (build.getResult() == Result.SUCCESS) {
            try {
                mustacheTemplate = handlebars.compileInline(this.getDescriptor().getSuccessfulBuildTemplate());
            }
            catch (IOException e) {
                mustacheTemplate = null;
            }
            if (this.getDescriptor().getSuccessfulBuildTag() != null && !this.getDescriptor().getSuccessfulBuildTag().isEmpty()) {
                fbCase.addTag(this.getDescriptor().getSuccessfulBuildTag());
            }
            if (this.getDescriptor().doAssignBaseCase()) {
                String milestoneName = fbCase.getTargetBranch().substring(1, fbCase.getTargetBranch().length());
                caseManager.createMilestoneIfNotExists(milestoneName);
                fbCase.setMilestone(milestoneName);
            }
        } else {
            try {
                mustacheTemplate = handlebars.compileInline(this.getDescriptor().getFailedBuildTemplate());
            }
            catch (IOException e) {
                mustacheTemplate = null;
            }
        }
        String message = "Error rendering template during reporting! Please check jenkins configuration.";
        if (mustacheTemplate != null) {
            try {
                message = mustacheTemplate.apply(templateContext);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        caseManager.saveCase(fbCase, message);
        return true;
    }

    public void notifyScheduled(FogbugzCase fbCase, Project<?, ?> p) {
        Template mustacheTemplate;
        Context templateContext = Context.newContext(null);
        templateContext.data("url", (Object)p.getAbsoluteUrl());
        templateContext.data("name", (Object)p.getName());
        Handlebars handlebars = new Handlebars();
        try {
            mustacheTemplate = handlebars.compileInline(this.getDescriptor().getScheduledBuildTemplate());
        }
        catch (IOException e) {
            mustacheTemplate = null;
        }
        String message = "Error rendering scheduled template during reporting! Please check jenkins configuration.";
        if (mustacheTemplate != null) {
            try {
                message = mustacheTemplate.apply(templateContext);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.getFogbugzManager().saveCase(fbCase, message);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public FogbugzManager getFogbugzManager() {
        return this.getDescriptor().getFogbugzManager();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String token;
        private String failedBuildTemplate;
        private String successfulBuildTemplate;
        private String scheduledBuildTemplate;
        private String featureBranchFieldname;
        private String originalBranchFieldname;
        private String targetBranchFieldname;
        private String approvedRevisionFieldname;
        private String ciProjectFieldName;
        private int mergekeeperUserId;
        private int gatekeeperUserId;
        private boolean assignBackCase = true;
        private boolean setMilestone = true;
        private String successfulBuildTag = "";

        public String getUrl() {
            return new FogbugzProjectProperty().getDescriptor().getUrl();
        }

        public boolean doAssignBaseCase() {
            return this.assignBackCase;
        }

        public boolean doSetMilestone() {
            return this.setMilestone;
        }

        public int getMergekeeperUserId() {
            if (this.mergekeeperUserId == 0) {
                return 1;
            }
            return this.mergekeeperUserId;
        }

        public int getGatekeeperUserId() {
            if (this.gatekeeperUserId == 0) {
                return 1;
            }
            return this.gatekeeperUserId;
        }

        public String getFailedBuildTemplate() {
            if (this.failedBuildTemplate == null || this.failedBuildTemplate.isEmpty()) {
                return "Jenkins reports that the build has {{tests_failed}} failed tests :(\nBuild took {{buildTime}}\nCatched log messages:\n{{messages}}\nView extended result here: {{url}}";
            }
            return this.failedBuildTemplate;
        }

        public String getSuccessfulBuildTemplate() {
            if (this.successfulBuildTemplate == null || this.successfulBuildTemplate.isEmpty()) {
                return "Jenkins reports that the build was successful!\nBuild took {{buildTime}}\nCatched log messages:\n{{messages}}\nView extended result here: {{url}}";
            }
            return this.successfulBuildTemplate;
        }

        public String getScheduledBuildTemplate() {
            if (this.scheduledBuildTemplate == null || this.scheduledBuildTemplate.isEmpty()) {
                return "Scheduled a jenkins build on a {{name}} job. Stay tuned!\nView the job here: {{url}}";
            }
            return this.scheduledBuildTemplate;
        }

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> type) {
            return true;
        }

        public String getDisplayName() {
            return "Report status to related FogBugz case.";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.token = formData.getString("token");
            this.featureBranchFieldname = formData.getString("featureBranchFieldname");
            this.originalBranchFieldname = formData.getString("originalBranchFieldname");
            this.targetBranchFieldname = formData.getString("targetBranchFieldname");
            this.approvedRevisionFieldname = formData.getString("approvedRevisionFieldname");
            this.ciProjectFieldName = formData.getString("ciProjectFieldname");
            int mergekeeperid = formData.getInt("mergekeeperUserId");
            if (mergekeeperid == 0) {
                mergekeeperid = 1;
            }
            this.mergekeeperUserId = mergekeeperid;
            int gatekeeperid = formData.getInt("gatekeeperUserId");
            if (gatekeeperid == 0) {
                gatekeeperid = 1;
            }
            this.gatekeeperUserId = gatekeeperid;
            this.failedBuildTemplate = formData.getString("failedBuildTemplate");
            this.successfulBuildTemplate = formData.getString("successfulBuildTemplate");
            this.scheduledBuildTemplate = formData.getString("scheduledBuildTemplate");
            this.assignBackCase = formData.getBoolean("assignBackCase");
            this.setMilestone = formData.getBoolean("setMilestone");
            this.successfulBuildTag = formData.getString("successfulBuildTag");
            this.save();
            return super.configure(req, formData);
        }

        public FogbugzManager getFogbugzManager() {
            return new FogbugzManager(this.getUrl(), this.getToken(), this.getFeatureBranchFieldname(), this.getOriginalBranchFieldname(), this.getTargetBranchFieldname(), this.getApprovedRevisionFieldname(), this.getCiProjectFieldName(), this.getMergekeeperUserId(), this.getGatekeeperUserId());
        }

        public String getToken() {
            return this.token;
        }

        public String getFeatureBranchFieldname() {
            return this.featureBranchFieldname;
        }

        public String getOriginalBranchFieldname() {
            return this.originalBranchFieldname;
        }

        public String getTargetBranchFieldname() {
            return this.targetBranchFieldname;
        }

        public String getApprovedRevisionFieldname() {
            return this.approvedRevisionFieldname;
        }

        public String getCiProjectFieldName() {
            return this.ciProjectFieldName;
        }

        public boolean isAssignBackCase() {
            return this.assignBackCase;
        }

        public boolean isSetMilestone() {
            return this.setMilestone;
        }

        public String getSuccessfulBuildTag() {
            return this.successfulBuildTag;
        }
    }
}

