/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.plugin.deflake;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.jenkins.flakyTestHandler.plugin.FlakyTestResultAction;
import com.google.jenkins.flakyTestHandler.plugin.deflake.DeflakeCause;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BooleanParameterValue;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class DeflakeAction
implements Action {
    private static final String DEFLAKE_CONFIG_URL = "deflakeConfig";
    private static final String RERUN_FAILING_TESTS_COUNT_PARAM = "rerunFailingTestsCountParam";
    private static final String MAVEN_TEST_PARAM = "testParam";
    private static final String MAVEN_TEST = "test";
    private static final String COMMA = ",";
    private static final String SHARP = "#";
    private static final String PLUS = "+";
    private static final Function<Map.Entry<String, Set<String>>, String> CLASS_METHOD_MAP_TO_MAVEN_TESTS_LIST = new Function<Map.Entry<String, Set<String>>, String>(){

        @Nonnull
        public String apply(@Nonnull Map.Entry<String, Set<String>> entry) {
            return entry.getKey() + DeflakeAction.SHARP + Joiner.on((String)DeflakeAction.PLUS).join((Iterable)entry.getValue());
        }
    };
    private final Map<String, Set<String>> failingClassMethodMap;

    public DeflakeAction(Map<String, Set<String>> failingClassMethodMap) {
        this.failingClassMethodMap = failingClassMethodMap;
    }

    public String getIconFileName() {
        return "clock.png";
    }

    public String getDisplayName() {
        return "Deflake this build";
    }

    public String getUrlName() {
        return "deflake";
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException, ServletException, InterruptedException {
        Run currentBuild = (Run)request.findAncestorObject(Run.class);
        if (currentBuild != null) {
            Job job = currentBuild.getParent();
            job.checkPermission(AbstractProject.BUILD);
            response.sendRedirect(DEFLAKE_CONFIG_URL);
        }
    }

    @RequirePOST
    public void doSubmitDeflakeRequest(StaplerRequest request, StaplerResponse response) throws IOException, ServletException, InterruptedException {
        Run run = (Run)request.findAncestorObject(Run.class);
        if (run != null) {
            ParametersAction originalParamAction;
            String testParameter;
            Job job = run.getParent();
            job.checkPermission(AbstractProject.BUILD);
            List<Action> actions = DeflakeAction.constructDeflakeCause(run);
            JSONObject formData = request.getSubmittedForm();
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            parameterValues.add(DeflakeAction.getStringParam(formData, RERUN_FAILING_TESTS_COUNT_PARAM));
            JSONObject paramObj = JSONObject.fromObject((Object)formData.get(MAVEN_TEST_PARAM));
            boolean onlyRunFailingTests = paramObj.getBoolean("value");
            if (onlyRunFailingTests && (testParameter = this.generateMavenTestParams()) != null) {
                parameterValues.add(new StringParameterValue(MAVEN_TEST, testParameter));
            }
            if ((originalParamAction = (ParametersAction)run.getAction(ParametersAction.class)) == null) {
                originalParamAction = new ParametersAction(new ParameterValue[0]);
            }
            actions.add((Action)originalParamAction.createUpdated(parameterValues));
            Jenkins.getInstance().getQueue().schedule((Queue.Task)run.getParent(), 0, actions);
        }
        response.sendRedirect("../../");
    }

    String generateMavenTestParams() {
        return Joiner.on((String)COMMA).join(Iterables.transform(this.failingClassMethodMap.entrySet(), CLASS_METHOD_MAP_TO_MAVEN_TESTS_LIST));
    }

    private static List<Action> constructDeflakeCause(Run up) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add((Action)new CauseAction((Cause)new DeflakeCause(up)));
        return actions;
    }

    private static ParameterValue getBooleanParam(JSONObject formData, String paramName) {
        JSONObject paramObj = JSONObject.fromObject((Object)formData.get(paramName));
        String name = paramObj.getString("name");
        FlakyTestResultAction.logger.log(Level.FINE, "Param: " + name + " with value: " + paramObj.getBoolean("value"));
        return new BooleanParameterValue(name, paramObj.getBoolean("value"));
    }

    private static ParameterValue getStringParam(JSONObject formData, String paramName) {
        JSONObject paramObj = JSONObject.fromObject((Object)formData.get(paramName));
        String name = paramObj.getString("name");
        FlakyTestResultAction.logger.log(Level.FINE, "Param: " + name + " with value: " + paramObj.getString("value"));
        return new StringParameterValue(name, paramObj.getString("value"));
    }
}

