/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.junit;

import com.google.jenkins.flakyTestHandler.junit.ActionableFlakyTestObject;
import com.google.jenkins.flakyTestHandler.junit.FlakyClassResult;
import com.google.jenkins.flakyTestHandler.junit.FlakySuiteResult;
import com.google.jenkins.flakyTestHandler.junit.FlakyTestResult;
import com.google.jenkins.flakyTestHandler.plugin.JUnitFlakyTestDataAction;
import hudson.model.AbstractBuild;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestNameTransformer;
import hudson.tasks.test.TestResult;
import hudson.util.TextFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.dom4j.Element;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;
import org.kohsuke.stapler.export.Exported;

public class FlakyCaseResult
extends TestResult
implements Comparable<FlakyCaseResult>,
ActionableFlakyTestObject {
    private static final Logger LOGGER = Logger.getLogger(FlakyCaseResult.class.getName());
    private final float duration;
    private final String className;
    private final String testName;
    private transient String safeName;
    private final boolean skipped;
    private final String skippedMessage;
    private final String errorStackTrace;
    private final String errorDetails;
    private FlakySuiteResult parent;
    private transient FlakyClassResult classResult;
    private final String stdout;
    private final String stderr;
    private final List<FlakyRunInformation> flakyRuns;
    private static final int HALF_MAX_SIZE = 500;
    private static final long serialVersionUID = 1L;

    private static float parseTime(Element testCase) {
        String time = testCase.attributeValue("time");
        if (time != null) {
            time = time.replace(",", "");
            try {
                return Float.parseFloat(time);
            }
            catch (NumberFormatException e) {
                try {
                    return new DecimalFormat().parse(time).floatValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return 0.0f;
    }

    FlakyCaseResult(FlakySuiteResult parent, Element testCase, String testClassName, boolean keepLongStdio) {
        String nameAttr = testCase.attributeValue("name");
        if (testClassName == null && nameAttr.contains(".")) {
            testClassName = nameAttr.substring(0, nameAttr.lastIndexOf(46));
            nameAttr = nameAttr.substring(nameAttr.lastIndexOf(46) + 1);
        }
        this.className = testClassName;
        this.testName = nameAttr;
        this.errorStackTrace = FlakyCaseResult.getError(testCase);
        this.errorDetails = FlakyCaseResult.getErrorMessage(testCase);
        this.parent = parent;
        this.duration = FlakyCaseResult.parseTime(testCase);
        this.skipped = FlakyCaseResult.isMarkedAsSkipped(testCase);
        this.skippedMessage = FlakyCaseResult.getSkippedMessage(testCase);
        Set<FlakyCaseResult> _this = Collections.singleton(this);
        this.stdout = FlakyCaseResult.possiblyTrimStdio(_this, keepLongStdio, testCase.elementText("system-out"));
        this.stderr = FlakyCaseResult.possiblyTrimStdio(_this, keepLongStdio, testCase.elementText("system-err"));
        List<Element> flakyElements = FlakyCaseResult.getAllFlakyElements(testCase);
        this.flakyRuns = FlakyCaseResult.getFlakyRunInformation(flakyElements);
    }

    static String possiblyTrimStdio(Collection<FlakyCaseResult> results, boolean keepLongStdio, String stdio) {
        if (stdio == null) {
            return null;
        }
        if (!FlakyCaseResult.isTrimming(results, keepLongStdio)) {
            return stdio;
        }
        int len = stdio.length();
        int middle = len - 1000;
        if (middle <= 0) {
            return stdio;
        }
        return stdio.subSequence(0, 500) + "\n...[truncated " + middle + " chars]...\n" + stdio.subSequence(len - 500, len);
    }

    static String possiblyTrimStdio(Collection<FlakyCaseResult> results, boolean keepLongStdio, File stdio) throws IOException {
        int tailBytes;
        if (!FlakyCaseResult.isTrimming(results, keepLongStdio) && stdio.length() < 0x100000L) {
            return FileUtils.readFileToString((File)stdio);
        }
        long len = stdio.length();
        long middle = len - 1000L;
        if (middle <= 0L) {
            return FileUtils.readFileToString((File)stdio);
        }
        TextFile tx = new TextFile(stdio);
        String head = tx.head(500);
        String tail = tx.fastTail(500);
        int headBytes = head.getBytes("UTF-8").length;
        middle = len - (long)(headBytes + (tailBytes = tail.getBytes("UTF-8").length));
        if (middle <= 0L) {
            return FileUtils.readFileToString((File)stdio);
        }
        return head + "\n...[truncated " + middle + " bytes]...\n" + tail;
    }

    private static boolean isTrimming(Collection<FlakyCaseResult> results, boolean keepLongStdio) {
        if (keepLongStdio) {
            return false;
        }
        for (FlakyCaseResult result : results) {
            if (result.errorStackTrace == null) continue;
            return false;
        }
        return true;
    }

    private static List<Element> getAllFlakyElements(Element testCase) {
        ArrayList<Element> flakyElements = new ArrayList<Element>();
        for (Object object : testCase.elements()) {
            Element element = (Element)object;
            if (!element.getName().equals("flakyFailure") && !element.getName().equals("flakyError") && !element.getName().equals("rerunFailure") && !element.getName().equals("rerunError")) continue;
            flakyElements.add(element);
        }
        return flakyElements;
    }

    private static List<FlakyRunInformation> getFlakyRunInformation(List<Element> flakyElements) {
        ArrayList<FlakyRunInformation> flakyRunInformation = new ArrayList<FlakyRunInformation>();
        for (Element flakyElement : flakyElements) {
            String errorDetails = flakyElement.attributeValue("message");
            String errorStackTrace = flakyElement.getText();
            String flakyStdout = flakyElement.elementText("system-out");
            String flakyStderr = flakyElement.elementText("system-err");
            flakyRunInformation.add(new FlakyRunInformation(errorDetails, errorStackTrace, flakyStdout, flakyStderr));
        }
        return flakyRunInformation;
    }

    public FlakyCaseResult(FlakySuiteResult parent, String testName, String errorStackTrace) {
        this.className = parent == null ? "unnamed" : parent.getName();
        this.testName = testName;
        this.errorStackTrace = errorStackTrace;
        this.errorDetails = "";
        this.parent = parent;
        this.stdout = null;
        this.stderr = null;
        this.duration = 0.0f;
        this.skipped = false;
        this.skippedMessage = null;
        this.flakyRuns = new ArrayList<FlakyRunInformation>();
    }

    public FlakyClassResult getParent() {
        return this.classResult;
    }

    private static String getError(Element testCase) {
        String msg = testCase.elementText("error");
        if (msg != null) {
            return msg;
        }
        return testCase.elementText("failure");
    }

    private static String getErrorMessage(Element testCase) {
        Element msg = testCase.element("error");
        if (msg == null) {
            msg = testCase.element("failure");
        }
        if (msg == null) {
            return null;
        }
        return msg.attributeValue("message");
    }

    private static boolean isMarkedAsSkipped(Element testCase) {
        return testCase.element("skipped") != null;
    }

    private static String getSkippedMessage(Element testCase) {
        String message = null;
        Element skippedElement = testCase.element("skipped");
        if (skippedElement != null) {
            message = skippedElement.attributeValue("message");
        }
        return message;
    }

    public String getDisplayName() {
        return TestNameTransformer.getTransformedName((String)this.testName);
    }

    public List<FlakyRunInformation> getFlakyRuns() {
        return this.flakyRuns;
    }

    @Exported(visibility=999)
    public String getName() {
        return this.testName;
    }

    public String getTitle() {
        return "Case Result: " + this.getDisplayName();
    }

    @Exported(visibility=9)
    public float getDuration() {
        return this.duration;
    }

    public synchronized String getSafeName() {
        if (this.safeName != null) {
            return this.safeName;
        }
        StringBuilder buf = new StringBuilder(this.testName);
        for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            buf.setCharAt(i, '_');
        }
        this.safeName = buf.toString();
        return this.safeName;
    }

    @Exported(visibility=9)
    public String getClassName() {
        return this.className;
    }

    public String getSimpleName() {
        int idx = this.className.lastIndexOf(46);
        return this.className.substring(idx + 1);
    }

    public String getPackageName() {
        int idx = this.className.lastIndexOf(46);
        if (idx < 0) {
            return "(root)";
        }
        return this.className.substring(0, idx);
    }

    public String getFullName() {
        return this.className + '.' + this.getName();
    }

    public String getFullDisplayName() {
        return TestNameTransformer.getTransformedName((String)this.getFullName());
    }

    public int getFailCount() {
        if (this.isFailed()) {
            return 1;
        }
        return 0;
    }

    public int getSkipCount() {
        if (this.isSkipped()) {
            return 1;
        }
        return 0;
    }

    public int getPassCount() {
        return this.isPassed() ? 1 : 0;
    }

    @Exported
    public String getStdout() {
        if (this.stdout != null) {
            return this.stdout;
        }
        FlakySuiteResult sr = this.getSuiteResult();
        if (sr == null) {
            return "";
        }
        return this.getSuiteResult().getStdout();
    }

    @Exported
    public String getStderr() {
        if (this.stderr != null) {
            return this.stderr;
        }
        FlakySuiteResult sr = this.getSuiteResult();
        if (sr == null) {
            return "";
        }
        return this.getSuiteResult().getStderr();
    }

    public FlakyCaseResult getPreviousResult() {
        if (this.parent == null) {
            return null;
        }
        FlakySuiteResult pr = this.parent.getPreviousResult();
        if (pr == null) {
            return null;
        }
        return pr.getCase(this.getName());
    }

    public TestResult findCorrespondingResult(String id) {
        if (id.equals(FlakyCaseResult.safe((String)this.getName()))) {
            return this;
        }
        return null;
    }

    public Collection<? extends TestResult> getFailedTests() {
        return this.singletonListOfThisOrEmptyList(this.isFailed());
    }

    public Collection<? extends TestResult> getPassedTests() {
        return this.singletonListOfThisOrEmptyList(this.isPassed());
    }

    public Collection<? extends TestResult> getSkippedTests() {
        return this.singletonListOfThisOrEmptyList(this.isSkipped());
    }

    private Collection<? extends TestResult> singletonListOfThisOrEmptyList(boolean f) {
        if (f) {
            return Collections.singletonList(this);
        }
        return Collections.emptyList();
    }

    @Exported
    public String getErrorStackTrace() {
        return this.errorStackTrace;
    }

    @Exported
    public String getErrorDetails() {
        return this.errorDetails;
    }

    public boolean isPassed() {
        return !this.skipped && this.errorStackTrace == null;
    }

    @Exported(visibility=9)
    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean isFailed() {
        return !this.isPassed() && !this.isSkipped();
    }

    public boolean isFlaked() {
        return this.isPassed() && this.flakyRuns != null && this.flakyRuns.size() > 0;
    }

    @Exported
    public String getSkippedMessage() {
        return this.skippedMessage;
    }

    public FlakySuiteResult getSuiteResult() {
        return this.parent;
    }

    public AbstractBuild<?, ?> getOwner() {
        FlakySuiteResult sr = this.getSuiteResult();
        if (sr == null) {
            LOGGER.warning("In getOwner(), getSuiteResult is null");
            return null;
        }
        FlakyTestResult tr = sr.getParent();
        if (tr == null) {
            LOGGER.warning("In getOwner(), suiteResult.getParent() is null.");
            return null;
        }
        return tr.getOwner();
    }

    public void setParentSuiteResult(FlakySuiteResult parent) {
        this.parent = parent;
    }

    public void freeze(FlakySuiteResult parent) {
        this.parent = parent;
    }

    @Override
    public int compareTo(@Nonnull FlakyCaseResult that) {
        return this.getFullName().compareTo(that.getFullName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlakyCaseResult that = (FlakyCaseResult)o;
        return Objects.equals(this.getFullName(), that.getFullName());
    }

    public int hashCode() {
        return Objects.hash(this.getFullName());
    }

    @Exported(name="status", visibility=9)
    public Status getStatus() {
        if (this.skipped) {
            return Status.SKIPPED;
        }
        FlakyCaseResult pr = this.getPreviousResult();
        if (pr == null) {
            return this.isPassed() ? Status.PASSED : Status.FAILED;
        }
        if (pr.isPassed()) {
            return this.isPassed() ? Status.PASSED : Status.REGRESSION;
        }
        return this.isPassed() ? Status.FIXED : Status.FAILED;
    }

    @Override
    public TestAction getTestAction() {
        return new JUnitFlakyTestDataAction(this.getFlakyRuns(), this.isFailed());
    }

    synchronized void setClass(FlakyClassResult classResult) {
        this.classResult = classResult;
    }

    void replaceParent(FlakySuiteResult parent) {
        this.parent = parent;
    }

    public static class FlakyRunInformation
    implements Serializable {
        final String flakyErrorDetails;
        final String flakyErrorStackTrace;
        final String flakyStdOut;
        final String flakyStdErr;

        public FlakyRunInformation(String flakyErrorDetails, String flakyErrorStackTrace, String flakyStdOut, String flakyStdErr) {
            this.flakyErrorDetails = flakyErrorDetails;
            this.flakyErrorStackTrace = flakyErrorStackTrace;
            this.flakyStdOut = flakyStdOut;
            this.flakyStdErr = flakyStdErr;
        }

        public String getFlakyErrorDetails() {
            return this.flakyErrorDetails;
        }

        public String getFlakyErrorStackTrace() {
            return this.flakyErrorStackTrace;
        }

        public String getFlakyStdOut() {
            return this.flakyStdOut;
        }

        public String getFlakyStdErr() {
            return this.flakyStdErr;
        }
    }

    @SuppressRestrictedWarnings(value={Messages.class})
    public static enum Status {
        PASSED("result-passed", Messages._CaseResult_Status_Passed(), true),
        SKIPPED("result-skipped", Messages._CaseResult_Status_Skipped(), false),
        FAILED("result-failed", Messages._CaseResult_Status_Failed(), false),
        FIXED("result-fixed", Messages._CaseResult_Status_Fixed(), true),
        REGRESSION("result-regression", Messages._CaseResult_Status_Regression(), false);

        private final String cssClass;
        private final Localizable message;
        public final boolean isOK;

        private Status(String cssClass, Localizable message, boolean OK) {
            this.cssClass = cssClass;
            this.message = message;
            this.isOK = OK;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public String getMessage() {
            return this.message.toString();
        }

        public boolean isRegression() {
            return this == REGRESSION;
        }
    }
}

