/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.junit;

import com.google.jenkins.flakyTestHandler.junit.FlakyCaseResult;
import com.google.jenkins.flakyTestHandler.junit.FlakyPackageResult;
import com.google.jenkins.flakyTestHandler.junit.FlakySuiteResult;
import com.google.jenkins.flakyTestHandler.plugin.HistoryAggregatedFlakyTestResultAction;
import hudson.AbortException;
import hudson.Util;
import hudson.model.Run;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.MetaTabulatedResult;
import hudson.tasks.test.TestObject;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tools.ant.DirectoryScanner;
import org.dom4j.DocumentException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public final class FlakyTestResult
extends MetaTabulatedResult {
    private final List<FlakySuiteResult> suites = new ArrayList<FlakySuiteResult>();
    private transient Map<String, FlakySuiteResult> suitesByName;
    private transient Map<String, FlakyPackageResult> byPackages;
    private transient AbstractTestResultAction parentAction;
    private transient Run owner;
    private transient TestObject parent;
    private TestResult testResultInstance;
    private transient int totalTests;
    private transient int skippedTests;
    private float duration;
    private transient List<FlakyCaseResult> failedTests;
    private transient List<FlakyCaseResult> flakyTests;
    private transient List<FlakyCaseResult> passedTests;
    private final boolean keepLongStdio;
    private static final long serialVersionUID = 1L;

    public FlakyTestResult(TestResult testResult) {
        for (SuiteResult suiteResult : testResult.getSuites()) {
            try {
                this.suites.addAll(FlakySuiteResult.parse(new File(suiteResult.getFile()), true));
                this.testResultInstance = testResult;
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        this.keepLongStdio = true;
    }

    public FlakyTestResult() {
        this.keepLongStdio = false;
    }

    public TestObject getParent() {
        return this.parent;
    }

    public void setParent(TestObject parent) {
        this.parent = parent;
    }

    public void parse(long buildTime, DirectoryScanner results) throws IOException {
        String[] includedFiles = results.getIncludedFiles();
        File baseDir = results.getBasedir();
        this.parse(buildTime, baseDir, includedFiles);
    }

    public void parse(long buildTime, File baseDir, String[] reportFiles) throws IOException {
        boolean parsed = false;
        for (String value : reportFiles) {
            File reportFile = new File(baseDir, value);
            if (buildTime - 3000L > reportFile.lastModified()) continue;
            this.parsePossiblyEmpty(reportFile);
            parsed = true;
        }
        if (!parsed) {
            long localTime = System.currentTimeMillis();
            if (localTime < buildTime - 1000L) {
                throw new AbortException("Clock on this slave is out of sync with the master, and therefore \nI can't figure out what test results are new and what are old.\nPlease keep the slave clock in sync with the master.");
            }
            File f = new File(baseDir, reportFiles[0]);
            throw new AbortException(String.format("Test reports were found but none of them are new. Did tests run? %nFor example, %s is %s old%n", f, Util.getTimeSpanString((long)(buildTime - f.lastModified()))));
        }
    }

    public void parse(long buildTime, Iterable<File> reportFiles) throws IOException {
        boolean parsed = false;
        for (File reportFile : reportFiles) {
            if (buildTime - 3000L > reportFile.lastModified()) continue;
            this.parsePossiblyEmpty(reportFile);
            parsed = true;
        }
        if (!parsed) {
            long localTime = System.currentTimeMillis();
            if (localTime < buildTime - 1000L) {
                throw new AbortException("Clock on this slave is out of sync with the master, and therefore \nI can't figure out what test results are new and what are old.\nPlease keep the slave clock in sync with the master.");
            }
            File f = reportFiles.iterator().next();
            throw new AbortException(String.format("Test reports were found but none of them are new. Did tests run? %nFor example, %s is %s old%n", f, Util.getTimeSpanString((long)(buildTime - f.lastModified()))));
        }
    }

    private void parsePossiblyEmpty(File reportFile) throws IOException {
        if (reportFile.length() == 0L) {
            FlakySuiteResult sr = new FlakySuiteResult(reportFile.getName(), "", "");
            sr.addCase(new FlakyCaseResult(sr, "<init>", "Test report file " + reportFile.getAbsolutePath() + " was length 0"));
            this.add(sr);
        } else {
            this.parse(reportFile);
        }
    }

    private void add(FlakySuiteResult sr) {
        for (FlakySuiteResult s : this.suites) {
            if (!s.getName().equals(sr.getName()) || !this.nullSafeEq(s.getId(), sr.getId())) continue;
            if (this.strictEq(s.getTimestamp(), sr.getTimestamp())) {
                return;
            }
            for (FlakyCaseResult cr : sr.getCases()) {
                s.addCase(cr);
                cr.replaceParent(s);
            }
            this.duration += sr.getDuration();
            return;
        }
        this.suites.add(sr);
        this.duration += sr.getDuration();
    }

    private boolean strictEq(Object lhs, Object rhs) {
        return lhs != null && rhs != null && lhs.equals(rhs);
    }

    private boolean nullSafeEq(Object lhs, Object rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        return lhs.equals(rhs);
    }

    public void parse(File reportFile) throws IOException {
        try {
            for (FlakySuiteResult suiteResult : FlakySuiteResult.parse(reportFile, this.keepLongStdio)) {
                this.add(suiteResult);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to read " + reportFile, e);
        }
        catch (RuntimeException e) {
            throw new IOException("Failed to read " + reportFile, e);
        }
        catch (DocumentException e) {
            if (!reportFile.getPath().endsWith(".xml")) {
                throw new IOException("Failed to read " + reportFile + "\nIs this really a JUnit report file? Your configuration must be matching too many files", e);
            }
            FlakySuiteResult sr = new FlakySuiteResult(reportFile.getName(), "", "");
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String error = "Failed to read test report file " + reportFile.getAbsolutePath() + "\n" + writer.toString();
            sr.addCase(new FlakyCaseResult(sr, "<init>", error));
            this.add(sr);
        }
    }

    public String getDisplayName() {
        return this.testResultInstance.getDisplayName();
    }

    public Run<?, ?> getRun() {
        if (this.parentAction != null) {
            return this.parentAction.owner;
        }
        return this.owner;
    }

    public hudson.tasks.test.TestResult findCorrespondingResult(String id) {
        return this.testResultInstance.findCorrespondingResult(id);
    }

    public String getTitle() {
        return this.testResultInstance.getTitle();
    }

    public String getChildTitle() {
        return this.testResultInstance.getChildTitle();
    }

    @Exported(visibility=999)
    public float getDuration() {
        return this.duration;
    }

    @Exported(visibility=999)
    public int getPassCount() {
        if (this.passedTests == null) {
            return 0;
        }
        return this.passedTests.size();
    }

    @Exported(visibility=999)
    public int getFailCount() {
        if (this.failedTests == null) {
            return 0;
        }
        return this.failedTests.size();
    }

    public int getTotalCount() {
        return this.totalTests;
    }

    @Exported(visibility=999)
    public int getSkipCount() {
        return this.skippedTests;
    }

    @Exported(visibility=999)
    public boolean isEmpty() {
        return this.getTotalCount() == 0;
    }

    public List<FlakyCaseResult> getFailedTests() {
        return this.failedTests;
    }

    public List<FlakyCaseResult> getFlakyTests() {
        return this.flakyTests;
    }

    public List<FlakyCaseResult> getAllTests() {
        ArrayList<FlakyCaseResult> allTests = new ArrayList<FlakyCaseResult>();
        allTests.addAll(this.failedTests);
        allTests.addAll(this.flakyTests);
        allTests.addAll(this.passedTests);
        return allTests;
    }

    public Collection<? extends hudson.tasks.test.TestResult> getPassedTests() {
        return this.passedTests;
    }

    public String getStdout() {
        return this.testResultInstance.getStdout();
    }

    public String getStderr() {
        return this.testResultInstance.getStderr();
    }

    public String getErrorStackTrace() {
        return this.testResultInstance.getErrorStackTrace();
    }

    public String getErrorDetails() {
        return this.testResultInstance.getErrorDetails();
    }

    public boolean isPassed() {
        return this.getFailCount() == 0;
    }

    public Collection<FlakyPackageResult> getChildren() {
        return this.byPackages.values();
    }

    public boolean hasChildren() {
        return !this.suites.isEmpty();
    }

    @Exported(inline=true, visibility=9)
    public Collection<FlakySuiteResult> getSuites() {
        return this.suites;
    }

    public String getName() {
        return "junit";
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (token.equals(this.getId())) {
            return this;
        }
        FlakyPackageResult result = this.byPackage(token);
        if (result != null) {
            return result;
        }
        return super.getDynamic(token, req, rsp);
    }

    public FlakyPackageResult byPackage(String packageName) {
        return this.byPackages.get(packageName);
    }

    public FlakySuiteResult getSuite(String name) {
        return this.suitesByName.get(name);
    }

    public void setParentAction(AbstractTestResultAction action) {
        this.parentAction = action;
        this.tally();
    }

    public AbstractTestResultAction getParentAction() {
        return this.parentAction;
    }

    public void tally() {
        this.suitesByName = new HashMap<String, FlakySuiteResult>();
        this.failedTests = new ArrayList<FlakyCaseResult>();
        this.flakyTests = new ArrayList<FlakyCaseResult>();
        this.passedTests = new ArrayList<FlakyCaseResult>();
        this.byPackages = new TreeMap<String, FlakyPackageResult>();
        this.totalTests = 0;
        this.skippedTests = 0;
        for (FlakySuiteResult s : this.suites) {
            s.setParent(this);
            this.suitesByName.put(s.getName(), s);
            List<FlakyCaseResult> cases = s.getCases();
            for (FlakyCaseResult cr : cases) {
                cr.setParentAction(this.parentAction);
                cr.setParentSuiteResult(s);
                cr.tally();
                String pkg = cr.getPackageName();
                String spkg = FlakyTestResult.safe((String)pkg);
                FlakyPackageResult pr = this.byPackage(spkg);
                if (pr == null) {
                    pr = new FlakyPackageResult(this, pkg);
                    this.byPackages.put(spkg, pr);
                }
                pr.add(cr);
            }
        }
        for (FlakyPackageResult pr : this.byPackages.values()) {
            pr.tally();
            this.skippedTests += pr.getSkipCount();
            this.failedTests.addAll(pr.getFailedTests());
            this.flakyTests.addAll(pr.getFlakyTests());
            this.passedTests.addAll(pr.getPassedTests());
            this.totalTests += pr.getTotalCount();
        }
    }

    public void freeze(AbstractTestResultAction parent, Run build) {
        this.parentAction = parent;
        this.owner = build;
        if (this.suitesByName == null) {
            this.suitesByName = new HashMap<String, FlakySuiteResult>();
            this.totalTests = 0;
            this.failedTests = new ArrayList<FlakyCaseResult>();
            this.flakyTests = new ArrayList<FlakyCaseResult>();
            this.passedTests = new ArrayList<FlakyCaseResult>();
            this.byPackages = new TreeMap<String, FlakyPackageResult>();
        }
        for (FlakySuiteResult s : this.suites) {
            if (!s.freeze(this)) continue;
            this.suitesByName.put(s.getName(), s);
            this.totalTests += s.getCases().size();
            for (FlakyCaseResult cr : s.getCases()) {
                if (cr.isSkipped()) {
                    ++this.skippedTests;
                } else if (!cr.isPassed()) {
                    this.failedTests.add(cr);
                } else if (cr.isFlaked()) {
                    this.flakyTests.add(cr);
                } else {
                    this.passedTests.add(cr);
                }
                String pkg = cr.getPackageName();
                String spkg = FlakyTestResult.safe((String)pkg);
                FlakyPackageResult pr = this.byPackage(spkg);
                if (pr == null) {
                    pr = new FlakyPackageResult(this, pkg);
                    this.byPackages.put(spkg, pr);
                }
                pr.add(cr);
            }
        }
        for (FlakyPackageResult pr : this.byPackages.values()) {
            pr.freeze();
        }
    }

    public Map<String, HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStatsWithRevision> getTestFlakyStatsMap() {
        int flakyRetry;
        HashMap<String, HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStatsWithRevision> testFlakyStatsWithRevisionMap = new HashMap<String, HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStatsWithRevision>();
        for (FlakyCaseResult passedTest : this.passedTests) {
            testFlakyStatsWithRevisionMap.put(passedTest.getFullDisplayName(), new HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStatsWithRevision(new HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStats(1, 0, 0), this.owner));
        }
        for (FlakyCaseResult failedTest : this.failedTests) {
            flakyRetry = failedTest.getFlakyRuns() == null ? 0 : failedTest.getFlakyRuns().size();
            testFlakyStatsWithRevisionMap.put(failedTest.getFullDisplayName(), new HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStatsWithRevision(new HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStats(0, 1 + flakyRetry, 0), this.owner));
        }
        for (FlakyCaseResult flakyTest : this.flakyTests) {
            flakyRetry = flakyTest.getFlakyRuns() == null ? 0 : flakyTest.getFlakyRuns().size();
            testFlakyStatsWithRevisionMap.put(flakyTest.getFullDisplayName(), new HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStatsWithRevision(new HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStats(1, flakyRetry, 0), this.owner));
        }
        return testFlakyStatsWithRevisionMap;
    }
}

