/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.junit;

import com.google.jenkins.flakyTestHandler.junit.FlakyCaseResult;
import com.google.jenkins.flakyTestHandler.junit.FlakyClassResult;
import com.google.jenkins.flakyTestHandler.junit.FlakyTestResult;
import hudson.model.AbstractBuild;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.TestNameTransformer;
import hudson.tasks.test.MetaTabulatedResult;
import hudson.tasks.test.TestResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public final class FlakyPackageResult
extends MetaTabulatedResult
implements Comparable<FlakyPackageResult> {
    private final String packageName;
    private transient String safeName;
    private final Map<String, FlakyClassResult> classes = new TreeMap<String, FlakyClassResult>();
    private int passCount;
    private int failCount;
    private int skipCount;
    private int flakeCount;
    private final FlakyTestResult parent;
    private float duration;

    FlakyPackageResult(FlakyTestResult parent, String packageName) {
        this.packageName = packageName;
        this.parent = parent;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.parent == null ? null : this.parent.getOwner();
    }

    public FlakyTestResult getParent() {
        return this.parent;
    }

    @Exported(visibility=999)
    public String getName() {
        return this.packageName;
    }

    public synchronized String getSafeName() {
        if (this.safeName != null) {
            return this.safeName;
        }
        List siblings = this.parent == null ? Collections.EMPTY_LIST : this.parent.getChildren();
        this.safeName = this.uniquifyName(siblings, FlakyPackageResult.safe((String)this.getName()));
        return this.safeName;
    }

    public TestResult findCorrespondingResult(String id) {
        FlakyClassResult child;
        int classNameStart;
        String myID = FlakyPackageResult.safe((String)this.getName());
        int base = id.indexOf(myID);
        String className = id;
        if (base > 0 && (classNameStart = base + myID.length() + 1) < id.length()) {
            className = id.substring(classNameStart);
        }
        String subId = null;
        int classNameEnd = className.indexOf(47);
        if (classNameEnd > 0) {
            subId = className.substring(classNameEnd + 1);
            if (subId.length() == 0) {
                subId = null;
            }
            className = className.substring(0, classNameEnd);
        }
        if ((child = this.getClassResult(className)) != null && subId != null) {
            return child.findCorrespondingResult(subId);
        }
        return child;
    }

    public String getTitle() {
        return Messages.PackageResult_getTitle((Object)this.getDisplayName());
    }

    public String getChildTitle() {
        return Messages.PackageResult_getChildTitle();
    }

    public float getDuration() {
        return this.duration;
    }

    @Exported
    public int getPassCount() {
        return this.passCount;
    }

    @Exported
    public int getFailCount() {
        return this.failCount;
    }

    @Exported
    public int getSkipCount() {
        return this.skipCount;
    }

    @Exported
    public int getFlakeCount() {
        return this.flakeCount;
    }

    public int getTotalCount() {
        return this.passCount + this.failCount + this.skipCount + this.flakeCount;
    }

    public Object getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        FlakyClassResult result = this.getClassResult(name);
        if (result != null) {
            return result;
        }
        return super.getDynamic(name, req, rsp);
    }

    public FlakyClassResult getClassResult(String name) {
        return this.classes.get(name);
    }

    @Exported(name="child")
    public Collection<FlakyClassResult> getChildren() {
        return this.classes.values();
    }

    public boolean hasChildren() {
        int totalTests = this.passCount + this.failCount + this.skipCount + this.flakeCount;
        return totalTests != 0;
    }

    public List<FlakyCaseResult> getFailedTests() {
        ArrayList<FlakyCaseResult> r = new ArrayList<FlakyCaseResult>();
        for (FlakyClassResult clr : this.classes.values()) {
            for (FlakyCaseResult cr : clr.getChildren()) {
                if (!cr.isFailed()) continue;
                r.add(cr);
            }
        }
        return r;
    }

    public Collection<? extends TestResult> getPassedTests() {
        ArrayList<FlakyCaseResult> r = new ArrayList<FlakyCaseResult>();
        for (FlakyClassResult clr : this.classes.values()) {
            for (FlakyCaseResult cr : clr.getChildren()) {
                if (!cr.isPassed() || cr.isFlaked()) continue;
                r.add(cr);
            }
        }
        return r;
    }

    public Collection<? extends TestResult> getSkippedTests() {
        ArrayList<FlakyCaseResult> r = new ArrayList<FlakyCaseResult>();
        for (FlakyClassResult clr : this.classes.values()) {
            for (FlakyCaseResult cr : clr.getChildren()) {
                if (!cr.isSkipped()) continue;
                r.add(cr);
            }
        }
        return r;
    }

    public List<FlakyCaseResult> getFlakyTests() {
        ArrayList<FlakyCaseResult> r = new ArrayList<FlakyCaseResult>();
        for (FlakyClassResult clr : this.classes.values()) {
            for (FlakyCaseResult cr : clr.getChildren()) {
                if (!cr.isFlaked()) continue;
                r.add(cr);
            }
        }
        return r;
    }

    public boolean isPassed() {
        return this.failCount == 0 && this.skipCount == 0;
    }

    void add(FlakyCaseResult r) {
        String n = r.getSimpleName();
        String sn = FlakyPackageResult.safe((String)n);
        FlakyClassResult c = this.getClassResult(sn);
        if (c == null) {
            c = new FlakyClassResult(this, n);
            this.classes.put(sn, c);
        }
        c.add(r);
        this.duration += r.getDuration();
    }

    public void tally() {
        this.passCount = 0;
        this.failCount = 0;
        this.skipCount = 0;
        this.flakeCount = 0;
        this.duration = 0.0f;
        for (FlakyClassResult cr : this.classes.values()) {
            cr.tally();
            this.passCount += cr.getPassCount();
            this.failCount += cr.getFailCount();
            this.skipCount += cr.getSkipCount();
            this.flakeCount += cr.getFlakeCount();
            this.duration += cr.getDuration();
        }
    }

    void freeze() {
        this.flakeCount = 0;
        this.skipCount = 0;
        this.failCount = 0;
        this.passCount = 0;
        for (FlakyClassResult cr : this.classes.values()) {
            cr.freeze();
            this.passCount += cr.getPassCount();
            this.failCount += cr.getFailCount();
            this.flakeCount += cr.getFlakeCount();
            this.skipCount += cr.getSkipCount();
        }
    }

    @Override
    public int compareTo(FlakyPackageResult that) {
        return this.packageName.compareTo(that.packageName);
    }

    public String getDisplayName() {
        return TestNameTransformer.getTransformedName((String)this.packageName);
    }
}

