/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesfoundtrigger;

import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.model.Cause;
import hudson.plugins.filesfoundtrigger.FilesFoundTriggerConfig;
import hudson.plugins.filesfoundtrigger.Messages;
import hudson.util.RobustReflectionConverter;
import java.util.Objects;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.export.Exported;

public final class FilesFoundTriggerCause
extends Cause {
    private final String node;
    private final String directory;
    private final String files;
    private final String ignoredFiles;
    private final String triggerNumber;

    FilesFoundTriggerCause(FilesFoundTriggerConfig config) {
        this.node = config.getNode();
        this.directory = config.getDirectory();
        this.files = config.getFiles();
        this.ignoredFiles = config.getIgnoredFiles();
        this.triggerNumber = config.getTriggerNumber();
    }

    private FilesFoundTriggerCause() {
        this.node = null;
        this.directory = "";
        this.files = "";
        this.ignoredFiles = "";
        this.triggerNumber = "";
    }

    @Exported(visibility=3)
    public String getNode() {
        return this.node == null ? "master" : this.node;
    }

    @Exported(visibility=3)
    public String getDirectory() {
        return this.directory;
    }

    @Exported(visibility=3)
    public String getFiles() {
        return this.files;
    }

    @Exported(visibility=3)
    public String getIgnoredFiles() {
        return this.ignoredFiles;
    }

    @Exported(visibility=3)
    public String getTriggerNumber() {
        return this.triggerNumber;
    }

    public String getShortDescription() {
        return this.ignoredFiles.length() == 0 ? Messages.Cause(this.getNode(), this.directory, this.files) : Messages.CauseWithIgnoredFiles(this.getNode(), this.directory, this.files, this.ignoredFiles);
    }

    public int hashCode() {
        return Objects.hash(this.node, this.directory, this.files, this.ignoredFiles, this.triggerNumber);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilesFoundTriggerCause) {
            FilesFoundTriggerCause other = (FilesFoundTriggerCause)((Object)obj);
            return Objects.equals(this.node, other.node) && Objects.equals(this.directory, other.directory) && Objects.equals(this.files, other.files) && Objects.equals(this.ignoredFiles, other.ignoredFiles) && Objects.equals(this.triggerNumber, other.triggerNumber);
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("node", (Object)this.getNode()).append("directory", (Object)this.directory).append("files", (Object)this.files).append("ignoredFiles", (Object)this.ignoredFiles).append("triggerNumber", (Object)this.triggerNumber).toString();
    }

    public static final class ConverterImpl
    extends RobustReflectionConverter {
        public ConverterImpl(Mapper mapper) {
            super(mapper, (ReflectionProvider)new PureJavaReflectionProvider());
        }
    }
}

