/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesfoundtrigger;

import antlr.ANTLRException;
import com.google.common.collect.ImmutableList;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.Extension;
import hudson.Util;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.plugins.filesfoundtrigger.FileSearch;
import hudson.plugins.filesfoundtrigger.FilesFoundTriggerCause;
import hudson.plugins.filesfoundtrigger.FilesFoundTriggerConfig;
import hudson.plugins.filesfoundtrigger.Messages;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.RobustReflectionConverter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;

public final class FilesFoundTrigger
extends Trigger<BuildableItem> {
    private static final Logger LOGGER = Logger.getLogger(FilesFoundTrigger.class.getName());
    private static final AtomicLong logCounter = new AtomicLong();
    private final String node;
    private final String directory;
    private final String files;
    private final String ignoredFiles;
    private final String triggerNumber;
    private final ArrayList<FilesFoundTriggerConfig> additionalConfigs;

    @DataBoundConstructor
    public FilesFoundTrigger(String spec, List<FilesFoundTriggerConfig> configs) throws ANTLRException {
        super(spec);
        ArrayList configsCopy = new ArrayList(Util.fixNull(configs));
        FilesFoundTriggerConfig firstConfig = configsCopy.isEmpty() ? new FilesFoundTriggerConfig(null, "", "", "", "1") : (FilesFoundTriggerConfig)((Object)configsCopy.remove(0));
        this.node = firstConfig.getNode();
        this.directory = firstConfig.getDirectory();
        this.files = firstConfig.getFiles();
        this.ignoredFiles = firstConfig.getIgnoredFiles();
        this.triggerNumber = firstConfig.getTriggerNumber();
        if (configsCopy.isEmpty()) {
            configsCopy = null;
        }
        this.additionalConfigs = configsCopy;
    }

    private FilesFoundTrigger() {
        this.node = null;
        this.directory = "";
        this.files = "";
        this.ignoredFiles = "";
        this.triggerNumber = "1";
        this.additionalConfigs = null;
    }

    public List<FilesFoundTriggerConfig> getConfigs() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new FilesFoundTriggerConfig(this.node, this.directory, this.files, this.ignoredFiles, this.triggerNumber));
        if (this.additionalConfigs != null) {
            builder.addAll(this.additionalConfigs);
        }
        return builder.build();
    }

    public void run() {
        long counter = logCounter.incrementAndGet();
        for (FilesFoundTriggerConfig config : this.getConfigs()) {
            FilesFoundTriggerConfig expandedConfig = config.expand();
            LOGGER.log(Level.FINE, "{0} - Searching for {1}", new Object[]{counter, expandedConfig});
            try {
                FileSearch.Result result = FileSearch.perform(expandedConfig);
                int triggerNumber = Integer.parseInt(expandedConfig.getTriggerNumber());
                boolean triggerBuild = result.files.size() >= triggerNumber;
                LOGGER.log(Level.FINE, "{0} - Result: {1} ({2})", new Object[]{counter, result.formValidation, triggerBuild ? "build triggered" : "build not triggered"});
                if (!triggerBuild) continue;
                ((BuildableItem)this.job).scheduleBuild(0, (Cause)new FilesFoundTriggerCause(expandedConfig));
                return;
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINE, "{0} - Result: Invalid trigger number (build not triggered)", counter);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, "{0} - Result: Thread interrupted (build not triggered)", counter);
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, MessageFormat.format("{0} - Searching for {1}. Result: {2}", new Object[]{counter, expandedConfig, e.getMessage()}), e);
            }
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("spec", (Object)this.spec).append("configs", this.getConfigs()).toString();
    }

    @Extension
    public static final class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof BuildableItem;
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }
    }

    public static final class ConverterImpl
    extends RobustReflectionConverter {
        public ConverterImpl(Mapper mapper) {
            super(mapper, (ReflectionProvider)new PureJavaReflectionProvider());
        }
    }
}

