/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesfoundtrigger;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Node;
import hudson.plugins.filesfoundtrigger.FilesFoundTriggerConfig;
import hudson.plugins.filesfoundtrigger.Messages;
import hudson.remoting.VirtualChannel;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.tools.ant.types.FileSet;

class FileSearch {
    static Result perform(FilesFoundTriggerConfig config) throws IOException, InterruptedException {
        String[] found;
        if (config.getDirectory().isEmpty()) {
            return new Result(FormValidation.error((String)Messages.DirectoryNotSpecified()));
        }
        if (config.getFiles().isEmpty()) {
            return new Result(FormValidation.error((String)Messages.FilesNotSpecified()));
        }
        String nodeName = config.getNode();
        if (nodeName == null) {
            found = FileSearch.scan(new File(config.getDirectory()), config.getFiles(), config.getIgnoredFiles());
        } else {
            Node slaveNode = null;
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins != null) {
                slaveNode = jenkins.getNode(nodeName);
            }
            if (slaveNode == null) {
                return new Result(FormValidation.error((String)Messages.NodeNotFound(nodeName)));
            }
            VirtualChannel channel = slaveNode.getChannel();
            if (channel == null) {
                return new Result(FormValidation.error((String)Messages.NodeOffline(nodeName)));
            }
            FilePath filePath = new FilePath(channel, config.getDirectory());
            found = (String[])filePath.act((FilePath.FileCallable)new FindFilesOnSlaveFileCallable(config));
        }
        if (found == null) {
            String userName = System.getProperty("user.name");
            return new Result(FormValidation.warning((String)Messages.DirectoryNotFound(userName)));
        }
        FormValidation formValidation = found.length == 0 ? FormValidation.ok((String)Messages.NoFilesFound()) : (found.length == 1 ? FormValidation.ok((String)Messages.SingleFileFound(found[0])) : FormValidation.ok((String)Messages.MultipleFilesFound(found.length)));
        return new Result(formValidation, found);
    }

    @CheckForNull
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    private static String[] scan(File f, String files, String ignoredFiles) {
        if (!f.isDirectory()) {
            return null;
        }
        FileSet fileSet = Util.createFileSet((File)f, (String)files, (String)ignoredFiles);
        fileSet.setDefaultexcludes(false);
        return fileSet.getDirectoryScanner().getIncludedFiles();
    }

    private FileSearch() {
    }

    private static class FindFilesOnSlaveFileCallable
    extends MasterToSlaveFileCallable<String[]> {
        private static final long serialVersionUID = 1L;
        private final String files;
        private final String ignoredFiles;

        FindFilesOnSlaveFileCallable(FilesFoundTriggerConfig config) {
            this.files = config.getFiles();
            this.ignoredFiles = config.getIgnoredFiles();
        }

        public String[] invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return FileSearch.scan(f, this.files, this.ignoredFiles);
        }
    }

    static class Result {
        final FormValidation formValidation;
        final List<String> files;

        private Result(FormValidation formValidation) {
            this.formValidation = formValidation;
            this.files = Collections.emptyList();
        }

        private Result(FormValidation formValidation, String[] files) {
            this.formValidation = formValidation;
            this.files = ImmutableList.copyOf((Object[])files);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("formValidation", (Object)this.formValidation).append("files", this.files).toString();
        }
    }
}

