/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.extremefeedback;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.extremefeedback.EventMessageHandler;
import org.jenkinsci.plugins.extremefeedback.Lamps;
import org.jenkinsci.plugins.extremefeedback.model.JenkinsEvent;
import org.jenkinsci.plugins.extremefeedback.model.Lamp;
import org.zeromq.ZMQ;

public class ZeroMQMessageHandler {
    private static final Multimap<String, String> messages = ArrayListMultimap.create();
    private static final ZeroMQMessageHandler instance = new ZeroMQMessageHandler();
    private boolean isStarted = false;
    private static final char SEPARATOR = '\u0007';
    private static final Logger LOGGER = Logger.getLogger(ZeroMQMessageHandler.class.getName());

    private ZeroMQMessageHandler() {
    }

    public static ZeroMQMessageHandler getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.isStarted) {
            LOGGER.info("ZeroMQ message handler started");
            this.isStarted = true;
            final Lamps plugin = Lamps.getInstance();
            plugin.getEventBus().register((Object)this);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            try {
                executorService.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ZMQ.Context context = ZMQ.context((int)1);
                        ZMQ.Socket responder = context.socket(4);
                        responder.bind("tcp://*:61616");
                        while (!Thread.currentThread().isInterrupted()) {
                            String message;
                            String request = responder.recvStr().trim();
                            Multimap multimap = messages;
                            synchronized (multimap) {
                                ArrayList converted = Lists.newArrayList();
                                for (String req : messages.get((Object)request)) {
                                    converted.add(EventMessageHandler.convertJson(JSONObject.fromObject((Object)req)));
                                }
                                messages.removeAll((Object)request);
                                message = Joiner.on((char)'\u0007').join((Iterable)converted);
                            }
                            responder.send(message);
                            if (!message.isEmpty() || plugin.getLamps().contains(new Lamp(request))) continue;
                            LOGGER.info("Creating lamp with Mac address " + request);
                            plugin.addLampByMacAddress(request);
                        }
                    }
                });
            }
            finally {
                executorService.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void listenEvents(JenkinsEvent event) {
        JSONObject jsonObject;
        String message;
        String json = event.getJson();
        if (json.endsWith(",")) {
            json = json.substring(0, json.length() - 1);
        }
        if (!(message = EventMessageHandler.convertJson(jsonObject = JSONObject.fromObject((Object)json))).isEmpty()) {
            LOGGER.info("Event received for " + jsonObject.getString("macAddress"));
            Multimap<String, String> multimap = messages;
            synchronized (multimap) {
                messages.put((Object)jsonObject.getString("macAddress"), (Object)json);
            }
        }
    }
}

