/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.extremefeedback;

import com.google.common.eventbus.Subscribe;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.extremefeedback.Lamps;
import org.jenkinsci.plugins.extremefeedback.model.JenkinsEvent;
import org.jenkinsci.plugins.extremefeedback.model.Lamp;
import org.jenkinsci.plugins.extremefeedback.model.States;
import org.jenkinsci.plugins.extremefeedback.model.UdpMessageSender;
import org.jenkinsci.plugins.extremefeedback.model.XfEventMessage;

public class EventMessageHandler {
    private static final int PORT = 39418;
    private static final Logger LOGGER = Logger.getLogger("jenkins.plugins.extremefeedback");
    private boolean isStarted = false;

    private EventMessageHandler() {
    }

    public void start() {
        if (!this.isStarted) {
            this.isStarted = true;
            Lamps plugin = Lamps.getInstance();
            plugin.getEventBus().register((Object)this);
        }
    }

    public static EventMessageHandler getInstance() {
        return EventMessageObject.INSTANCE;
    }

    @Subscribe
    public void listenEvents(JenkinsEvent event) {
        this.handleEvent(event.getJson());
    }

    private void handleEvent(String event) {
        JSONObject json;
        String message;
        if (event.endsWith(",")) {
            event = event.substring(0, event.length() - 1);
        }
        if (!(message = EventMessageHandler.convertJson(json = JSONObject.fromObject((Object)event))).isEmpty()) {
            this.sendMessage(json.getString("macAddress"), message);
        }
    }

    public static String convertJson(JSONObject json) {
        String type = json.getString("type");
        String name = json.getString("name");
        String message = "";
        if (type.equals(XfEventMessage.Type.buzzer.toString())) {
            message = EventMessageHandler.buildAlarmNotification(name);
        } else if (type.equals(XfEventMessage.Type.color.toString())) {
            message = EventMessageHandler.buildColorNotification(json.getString("color"), json.getString("flashing"), name);
        } else if (type.equals(XfEventMessage.Type.soundalarm.toString())) {
            message = EventMessageHandler.buildSfxNotification(json.getString("color"), name);
        } else if (type.equals(XfEventMessage.Type.lcdtext.toString())) {
            message = EventMessageHandler.buildLCDNotification(json.getString("text"), name);
        }
        return message;
    }

    private static String buildColorNotification(String color, String flashing, String name) {
        JSONObject gitgear = new JSONObject();
        gitgear.put("Lamp", (Object)name);
        gitgear.put("color", (Object)color);
        gitgear.put("action", (Object)(flashing.equals("true") ? States.Action.FLASHING : States.Action.SOLID));
        return gitgear.toString();
    }

    private static String buildAlarmNotification(String name) {
        JSONObject gitgear = new JSONObject();
        gitgear.put("Lamp", (Object)name);
        gitgear.put("siren", (Object)"NA");
        gitgear.put("action", (Object)"ON");
        return gitgear.toString();
    }

    private static String buildSfxNotification(String color, String name) {
        JSONObject gitgear = new JSONObject();
        gitgear.put("Lamp", (Object)name);
        gitgear.put("soundeffect", (Object)"NA");
        gitgear.put("color", (Object)color);
        return gitgear.toString();
    }

    private static String buildLCDNotification(String lcdText, String name) {
        JSONObject displayText = new JSONObject();
        displayText.put("Lamp", (Object)name);
        displayText.put("lcd_text", (Object)lcdText);
        return displayText.toString();
    }

    private void sendMessage(String macAddress, String msg) {
        byte[] data = msg.getBytes();
        Lamps plugin = Lamps.getInstance();
        Lamp lamp = plugin.getLampByMacAddress(macAddress);
        if (!lamp.isInactive()) {
            String ipAddress = lamp.getIpAddress();
            LOGGER.info("[XFD] sending message to: " + ipAddress + " message: " + msg);
            UdpMessageSender.send(ipAddress, 39418, data);
        }
    }

    private static class EventMessageObject {
        public static final EventMessageHandler INSTANCE = new EventMessageHandler();

        private EventMessageObject() {
        }
    }
}

