/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.extremefeedback;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.extremefeedback.Lamps;
import org.jenkinsci.plugins.extremefeedback.model.JenkinsEvent;
import org.jenkinsci.plugins.extremefeedback.model.Lamp;
import org.jenkinsci.plugins.extremefeedback.model.States;
import org.jenkinsci.plugins.extremefeedback.model.UdpMessageSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class XfRunListener
extends RunListener<AbstractBuild> {
    private static final Logger LOGGER = Logger.getLogger("jenkins.plugins.extremefeedback");

    public void onCompleted(AbstractBuild run, TaskListener listener) {
        Lamps plugin = (Lamps)Jenkins.getInstance().getPlugin(Lamps.class);
        Set<String> jobs = plugin.getJobs();
        if (jobs.contains(run.getParent().getName())) {
            Result result = run.getResult();
            Set<Lamp> activeLamps = plugin.getLampsContainingJob(run.getParent().getName());
            for (Lamp lamp : activeLamps) {
                String jsonColor = this.buildColorJson(States.resultColorMap.get(result).toString(), lamp, false);
                plugin.getEventBus().post((Object)new JenkinsEvent(jsonColor));
                this.sendColorNotification(lamp.getIpAddress(), States.resultColorMap.get(result), States.Action.SOLID);
                if (lamp.isSfx()) {
                    try {
                        Thread.sleep(1000L);
                        String jsonSfx = this.buildSfxJson(States.resultColorMap.get(result).toString(), lamp);
                        plugin.getEventBus().post((Object)new JenkinsEvent(jsonSfx));
                        this.sendSfxNotification(lamp.getIpAddress(), States.resultColorMap.get(result));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (!States.resultColorMap.get(result).equals((Object)States.Color.RED) || !lamp.isNoisy()) continue;
                try {
                    Thread.sleep(1000L);
                    String jsonBuzzer = this.buildBuzzerJson(lamp);
                    plugin.getEventBus().post((Object)new JenkinsEvent(jsonBuzzer));
                    this.sendAlarmNotification(lamp.getIpAddress());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void onStarted(AbstractBuild run, TaskListener listener) {
        block4: {
            Lamps plugin = (Lamps)Jenkins.getInstance().getPlugin(Lamps.class);
            Set<String> jobs = plugin.getJobs();
            if (!jobs.contains(run.getParent().getName())) break block4;
            Set<Lamp> activeLamps = plugin.getLampsContainingJob(run.getParent().getName());
            Run previousBuild = run.getPreviousBuild();
            if (previousBuild == null) {
                for (Lamp lamp : activeLamps) {
                    String jsonColor = this.buildColorJson(States.Color.GREEN.toString(), lamp, false);
                    plugin.getEventBus().post((Object)new JenkinsEvent(jsonColor));
                    this.sendColorNotification(lamp.getIpAddress(), States.Color.GREEN, States.Action.SOLID);
                }
            } else {
                for (Lamp lamp : activeLamps) {
                    String jsonColor = this.buildColorJson(States.resultColorMap.get(previousBuild.getResult()).toString(), lamp, true);
                    plugin.getEventBus().post((Object)new JenkinsEvent(jsonColor));
                    this.sendColorNotification(lamp.getIpAddress(), States.resultColorMap.get(previousBuild.getResult()), States.Action.FLASHING);
                }
            }
        }
    }

    private String buildBuzzerJson(Lamp lamp) {
        JSONObject jsonBuzzer = new JSONObject();
        jsonBuzzer.accumulate("macAddress", (Object)lamp.getMacAddress());
        jsonBuzzer.accumulate("type", (Object)"buzzer");
        return jsonBuzzer.toString() + ",";
    }

    private String buildColorJson(String color, Lamp lamp, boolean flashing) {
        JSONObject jsonColor = new JSONObject();
        jsonColor.accumulate("macAddress", (Object)lamp.getMacAddress());
        jsonColor.accumulate("type", (Object)"color");
        jsonColor.accumulate("color", (Object)color);
        jsonColor.accumulate("flashing", flashing);
        return jsonColor.toString() + ",";
    }

    private String buildSfxJson(String color, Lamp lamp) {
        JSONObject jsonSfx = new JSONObject();
        jsonSfx.accumulate("macAddress", (Object)lamp.getMacAddress());
        jsonSfx.accumulate("type", (Object)"soundalarm");
        jsonSfx.accumulate("color", (Object)color);
        return jsonSfx.toString() + ",";
    }

    private void sendColorNotification(String ipAddress, States.Color color, States.Action action) {
        JSONObject gitgear = new JSONObject();
        gitgear.put("color", (Object)color);
        gitgear.put("action", (Object)action);
        byte[] data = gitgear.toString(2).getBytes();
        int port = 39418;
        UdpMessageSender.send(ipAddress, port, data);
    }

    private void sendAlarmNotification(String ipAddress) {
        JSONObject gitgear = new JSONObject();
        gitgear.put("siren", (Object)"NA");
        gitgear.put("action", (Object)"ON");
        byte[] data = gitgear.toString(2).getBytes();
        int port = 39418;
        UdpMessageSender.send(ipAddress, port, data);
    }

    private void sendSfxNotification(String ipAddress, States.Color color) {
        JSONObject gitgear = new JSONObject();
        gitgear.put("soundeffect", (Object)"NA");
        gitgear.put("color", (Object)color);
        byte[] data = gitgear.toString(2).getBytes();
        int port = 39418;
        UdpMessageSender.send(ipAddress, port, data);
    }
}

