/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.extremefeedback;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.model.ManagementLink;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.extremefeedback.Lamps;
import org.jenkinsci.plugins.extremefeedback.model.Lamp;
import org.kohsuke.stapler.bind.JavaScriptMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class XfManagementLink
extends ManagementLink {
    private static final Logger LOGGER = Logger.getLogger("jenkins.plugins.extremefeedback");
    private final Jenkins jenkins = Jenkins.getInstance();

    public String getIconFileName() {
        return "/plugin/extreme-feedback/traffic-light.png";
    }

    public String getDisplayName() {
        return "Extreme Feedback";
    }

    public String getDescription() {
        return "Manage the <a href=\"http://www.gitgear.com/XFD\">gitgear.com</a> Extreme Feedback Lamps.";
    }

    public String getUrlName() {
        return "extreme-feedback";
    }

    @JavaScriptMethod
    public Set<Lamp> findLamps() {
        Lamps plugin = (Lamps)this.jenkins.getPlugin(Lamps.class);
        return plugin.findLamps();
    }

    @JavaScriptMethod
    public boolean updateLamp(Lamp lamp) {
        Lamps plugin = (Lamps)this.jenkins.getPlugin(Lamps.class);
        Map<String, Lamp> lamps = plugin.getLampsAsMap();
        lamps.put(lamp.getMacAddress(), lamp);
        plugin.setLamps(Sets.newHashSet(lamps.values()));
        try {
            plugin.save();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @JavaScriptMethod
    public boolean setLampAlarm(String macAddress, boolean status) {
        Lamps plugin = (Lamps)this.jenkins.getPlugin(Lamps.class);
        for (Lamp lamp : plugin.getLamps()) {
            if (!lamp.getMacAddress().equals(macAddress)) continue;
            lamp.setNoisy(status);
            try {
                plugin.save();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    @JavaScriptMethod
    public Set<Lamp> addLampByIpAddress(String ipAddress) {
        ImmutableSet after;
        Lamps plugin = (Lamps)this.jenkins.getPlugin(Lamps.class);
        ImmutableSet before = ImmutableSet.copyOf(plugin.getLamps());
        if (before != (after = ImmutableSet.copyOf(plugin.addLampByIp(ipAddress)))) {
            return after;
        }
        return null;
    }

    @JavaScriptMethod
    public boolean changeLampName(String macAddress, String name) {
        Lamps plugin = (Lamps)this.jenkins.getPlugin(Lamps.class);
        Set<Lamp> lamps = plugin.getLamps();
        LOGGER.log(Level.INFO, "MAC to find: " + macAddress);
        for (Lamp lamp : lamps) {
            LOGGER.log(Level.INFO, "Checking: " + lamp.getMacAddress());
            if (!lamp.getMacAddress().equals(macAddress)) continue;
            lamp.setName(name);
            return true;
        }
        LOGGER.log(Level.WARNING, "Could not find lamp: " + macAddress + ' ' + name);
        return false;
    }

    @JavaScriptMethod
    public Set<Lamp> getLamps() {
        Lamps plugin = (Lamps)this.jenkins.getPlugin(Lamps.class);
        return plugin.getLamps();
    }

    @JavaScriptMethod
    public Lamp getLamp(String macAddress) {
        Lamps plugin = (Lamps)this.jenkins.getPlugin(Lamps.class);
        for (Lamp lamp : plugin.getLamps()) {
            if (!lamp.getMacAddress().equals(macAddress)) continue;
            return lamp;
        }
        return null;
    }

    @JavaScriptMethod
    public Collection<String> getProjects() {
        return this.jenkins.getJobNames();
    }

    @JavaScriptMethod
    public Collection<Lamp> addProjectToLamp(String projectName, String macAddress) {
        Lamps plugin = (Lamps)this.jenkins.getPlugin(Lamps.class);
        if (this.jenkins.getJobNames().contains(projectName)) {
            Map<String, Lamp> lamps = plugin.getLampsAsMap();
            Lamp lamp = lamps.get(macAddress);
            lamp.addJob(projectName);
            plugin.setLamps(Sets.newHashSet(lamps.values()));
            try {
                plugin.save();
            }
            catch (IOException e) {
                LOGGER.severe("Could not save the Lamps plugin");
                return new HashSet<Lamp>();
            }
        }
        return plugin.getLamps();
    }

    @JavaScriptMethod
    public Collection<Lamp> removeProjectFromLamp(String projectName, String macAddress) {
        Lamps plugin = (Lamps)this.jenkins.getPlugin(Lamps.class);
        Map<String, Lamp> lamps = plugin.getLampsAsMap();
        Lamp lamp = lamps.get(macAddress);
        lamp.removeJob(projectName);
        plugin.setLamps(Sets.newHashSet(lamps.values()));
        try {
            plugin.save();
        }
        catch (IOException e) {
            LOGGER.severe("Could not save the Lamps plugin");
            return new HashSet<Lamp>();
        }
        return plugin.getLamps();
    }

    @JavaScriptMethod
    public Collection<Lamp> removeLamp(String macAddress) {
        Lamps plugin = (Lamps)this.jenkins.getPlugin(Lamps.class);
        Map<String, Lamp> lamps = plugin.getLampsAsMap();
        lamps.remove(macAddress);
        plugin.setLamps(Sets.newHashSet(lamps.values()));
        try {
            plugin.save();
        }
        catch (IOException e) {
            LOGGER.severe("Could not save the Lamps plugin");
        }
        return plugin.getLamps();
    }
}

