/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.extremefeedback;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import hudson.Plugin;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.extremefeedback.model.Lamp;
import org.jenkinsci.plugins.extremefeedback.model.LampConfirmCallable;
import org.jenkinsci.plugins.extremefeedback.model.LampFinderCallable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lamps
extends Plugin {
    private Set<Lamp> lamps = new ConcurrentSkipListSet<Lamp>();
    private static final transient Logger LOGGER = Logger.getLogger("jenkins.plugins.extremefeedback");
    private transient EventBus eventBus = new EventBus("extreme-feedback");

    public void start() throws Exception {
        this.load();
    }

    public Set<Lamp> findLamps() {
        ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
        ListenableFuture listenableFuture = service.submit((Callable)new LampFinderCallable());
        Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<TreeSet<Lamp>>(){

            public void onSuccess(TreeSet<Lamp> foundLamps) {
                if (Lamps.this.lamps.isEmpty()) {
                    Lamps.this.lamps = foundLamps;
                } else {
                    Map<String, Lamp> currentLamps = Lamps.this.getLampsAsMap();
                    for (Lamp foundLamp : foundLamps) {
                        if (!currentLamps.containsKey(foundLamp.getMacAddress())) continue;
                        Lamp lamp = currentLamps.get(foundLamp.getMacAddress());
                        lamp.setInactive(false);
                    }
                    Lamps.this.lamps = Sets.newTreeSet(currentLamps.values());
                    ImmutableSet lampsCopy = ImmutableSet.copyOf((Collection)Lamps.this.lamps);
                    Sets.SetView newLamps = Sets.difference(foundLamps, (Set)lampsCopy);
                    Lamps.this.lamps.addAll(newLamps);
                    LOGGER.info("Lamps added: " + Joiner.on((String)", ").join((Iterable)newLamps));
                    lampsCopy = ImmutableSet.copyOf((Collection)Lamps.this.lamps);
                    Sets.SetView obsoleteLamps = Sets.difference((Set)lampsCopy, foundLamps);
                    Map<String, Lamp> lampsAsMap = Lamps.this.getLampsAsMap();
                    for (Lamp obsoleteLamp : obsoleteLamps) {
                        Lamp lamp = lampsAsMap.get(obsoleteLamp.getMacAddress());
                        lamp.setInactive(true);
                    }
                    Lamps.this.lamps = Sets.newTreeSet(lampsAsMap.values());
                    LOGGER.info("Lamps removed: " + Joiner.on((String)", ").join((Iterable)obsoleteLamps));
                    lampsCopy = ImmutableSet.copyOf((Collection)Lamps.this.lamps);
                    Sets.SetView remainingLamps = Sets.intersection(foundLamps, (Set)lampsCopy);
                    Set product = Sets.cartesianProduct((Set[])new Set[]{remainingLamps, lampsCopy});
                    for (List lampList : product) {
                        Lamp oldLamp;
                        Lamp newLamp = (Lamp)lampList.get(0);
                        if (!newLamp.equals(oldLamp = (Lamp)lampList.get(1)) || newLamp.getIpAddress().equals(oldLamp.getIpAddress())) continue;
                        oldLamp.setIpAddress(newLamp.getIpAddress());
                        LOGGER.info("Lamp updated: " + oldLamp);
                    }
                    try {
                        ((Lamps)Jenkins.getInstance().getPlugin(Lamps.class)).save();
                    }
                    catch (IOException e) {
                        LOGGER.severe(e.getMessage());
                    }
                }
            }

            public void onFailure(Throwable throwable) {
                LOGGER.severe(Throwables.getStackTraceAsString((Throwable)throwable));
            }
        });
        while (!listenableFuture.isDone()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.warning(e.getMessage());
            }
        }
        return this.lamps;
    }

    public Set<Lamp> getLamps() {
        return this.lamps;
    }

    public void setLamps(Set<Lamp> lamps) {
        this.lamps = lamps;
    }

    public Set<String> getJobs() {
        HashSet jobs = Sets.newHashSet();
        for (Lamp lamp : this.lamps) {
            jobs.addAll(lamp.getJobs());
        }
        return jobs;
    }

    public Set<Lamp> getLampsContainingJob(String jobName) {
        HashSet activeLamps = Sets.newHashSet();
        for (Lamp lamp : this.lamps) {
            if (!lamp.getJobs().contains(jobName)) continue;
            activeLamps.add(lamp);
        }
        return activeLamps;
    }

    public Set<Lamp> addLampByIp(final String ipAddress) {
        ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
        ListenableFuture listenableFuture = service.submit((Callable)new LampConfirmCallable(ipAddress));
        Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<String>(){

            public void onSuccess(String macAddress) {
                Lamp lamp = new Lamp(macAddress, ipAddress);
                if (Lamps.this.lamps.contains(lamp)) {
                    Lamps.this.lamps.remove(lamp);
                }
                Lamps.this.lamps.add(lamp);
            }

            public void onFailure(Throwable throwable) {
                LOGGER.warning(throwable.getMessage());
            }
        });
        while (!listenableFuture.isDone()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.warning(e.getMessage());
            }
        }
        return this.lamps;
    }

    public Map<String, Lamp> getLampsAsMap() {
        HashMap result = Maps.newHashMap();
        for (Lamp lamp : this.lamps) {
            result.put(lamp.getMacAddress(), lamp);
        }
        return result;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }
}

