/*
 * Decompiled with CFR 0.152.
 */
package com.cwctravel.hudson.plugins.extended_choice_parameter;

import com.cwctravel.hudson.plugins.extended_choice_parameter.ExtendedChoiceParameterValue;
import com.cwctravel.hudson.plugins.extended_choice_parameter.Messages;
import com.cwctravel.hudson.plugins.extended_choice_parameter.ParameterDefinitionInfo;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.Binding;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.AbstractProject;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import hudson.util.FormValidation;
import hudson.util.LogTaskListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedClasspathException;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedUsageException;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class ExtendedChoiceParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = -2946187268529865645L;
    private static final Logger LOGGER = Logger.getLogger(ExtendedChoiceParameterDefinition.class.getName());
    private static final String ATTR_REQUEST_GROOVY_BINDING = "com.cwctravel.hudson.plugins.extended_choice_parameter.groovyBinding";
    public static final String PARAMETER_TYPE_SINGLE_SELECT = "PT_SINGLE_SELECT";
    public static final String PARAMETER_TYPE_MULTI_SELECT = "PT_MULTI_SELECT";
    public static final String PARAMETER_TYPE_CHECK_BOX = "PT_CHECKBOX";
    public static final String PARAMETER_TYPE_RADIO = "PT_RADIO";
    public static final String PARAMETER_TYPE_TEXT_BOX = "PT_TEXTBOX";
    public static final String PARAMETER_TYPE_HIDDEN = "PT_HIDDEN";
    public static final String PARAMETER_TYPE_MULTI_LEVEL_SINGLE_SELECT = "PT_MULTI_LEVEL_SINGLE_SELECT";
    public static final String PARAMETER_TYPE_MULTI_LEVEL_MULTI_SELECT = "PT_MULTI_LEVEL_MULTI_SELECT";
    public static final String PARAMETER_TYPE_JSON = "PT_JSON";
    private transient GroovyShell groovyShell;
    private boolean quoteValue;
    private boolean saveJSONParameterToFile;
    private int visibleItemCount;
    private String type;
    private String value;
    private String propertyFile;
    private String groovyScript;
    private String groovyScriptFile;
    private String bindings;
    private String groovyClasspath;
    private String propertyKey;
    private String defaultValue;
    private String defaultPropertyFile;
    private String defaultGroovyScript;
    private String defaultGroovyScriptFile;
    private String defaultBindings;
    private String defaultGroovyClasspath;
    private String defaultPropertyKey;
    private String multiSelectDelimiter;
    private String descriptionPropertyValue;
    private String descriptionPropertyFile;
    private String descriptionGroovyScript;
    private String descriptionGroovyScriptFile;
    private String descriptionBindings;
    private String descriptionGroovyClasspath;
    private String descriptionPropertyKey;
    private String javascriptFile;
    private String javascript;
    private String projectName;

    @DataBoundConstructor
    public ExtendedChoiceParameterDefinition(String name, String type, String value, String projectName, String propertyFile, String groovyScript, String groovyScriptFile, String bindings, String groovyClasspath, String propertyKey, String defaultValue, String defaultPropertyFile, String defaultGroovyScript, String defaultGroovyScriptFile, String defaultBindings, String defaultGroovyClasspath, String defaultPropertyKey, String descriptionPropertyValue, String descriptionPropertyFile, String descriptionGroovyScript, String descriptionGroovyScriptFile, String descriptionBindings, String descriptionGroovyClasspath, String descriptionPropertyKey, String javascriptFile, String javascript, boolean saveJSONParameterToFile, boolean quoteValue, int visibleItemCount, String description, String multiSelectDelimiter) {
        super(name, description);
        this.type = type;
        this.value = value;
        this.projectName = projectName;
        this.propertyFile = propertyFile;
        this.propertyKey = propertyKey;
        this.groovyScript = groovyScript;
        this.groovyScriptFile = groovyScriptFile;
        this.bindings = bindings;
        this.groovyClasspath = groovyClasspath;
        this.defaultValue = defaultValue;
        this.defaultPropertyFile = defaultPropertyFile;
        this.defaultPropertyKey = defaultPropertyKey;
        this.defaultGroovyScript = defaultGroovyScript;
        this.defaultGroovyScriptFile = defaultGroovyScriptFile;
        this.defaultBindings = defaultBindings;
        this.defaultGroovyClasspath = defaultGroovyClasspath;
        this.descriptionPropertyValue = descriptionPropertyValue;
        this.descriptionPropertyFile = descriptionPropertyFile;
        this.descriptionPropertyKey = descriptionPropertyKey;
        this.descriptionGroovyScript = descriptionGroovyScript;
        this.descriptionGroovyScriptFile = descriptionGroovyScriptFile;
        this.descriptionBindings = descriptionBindings;
        this.descriptionGroovyClasspath = descriptionGroovyClasspath;
        this.javascriptFile = javascriptFile;
        this.javascript = javascript;
        this.saveJSONParameterToFile = saveJSONParameterToFile;
        this.quoteValue = quoteValue;
        if (visibleItemCount == 0) {
            visibleItemCount = 5;
        }
        this.visibleItemCount = visibleItemCount;
        if (multiSelectDelimiter == null || "".equals(multiSelectDelimiter)) {
            multiSelectDelimiter = ",";
        }
        this.multiSelectDelimiter = multiSelectDelimiter;
    }

    private Map<String, Boolean> computeDefaultValueMap() {
        HashMap<String, Boolean> defaultValueMap = null;
        String effectiveDefaultValue = this.computeEffectiveDefaultValue();
        if (!StringUtils.isBlank((String)effectiveDefaultValue)) {
            String[] defaultValues;
            defaultValueMap = new HashMap<String, Boolean>();
            for (String value : defaultValues = StringUtils.split((String)effectiveDefaultValue, (char)',')) {
                defaultValueMap.put(StringUtils.trim((String)value), true);
            }
        }
        return defaultValueMap;
    }

    private Map<String, String> computeDescriptionPropertyValueMap(String effectiveValue) {
        HashMap<String, String> descriptionPropertyValueMap = null;
        if (effectiveValue != null) {
            String[] values = effectiveValue.split(",");
            String effectiveDescriptionPropertyValue = this.computeEffectiveDescriptionPropertyValue();
            if (!StringUtils.isBlank((String)effectiveDescriptionPropertyValue)) {
                descriptionPropertyValueMap = new HashMap<String, String>();
                String[] descriptionPropertyValues = StringUtils.split((String)effectiveDescriptionPropertyValue, (char)',');
                for (int i = 0; i < values.length && i < descriptionPropertyValues.length; ++i) {
                    descriptionPropertyValueMap.put(StringUtils.trim((String)values[i]), StringUtils.trim((String)descriptionPropertyValues[i]));
                }
            }
        }
        return descriptionPropertyValueMap;
    }

    public ParameterValue createValue(StaplerRequest request) {
        String[] requestValues = request.getParameterValues(this.getName());
        return this.createValue(requestValues);
    }

    public ParameterValue createValue(CLICommand command, String value) {
        String[] requestValues = value != null ? value.split(",") : null;
        return this.createValue(requestValues);
    }

    ParameterValue createValue(String[] requestValues) {
        if (requestValues == null || requestValues.length == 0) {
            return this.getDefaultParameterValue();
        }
        if (PARAMETER_TYPE_TEXT_BOX.equals(this.type) || PARAMETER_TYPE_HIDDEN.equals(this.type)) {
            return new ExtendedChoiceParameterValue(this.getName(), requestValues[0]);
        }
        String valueStr = this.computeEffectiveValue();
        if (valueStr != null) {
            ArrayList<String> result = new ArrayList<String>();
            String[] values = valueStr.trim().split("\\s*,\\s*");
            HashSet<String> valueSet = new HashSet<String>(Arrays.asList(values));
            for (String requestValue : requestValues) {
                if (!valueSet.contains(requestValue.trim())) continue;
                result.add(requestValue.trim());
            }
            return new ExtendedChoiceParameterValue(this.getName(), StringUtils.join(result, (String)this.getMultiSelectDelimiter()));
        }
        return null;
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject jO) {
        Object value = jO.get("value");
        Object strValue = "";
        if (value instanceof String) {
            strValue = (String)value;
        } else if (value instanceof JSONArray) {
            StringBuilder sB = new StringBuilder();
            JSONArray jsonValues = (JSONArray)value;
            if (this.isMultiLevelParameterType()) {
                int valuesBetweenLevels = this.value.split(",").length;
                Iterator it = jsonValues.iterator();
                int i = 1;
                while (it.hasNext()) {
                    String nextValue = it.next().toString();
                    if (i % valuesBetweenLevels == 0) {
                        if (sB.length() > 0) {
                            sB.append(this.getMultiSelectDelimiter());
                        }
                        sB.append(nextValue);
                    }
                    ++i;
                }
                strValue = sB.toString();
            } else {
                strValue = StringUtils.join((Iterator)jsonValues.iterator(), (String)this.getMultiSelectDelimiter());
            }
        }
        if (this.quoteValue) {
            strValue = "\"" + (String)strValue + "\"";
        }
        return new ExtendedChoiceParameterValue(this.getName(), (String)strValue);
    }

    private boolean isMultiLevelParameterType() {
        return this.type.equals(PARAMETER_TYPE_MULTI_LEVEL_SINGLE_SELECT) || this.type.equals(PARAMETER_TYPE_MULTI_LEVEL_MULTI_SELECT);
    }

    private boolean isBasicParameterType() {
        return this.type.equals(PARAMETER_TYPE_SINGLE_SELECT) || this.type.equals(PARAMETER_TYPE_MULTI_SELECT) || this.type.equals(PARAMETER_TYPE_CHECK_BOX) || this.type.equals(PARAMETER_TYPE_RADIO) || this.type.equals(PARAMETER_TYPE_TEXT_BOX) || this.type.equals(PARAMETER_TYPE_HIDDEN);
    }

    public ParameterValue getDefaultParameterValue() {
        Object defaultValue;
        if (this.isBasicParameterType() && !StringUtils.isBlank((String)(defaultValue = this.computeEffectiveDefaultValue()))) {
            if (this.quoteValue) {
                defaultValue = "\"" + (String)defaultValue + "\"";
            }
            return new ExtendedChoiceParameterValue(this.getName(), (String)defaultValue);
        }
        return super.getDefaultParameterValue();
    }

    private String computeValue(String value, String propertyFilePath, String propertyKey, String groovyScript, String groovyScriptFile, String bindings, String groovyClasspath, boolean isSingleValued) {
        if (!StringUtils.isBlank((String)propertyFilePath) && !StringUtils.isBlank((String)propertyKey)) {
            try {
                String resolvedPropertyFilePath = this.expandVariables(propertyFilePath);
                File propertyFile = new File(resolvedPropertyFilePath);
                Project project = new Project();
                Property property = new Property();
                property.setProject(project);
                property.setFile(propertyFile);
                property.execute();
                return project.getProperty(propertyKey);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            if (!StringUtils.isBlank((String)groovyScript)) {
                return this.executeGroovyScriptAndProcessGroovyValue(groovyScript, bindings, groovyClasspath, isSingleValued);
            }
            if (!StringUtils.isBlank((String)groovyScriptFile)) {
                return this.executeGroovyScriptFile(groovyScriptFile, bindings, groovyClasspath, isSingleValued);
            }
            if (!StringUtils.isBlank((String)value)) {
                return value;
            }
        }
        return null;
    }

    private String executeGroovyScriptFile(String groovyScriptFile, String bindings, String groovyClasspath, boolean isSingleValued) {
        String result = null;
        try {
            String groovyScript = this.expandVariablesLoadFile(groovyScriptFile);
            result = this.executeGroovyScriptAndProcessGroovyValue(groovyScript, bindings, groovyClasspath, isSingleValued);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return result;
    }

    private String executeGroovyScriptAndProcessGroovyValue(String groovyScript, String bindings, String groovyClasspath, boolean isSingleValued) {
        String result = null;
        try {
            Object groovyValue = this.executeGroovyScript(groovyScript, bindings, groovyClasspath);
            result = this.processGroovyValue(isSingleValued, groovyValue);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return result;
    }

    private Object executeGroovyScript(String groovyScript, String bindings, String groovyClasspath) throws URISyntaxException, IOException {
        Object groovyValue = null;
        if (this.checkScriptApproval(groovyScript, groovyClasspath, false)) {
            GroovyShell groovyShell = this.getGroovyShell(groovyClasspath);
            GroovyCodeSource codeSource = new GroovyCodeSource(groovyScript, this.computeMD5Hash(groovyScript), "/groovy/shell");
            groovyShell.getClassLoader().parseClass(codeSource, true);
            this.setBindings(groovyShell, bindings);
            groovyValue = groovyShell.evaluate(codeSource);
        }
        return groovyValue;
    }

    private String computeMD5Hash(String str) {
        Object result = str;
        if (str != null) {
            result = DigestUtils.md5Hex((String)str);
        }
        result = "_" + (String)result;
        return result;
    }

    private Binding getGroovyBinding() {
        Binding groovyBinding;
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        if (currentRequest != null) {
            groovyBinding = (Binding)currentRequest.getAttribute(ATTR_REQUEST_GROOVY_BINDING);
            if (groovyBinding == null) {
                groovyBinding = new Binding();
                currentRequest.setAttribute(ATTR_REQUEST_GROOVY_BINDING, (Object)groovyBinding);
            }
        } else {
            groovyBinding = new Binding();
        }
        return groovyBinding;
    }

    private synchronized GroovyShell getGroovyShell(String groovyClasspath) {
        if (this.groovyShell == null) {
            Jenkins jenkins = Jenkins.get();
            ClassLoader cl = jenkins.getPluginManager().uberClassLoader;
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
            if (!StringUtils.isBlank((String)groovyClasspath)) {
                compilerConfiguration.setClasspath(groovyClasspath);
            }
            Binding groovyBinding = this.getGroovyBinding();
            this.groovyShell = new GroovyShell(cl, groovyBinding, compilerConfiguration);
        } else {
            if (!StringUtils.isBlank((String)groovyClasspath)) {
                String[] groovyClasspathElements;
                for (String groovyClasspathElement : groovyClasspathElements = groovyClasspath.split(";")) {
                    this.groovyShell.getClassLoader().addClasspath(groovyClasspathElement);
                }
            }
            try {
                Binding groovyBinding = this.getGroovyBinding();
                Field contextField = this.groovyShell.getClass().getDeclaredField("context");
                contextField.setAccessible(true);
                contextField.set(this.groovyShell, groovyBinding);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.groovyShell;
    }

    private String processGroovyValue(boolean isSingleValued, Object groovyValue) {
        String value = null;
        if (groovyValue instanceof String[]) {
            String[] groovyValues = (String[])groovyValue;
            if (!isSingleValued) {
                value = StringUtils.join((Object[])((String[])groovyValue), (String)this.multiSelectDelimiter);
            } else if (groovyValues.length > 0) {
                value = groovyValues[0];
            }
        } else if (groovyValue instanceof List) {
            List groovyValues = (List)groovyValue;
            if (!isSingleValued) {
                value = StringUtils.join((Collection)groovyValues, (String)this.multiSelectDelimiter);
            } else if (!groovyValues.isEmpty()) {
                value = (String)groovyValues.get(0);
            }
        } else if (groovyValue instanceof String) {
            value = (String)groovyValue;
        }
        return value;
    }

    private void setBindings(GroovyShell shell, String bindings) throws IOException {
        if (bindings != null) {
            Properties p = new Properties();
            p.load(new StringReader(bindings));
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                shell.setVariable((String)entry.getKey(), entry.getValue());
            }
        }
        Jenkins instance = Jenkins.get();
        shell.setProperty("jenkins", (Object)instance);
        if (this.projectName != null) {
            AbstractProject project = (AbstractProject)instance.getItem(this.projectName);
            shell.setProperty("currentProject", (Object)project);
        }
    }

    private String computeEffectiveValue() {
        return this.computeValue(this.value, this.propertyFile, this.propertyKey, this.groovyScript, this.groovyScriptFile, this.bindings, this.groovyClasspath, false);
    }

    private String computeEffectiveDefaultValue() {
        return this.computeValue(this.defaultValue, this.defaultPropertyFile, this.defaultPropertyKey, this.defaultGroovyScript, this.defaultGroovyScriptFile, this.defaultBindings, this.defaultGroovyClasspath, this.isSingleValuedParameterType(this.type));
    }

    private boolean isSingleValuedParameterType(String type) {
        return PARAMETER_TYPE_RADIO.equals(type) || PARAMETER_TYPE_SINGLE_SELECT.equals(type);
    }

    private String computeEffectiveDescriptionPropertyValue() {
        return this.computeValue(this.descriptionPropertyValue, this.descriptionPropertyFile, this.descriptionPropertyKey, this.descriptionGroovyScript, this.descriptionGroovyScriptFile, this.descriptionBindings, this.descriptionGroovyClasspath, false);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public String getGroovyScript() {
        return this.groovyScript;
    }

    public void setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
    }

    public String getGroovyScriptFile() {
        return this.groovyScriptFile;
    }

    public void setGroovyScriptFile(String groovyScriptFile) {
        this.groovyScriptFile = groovyScriptFile;
    }

    public String getBindings() {
        return this.bindings;
    }

    public void setBindings(String bindings) {
        this.bindings = bindings;
    }

    public String getDefaultPropertyKey() {
        return this.defaultPropertyKey;
    }

    public void setDefaultPropertyKey(String defaultPropertyKey) {
        this.defaultPropertyKey = defaultPropertyKey;
    }

    private ArrayList<Integer> columnIndicesForDropDowns(String[] headerColumns) {
        String[] dropDownNames;
        ArrayList<Integer> columnIndicesForDropDowns = new ArrayList<Integer>();
        for (String dropDownName : dropDownNames = this.value.split(",")) {
            for (int i = 0; i < headerColumns.length; ++i) {
                if (!headerColumns[i].equals(dropDownName)) continue;
                columnIndicesForDropDowns.add(i);
            }
        }
        return columnIndicesForDropDowns;
    }

    Map<String, Set<String>> calculateChoicesByDropdownId() throws Exception {
        List fileLines;
        String resolvedPropertyFile = this.expandVariables(this.propertyFile);
        File file = new File(resolvedPropertyFile);
        CSVParser csvParser = new CSVParserBuilder().withSeparator('\t').build();
        try (CSVReader csvReader = new CSVReaderBuilder((Reader)new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8)).withCSVParser((ICSVParser)csvParser).build();){
            fileLines = csvReader.readAll();
        }
        if (fileLines.size() < 2) {
            throw new Exception("Multi level tab delimited file must have at least 2 lines (one for the header, and one or more for the data)");
        }
        ArrayList<Integer> columnIndicesForDropDowns = this.columnIndicesForDropDowns((String[])fileLines.get(0));
        List dataLines = fileLines.subList(1, fileLines.size());
        LinkedHashMap<String, Set<String>> choicesByDropdownId = new LinkedHashMap<String, Set<String>>();
        String prefix = this.getName() + " dropdown MultiLevelMultiSelect 0";
        choicesByDropdownId.put(prefix, new LinkedHashSet());
        for (int i = 0; i < columnIndicesForDropDowns.size(); ++i) {
            String prettyCurrentColumnName = this.value.split(",")[i];
            prettyCurrentColumnName = prettyCurrentColumnName.toLowerCase();
            prettyCurrentColumnName = prettyCurrentColumnName.replace("_", " ");
            for (String[] dataLine : dataLines) {
                StringBuilder priorLevelDropdownIdBuilder = new StringBuilder(prefix);
                StringBuilder currentLevelDropdownIdBuilder = new StringBuilder(prefix);
                int column = 0;
                for (int j = 0; j <= i; ++j) {
                    column = columnIndicesForDropDowns.get(j);
                    if (j < i) {
                        priorLevelDropdownIdBuilder.append(" ");
                        priorLevelDropdownIdBuilder.append(dataLine[column]);
                    }
                    currentLevelDropdownIdBuilder.append(" ");
                    currentLevelDropdownIdBuilder.append(dataLine[column]);
                }
                if (i != columnIndicesForDropDowns.size() - 1) {
                    choicesByDropdownId.put(currentLevelDropdownIdBuilder.toString(), new LinkedHashSet());
                }
                Set choicesForPriorDropdown = (Set)choicesByDropdownId.get(priorLevelDropdownIdBuilder.toString());
                choicesForPriorDropdown.add("Select a " + prettyCurrentColumnName + "...");
                choicesForPriorDropdown.add(dataLine[column]);
            }
        }
        return choicesByDropdownId;
    }

    public String getMultiLevelDropdownIds() throws Exception {
        StringBuilder dropdownIdsBuilder = new StringBuilder();
        Map<String, Set<String>> choicesByDropdownId = this.calculateChoicesByDropdownId();
        for (String id : choicesByDropdownId.keySet()) {
            if (dropdownIdsBuilder.length() > 0) {
                dropdownIdsBuilder.append(",");
            }
            dropdownIdsBuilder.append(id);
        }
        return dropdownIdsBuilder.toString();
    }

    public Map<String, String> getChoicesByDropdownId() throws Exception {
        Map<String, Set<String>> choicesByDropdownId = this.calculateChoicesByDropdownId();
        LinkedHashMap<String, String> collapsedMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Set<String>> dropdownIdEntry : choicesByDropdownId.entrySet()) {
            StringBuilder choicesBuilder = new StringBuilder();
            for (String choice : dropdownIdEntry.getValue()) {
                if (choicesBuilder.length() > 0) {
                    choicesBuilder.append(",");
                }
                choicesBuilder.append(choice);
            }
            collapsedMap.put(dropdownIdEntry.getKey(), choicesBuilder.toString());
        }
        return collapsedMap;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public void setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public String getDefaultPropertyFile() {
        return this.defaultPropertyFile;
    }

    public String getDefaultGroovyScript() {
        return this.defaultGroovyScript;
    }

    public void setDefaultGroovyScript(String defaultGroovyScript) {
        this.defaultGroovyScript = defaultGroovyScript;
    }

    public String getDefaultGroovyScriptFile() {
        return this.defaultGroovyScriptFile;
    }

    public void setDefaultGroovyScriptFile(String defaultGroovyScriptFile) {
        this.defaultGroovyScriptFile = defaultGroovyScriptFile;
    }

    public String getDefaultBindings() {
        return this.defaultBindings;
    }

    public void setDefaultBindings(String defaultBindings) {
        this.defaultBindings = defaultBindings;
    }

    public String getGroovyClasspath() {
        return this.groovyClasspath;
    }

    public void setGroovyClasspath(String groovyClasspath) {
        this.groovyClasspath = groovyClasspath;
    }

    public String getDefaultGroovyClasspath() {
        return this.defaultGroovyClasspath;
    }

    public void setDefaultGroovyClasspath(String defaultGroovyClasspath) {
        this.defaultGroovyClasspath = defaultGroovyClasspath;
    }

    public String getDescriptionPropertyValue() {
        return this.descriptionPropertyValue;
    }

    public void setDescriptionPropertyValue(String descriptionPropertyValue) {
        this.descriptionPropertyValue = descriptionPropertyValue;
    }

    public String getDescriptionPropertyFile() {
        return this.descriptionPropertyFile;
    }

    public void setDescriptionPropertyFile(String descriptionPropertyFile) {
        this.descriptionPropertyFile = descriptionPropertyFile;
    }

    public String getDescriptionGroovyScript() {
        return this.descriptionGroovyScript;
    }

    public void setDescriptionGroovyScript(String descriptionGroovyScript) {
        this.descriptionGroovyScript = descriptionGroovyScript;
    }

    public String getDescriptionGroovyScriptFile() {
        return this.descriptionGroovyScriptFile;
    }

    public void setDescriptionGroovyScriptFile(String descriptionGroovyScriptFile) {
        this.descriptionGroovyScriptFile = descriptionGroovyScriptFile;
    }

    public String getDescriptionBindings() {
        return this.descriptionBindings;
    }

    public void setDescriptionBindings(String descriptionBindings) {
        this.descriptionBindings = descriptionBindings;
    }

    public String getDescriptionGroovyClasspath() {
        return this.descriptionGroovyClasspath;
    }

    public void setDescriptionGroovyClasspath(String descriptionGroovyClasspath) {
        this.descriptionGroovyClasspath = descriptionGroovyClasspath;
    }

    public String getDescriptionPropertyKey() {
        return this.descriptionPropertyKey;
    }

    public void setDescriptionPropertyKey(String descriptionPropertyKey) {
        this.descriptionPropertyKey = descriptionPropertyKey;
    }

    public String getJavascriptFile() {
        return this.javascriptFile;
    }

    public void setJavascriptFile(String javascriptFile) {
        this.javascriptFile = javascriptFile;
    }

    public String getJavascript() {
        return this.javascript;
    }

    public void setJavascript(String javascript) {
        this.javascript = javascript;
    }

    public boolean isSaveJSONParameterToFile() {
        return this.saveJSONParameterToFile;
    }

    public void setSaveJSONParameterToFile(boolean saveJSONParameterToFile) {
        this.saveJSONParameterToFile = saveJSONParameterToFile;
    }

    public boolean isQuoteValue() {
        return this.quoteValue;
    }

    public void setQuoteValue(boolean quoteValue) {
        this.quoteValue = quoteValue;
    }

    public int getVisibleItemCount() {
        return this.visibleItemCount;
    }

    public void setVisibleItemCount(int visibleItemCount) {
        this.visibleItemCount = visibleItemCount;
    }

    public String getMultiSelectDelimiter() {
        return this.multiSelectDelimiter;
    }

    public void setMultiSelectDelimiter(String multiSelectDelimiter) {
        this.multiSelectDelimiter = multiSelectDelimiter;
    }

    public void setDefaultPropertyFile(String defaultPropertyFile) {
        this.defaultPropertyFile = defaultPropertyFile;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public boolean hasUnapprovedScripts() {
        boolean result = false;
        try {
            String script;
            if (!StringUtils.isBlank((String)this.groovyScript)) {
                result = !this.checkScriptApproval(this.groovyScript, this.groovyClasspath, true);
            } else if (!StringUtils.isBlank((String)this.groovyScriptFile)) {
                script = this.expandVariablesLoadFile(this.groovyScriptFile);
                boolean bl = result = !this.checkScriptApproval(script, this.groovyClasspath, true);
            }
            if (!StringUtils.isBlank((String)this.defaultGroovyScript)) {
                result = !this.checkScriptApproval(this.defaultGroovyScript, this.defaultGroovyClasspath, true);
            } else if (!StringUtils.isBlank((String)this.defaultGroovyScriptFile)) {
                script = this.expandVariablesLoadFile(this.defaultGroovyScriptFile);
                boolean bl = result = !this.checkScriptApproval(script, this.defaultGroovyClasspath, true);
            }
            if (!StringUtils.isBlank((String)this.descriptionGroovyScript)) {
                result = !this.checkScriptApproval(this.descriptionGroovyScript, this.descriptionGroovyClasspath, true);
            } else if (!StringUtils.isBlank((String)this.descriptionGroovyScriptFile)) {
                script = this.expandVariablesLoadFile(this.descriptionGroovyScriptFile);
                result = !this.checkScriptApproval(script, this.descriptionGroovyClasspath, true);
            }
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return result;
    }

    private String expandVariablesLoadFile(String fileName) throws IOException {
        return Util.loadFile((File)new File(this.expandVariables(fileName)), (Charset)StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkScriptApproval(String groovyScript, String groovyClasspath, boolean impersonateAnonymousUser) throws IOException, URISyntaxException {
        boolean result = true;
        Authentication authentication = Jenkins.getAuthentication();
        try {
            ScriptApproval scriptApproval = ScriptApproval.get();
            Jenkins instance = Jenkins.get();
            AbstractProject project = (AbstractProject)(this.projectName != null ? instance.getItem(this.projectName) : null);
            if (impersonateAnonymousUser) {
                SecurityContextHolder.getContext().setAuthentication(Jenkins.ANONYMOUS);
            }
            try {
                scriptApproval.configuring(groovyScript, GroovyLanguage.get(), ApprovalContext.create());
                scriptApproval.using(groovyScript, GroovyLanguage.get());
            }
            catch (UnapprovedClasspathException | UnapprovedUsageException e) {
                result = false;
            }
            List<ClasspathEntry> classpathEntries = this.parseClasspath(groovyClasspath);
            for (ClasspathEntry classpathEntry : classpathEntries) {
                if (classpathEntry.isClassDirectory()) {
                    ClasspathEntry classpathDirDigestEntry = this.createClasspathDirDigest(project, classpathEntry);
                    if (classpathDirDigestEntry != null) {
                        try {
                            scriptApproval.using(classpathDirDigestEntry);
                        }
                        catch (UnapprovedClasspathException | UnapprovedUsageException e) {
                            result = false;
                        }
                        continue;
                    }
                    result = false;
                    continue;
                }
                try {
                    scriptApproval.using(classpathEntry);
                }
                catch (UnapprovedClasspathException | UnapprovedUsageException e) {
                    result = false;
                }
            }
        }
        finally {
            if (impersonateAnonymousUser) {
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
        }
        return result;
    }

    private ClasspathEntry createClasspathDirDigest(AbstractProject<?, ?> project, ClasspathEntry classpathEntry) throws URISyntaxException, IOException {
        ClasspathEntry result = null;
        if (project != null) {
            URI classpathEntryURI = classpathEntry.getURL().toURI();
            File dirFile = new File(classpathEntryURI);
            final int[] fileCountHolder = new int[1];
            final ArrayList<Object[]> files = new ArrayList<Object[]>();
            new DirScanner.Full().scan(dirFile, new FileVisitor(){

                public void visit(File file, String relativePath) throws IOException {
                    if (file.isFile()) {
                        fileCountHolder[0] = fileCountHolder[0] + 1;
                        if (fileCountHolder[0] <= 500) {
                            files.add(new Object[]{file, relativePath});
                        } else {
                            throw new IOException("too many files in directory");
                        }
                    }
                }
            });
            files.sort((o1, o2) -> {
                String relativePath1 = (String)o1[1];
                String relativePath2 = (String)o2[1];
                return relativePath1.compareTo(relativePath2);
            });
            File digestFile = this.createDigest(project, classpathEntryURI, files);
            result = new ClasspathEntry(digestFile.toURI().toString());
        }
        return result;
    }

    private File createDigest(AbstractProject<?, ?> project, URI classpathEntryURI, List<Object[]> fileInfos) throws IOException {
        String classpathEntryStr = classpathEntryURI.toString();
        String digestFileName = this.getName() + this.computeMD5Hash(classpathEntryStr) + ".dig";
        File digestFile = new File(project.getRootDir(), digestFileName);
        try (PrintWriter pW = new PrintWriter(digestFile, "UTF-8");){
            pW.println(classpathEntryStr);
            for (Object[] fileInfo : fileInfos) {
                File file = (File)fileInfo[0];
                String relativePath = (String)fileInfo[1];
                String fileHash = this.hashFile(file);
                pW.println(relativePath + "::" + fileHash);
            }
        }
        return digestFile;
    }

    private String hashFile(File file) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException x) {
            throw new AssertionError((Object)x);
        }
        InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
        try (DigestInputStream input = new DigestInputStream(new BufferedInputStream(is), digest);){
            byte[] buffer = new byte[1024];
            while (input.read(buffer) != -1) {
            }
            String string = Util.toHexString((byte[])digest.digest());
            return string;
        }
    }

    private List<ClasspathEntry> parseClasspath(String groovyClasspath) throws MalformedURLException {
        ArrayList<ClasspathEntry> result = new ArrayList<ClasspathEntry>();
        if (!StringUtils.isEmpty((String)groovyClasspath)) {
            String[] classpathUrls;
            for (String classpathUrl : classpathUrls = groovyClasspath.split(";")) {
                ClasspathEntry classpathEntry = new ClasspathEntry(classpathUrl);
                result.add(classpathEntry);
            }
        }
        return result;
    }

    public ParameterDefinitionInfo getParameterDefinitionInfo() {
        ParameterDefinitionInfo result = new ParameterDefinitionInfo();
        String effectiveValue = this.computeEffectiveValue();
        Map<String, Boolean> defaultValueMap = this.computeDefaultValueMap();
        Map<String, String> descriptionPropertyValueMap = this.computeDescriptionPropertyValueMap(effectiveValue);
        result.setEffectiveValue(effectiveValue);
        result.setDefaultValueMap(defaultValueMap);
        result.setDescriptionPropertyValueMap(descriptionPropertyValueMap);
        return result;
    }

    public String getEffectiveDefaultValue() {
        return this.computeEffectiveDefaultValue();
    }

    public String getJSONEditorScript() {
        String result = null;
        try {
            if (!StringUtils.isBlank((String)this.javascript)) {
                result = this.javascript;
            } else if (!StringUtils.isBlank((String)this.javascriptFile)) {
                result = this.expandVariablesLoadFile(this.javascriptFile);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return result;
    }

    public Object getJSONEditorOptions() {
        Object result = null;
        try {
            String script = !StringUtils.isBlank((String)this.groovyScript) ? this.groovyScript : this.expandVariablesLoadFile(this.groovyScriptFile);
            result = this.executeGroovyScript(script, this.bindings, this.groovyClasspath);
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return result;
    }

    private String expandVariables(String input) {
        String result = input;
        if (input != null) {
            Jenkins instance = Jenkins.get();
            AbstractProject project = (AbstractProject)(this.projectName != null ? instance.getItem(this.projectName) : null);
            if (project != null) {
                try {
                    EnvVars envVars = project.getEnvironment(null, (TaskListener)new LogTaskListener(LOGGER, Level.SEVERE));
                    User user = User.current();
                    if (user != null) {
                        String userId = user.getId();
                        envVars.put("USER_ID", userId);
                    }
                    result = Util.replaceMacro((String)input, (Map)envVars);
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return result;
    }

    @Extension
    @Symbol(value={"extendedChoice"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.ExtendedChoiceParameterDefinition_DisplayName();
        }

        @POST
        public FormValidation doCheckPropertyFile(@QueryParameter String propertyFile, @QueryParameter String propertyKey, @QueryParameter String type) {
            if (StringUtils.isBlank((String)propertyFile)) {
                return FormValidation.ok();
            }
            Project project = new Project();
            Property property = new Property();
            property.setProject(project);
            File prop = new File(propertyFile);
            try {
                if (!prop.exists()) {
                    return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileDoesntExist(), (Object[])new Object[]{propertyFile});
                }
                property.setFile(prop);
                property.execute();
            }
            catch (BuildException e) {
                return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileDoesntExist(), (Object[])new Object[]{propertyFile});
            }
            if (ExtendedChoiceParameterDefinition.PARAMETER_TYPE_MULTI_LEVEL_SINGLE_SELECT.equals(type) || ExtendedChoiceParameterDefinition.PARAMETER_TYPE_MULTI_LEVEL_MULTI_SELECT.equals(type)) {
                return FormValidation.ok();
            }
            if (StringUtils.isNotBlank((String)propertyKey)) {
                if (project.getProperty(propertyKey) != null) {
                    return FormValidation.ok();
                }
                return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileExistsButProvidedKeyIsInvalid(), (Object[])new Object[]{propertyFile, propertyKey});
            }
            return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileExistsButNoProvidedKey(), (Object[])new Object[]{propertyFile});
        }

        @POST
        public FormValidation doCheckPropertyKey(@QueryParameter String propertyFile, @QueryParameter String propertyKey, @QueryParameter String type) {
            return this.doCheckPropertyFile(propertyFile, propertyKey, type);
        }

        @POST
        public FormValidation doCheckDefaultPropertyFile(@QueryParameter String defaultPropertyFile, @QueryParameter String defaultPropertyKey, @QueryParameter String type) {
            return this.doCheckPropertyFile(defaultPropertyFile, defaultPropertyKey, type);
        }

        @POST
        public FormValidation doCheckDefaultPropertyKey(@QueryParameter String defaultPropertyFile, @QueryParameter String defaultPropertyKey, @QueryParameter String type) {
            return this.doCheckPropertyFile(defaultPropertyFile, defaultPropertyKey, type);
        }

        public ExtendedChoiceParameterDefinition newInstance(StaplerRequest req, JSONObject formData) {
            JSONObject parameterGroup;
            String type = null;
            String multiSelectDelimiter = null;
            boolean quoteValue = false;
            boolean saveJSONParameterToFile = false;
            int visibleItemCount = 5;
            String propertyValue = null;
            String propertyKey = null;
            String propertyFile = null;
            String groovyScript = null;
            String groovyScriptFile = null;
            String bindings = null;
            String groovyClasspath = null;
            String javascriptFile = null;
            String javascript = null;
            String defaultPropertyValue = null;
            String defaultPropertyKey = null;
            String defaultPropertyFile = null;
            String defaultGroovyScript = null;
            String defaultGroovyScriptFile = null;
            String defaultBindings = null;
            String defaultGroovyClasspath = null;
            String descriptionPropertyValue = null;
            String descriptionPropertyKey = null;
            String descriptionPropertyFile = null;
            String descriptionGroovyScript = null;
            String descriptionGroovyScriptFile = null;
            String descriptionBindings = null;
            String descriptionGroovyClasspath = null;
            String projectName = null;
            String name = formData.getString("name");
            String description = formData.getString("description");
            AbstractProject project = (AbstractProject)Stapler.getCurrentRequest().findAncestorObject(AbstractProject.class);
            if (project != null) {
                projectName = project.getName();
            }
            if ((parameterGroup = formData.getJSONObject("parameterGroup")) != null) {
                int value = parameterGroup.getInt("value");
                if (value == 0) {
                    JSONObject descriptionPropertySourceJSON;
                    JSONObject defaultPropertySourceJSON;
                    JSONObject propertySourceJSON;
                    type = parameterGroup.getString("type");
                    quoteValue = parameterGroup.getBoolean("quoteValue");
                    visibleItemCount = parameterGroup.optInt("visibleItemCount", 5);
                    multiSelectDelimiter = parameterGroup.getString("multiSelectDelimiter");
                    if (StringUtils.isEmpty((String)multiSelectDelimiter)) {
                        multiSelectDelimiter = ",";
                    }
                    if ((propertySourceJSON = (JSONObject)parameterGroup.get("propertySource")) != null) {
                        if (propertySourceJSON.getInt("value") == 0) {
                            propertyValue = propertySourceJSON.getString("propertyValue");
                        } else if (propertySourceJSON.getInt("value") == 1) {
                            propertyFile = propertySourceJSON.getString("propertyFile");
                            propertyKey = propertySourceJSON.getString("propertyKey");
                        } else if (propertySourceJSON.getInt("value") == 2) {
                            groovyScript = propertySourceJSON.getString("groovyScript");
                            bindings = propertySourceJSON.getString("bindings");
                            groovyClasspath = propertySourceJSON.getString("groovyClasspath");
                        } else if (propertySourceJSON.getInt("value") == 3) {
                            groovyScriptFile = propertySourceJSON.getString("groovyScriptFile");
                            bindings = propertySourceJSON.getString("bindings");
                            groovyClasspath = propertySourceJSON.getString("groovyClasspath");
                        }
                    }
                    if ((defaultPropertySourceJSON = (JSONObject)parameterGroup.get("defaultPropertySource")) != null) {
                        if (defaultPropertySourceJSON.getInt("value") == 0) {
                            defaultPropertyValue = defaultPropertySourceJSON.getString("defaultPropertyValue");
                        } else if (defaultPropertySourceJSON.getInt("value") == 1) {
                            defaultPropertyFile = defaultPropertySourceJSON.getString("defaultPropertyFile");
                            defaultPropertyKey = defaultPropertySourceJSON.getString("defaultPropertyKey");
                        } else if (defaultPropertySourceJSON.getInt("value") == 2) {
                            defaultGroovyScript = defaultPropertySourceJSON.getString("defaultGroovyScript");
                            defaultBindings = defaultPropertySourceJSON.getString("defaultBindings");
                            defaultGroovyClasspath = defaultPropertySourceJSON.getString("defaultGroovyClasspath");
                        } else if (defaultPropertySourceJSON.getInt("value") == 3) {
                            defaultGroovyScriptFile = defaultPropertySourceJSON.getString("defaultGroovyScriptFile");
                            defaultBindings = defaultPropertySourceJSON.getString("defaultBindings");
                            defaultGroovyClasspath = defaultPropertySourceJSON.getString("defaultGroovyClasspath");
                        }
                    }
                    if ((descriptionPropertySourceJSON = (JSONObject)parameterGroup.get("descriptionPropertySource")) != null) {
                        if (descriptionPropertySourceJSON.getInt("value") == 0) {
                            descriptionPropertyValue = descriptionPropertySourceJSON.getString("descriptionPropertyValue");
                        } else if (descriptionPropertySourceJSON.getInt("value") == 1) {
                            descriptionPropertyFile = descriptionPropertySourceJSON.getString("descriptionPropertyFile");
                            descriptionPropertyKey = descriptionPropertySourceJSON.getString("descriptionPropertyKey");
                        } else if (descriptionPropertySourceJSON.getInt("value") == 2) {
                            descriptionGroovyScript = descriptionPropertySourceJSON.getString("descriptionGroovyScript");
                            descriptionBindings = descriptionPropertySourceJSON.getString("descriptionBindings");
                            descriptionGroovyClasspath = descriptionPropertySourceJSON.getString("descriptionGroovyClasspath");
                        } else if (descriptionPropertySourceJSON.getInt("value") == 3) {
                            descriptionGroovyScriptFile = descriptionPropertySourceJSON.getString("descriptionGroovyScriptFile");
                            descriptionBindings = descriptionPropertySourceJSON.getString("descriptionBindings");
                            descriptionGroovyClasspath = descriptionPropertySourceJSON.getString("descriptionGroovyClasspath");
                        }
                    }
                } else if (value == 1) {
                    type = parameterGroup.getString("type");
                    propertyFile = parameterGroup.getString("propertyFile");
                    propertyValue = parameterGroup.optString("propertyValue");
                } else if (value == 2) {
                    JSONObject jsonParameterConfigJavascriptSourceJSON;
                    type = ExtendedChoiceParameterDefinition.PARAMETER_TYPE_JSON;
                    JSONObject jsonParameterConfigSourceJSON = (JSONObject)parameterGroup.get("jsonParameterConfigSource");
                    if (jsonParameterConfigSourceJSON != null) {
                        if (jsonParameterConfigSourceJSON.getInt("value") == 0) {
                            groovyScript = jsonParameterConfigSourceJSON.getString("groovyScript");
                            bindings = jsonParameterConfigSourceJSON.getString("bindings");
                            groovyClasspath = jsonParameterConfigSourceJSON.getString("groovyClasspath");
                        } else if (jsonParameterConfigSourceJSON.getInt("value") == 1) {
                            groovyScriptFile = jsonParameterConfigSourceJSON.getString("groovyScriptFile");
                            bindings = jsonParameterConfigSourceJSON.getString("bindings");
                            groovyClasspath = jsonParameterConfigSourceJSON.getString("groovyClasspath");
                        }
                    }
                    if ((jsonParameterConfigJavascriptSourceJSON = (JSONObject)parameterGroup.get("jsonParameterConfigJavascriptSource")) != null) {
                        if (jsonParameterConfigJavascriptSourceJSON.getInt("value") == 0) {
                            javascript = jsonParameterConfigJavascriptSourceJSON.optString("javascript");
                        } else if (jsonParameterConfigJavascriptSourceJSON.getInt("value") == 1) {
                            javascriptFile = jsonParameterConfigJavascriptSourceJSON.optString("javascriptFile");
                        }
                    }
                    saveJSONParameterToFile = parameterGroup.optBoolean("saveJSONParameterToFile");
                }
            } else {
                type = formData.getString("type");
                propertyFile = formData.getString("propertyFile");
                propertyKey = formData.getString("propertyKey");
                propertyValue = formData.optString("value");
                defaultPropertyFile = formData.optString("defaultPropertyFile");
                defaultPropertyKey = formData.optString("defaultPropertyKey");
                defaultPropertyValue = formData.optString("defaultValue");
            }
            return new ExtendedChoiceParameterDefinition(name, type, propertyValue, projectName, propertyFile, groovyScript, groovyScriptFile, bindings, groovyClasspath, propertyKey, defaultPropertyValue, defaultPropertyFile, defaultGroovyScript, defaultGroovyScriptFile, defaultBindings, defaultGroovyClasspath, defaultPropertyKey, descriptionPropertyValue, descriptionPropertyFile, descriptionGroovyScript, descriptionGroovyScriptFile, descriptionBindings, descriptionGroovyClasspath, descriptionPropertyKey, javascriptFile, javascript, saveJSONParameterToFile, quoteValue, visibleItemCount, description, multiSelectDelimiter);
        }
    }
}

