/*
 * Decompiled with CFR 0.152.
 */
package com.cwctravel.hudson.plugins.extended_choice_parameter;

import au.com.bytecode.opencsv.CSVReader;
import com.cwctravel.hudson.plugins.extended_choice_parameter.ExtendedChoiceParameterValue;
import com.cwctravel.hudson.plugins.extended_choice_parameter.Messages;
import com.cwctravel.hudson.plugins.extended_choice_parameter.ParameterDefinitionInfo;
import groovy.lang.Binding;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import hudson.Extension;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedChoiceParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = -2946187268529865645L;
    private static final Logger LOGGER = Logger.getLogger(ExtendedChoiceParameterDefinition.class.getName());
    private static final String ATTR_REQUEST_GROOVY_BINDING = "com.cwctravel.hudson.plugins.extended_choice_parameter.groovyBinding";
    public static final String PARAMETER_TYPE_SINGLE_SELECT = "PT_SINGLE_SELECT";
    public static final String PARAMETER_TYPE_MULTI_SELECT = "PT_MULTI_SELECT";
    public static final String PARAMETER_TYPE_CHECK_BOX = "PT_CHECKBOX";
    public static final String PARAMETER_TYPE_RADIO = "PT_RADIO";
    public static final String PARAMETER_TYPE_TEXT_BOX = "PT_TEXTBOX";
    public static final String PARAMETER_TYPE_MULTI_LEVEL_SINGLE_SELECT = "PT_MULTI_LEVEL_SINGLE_SELECT";
    public static final String PARAMETER_TYPE_MULTI_LEVEL_MULTI_SELECT = "PT_MULTI_LEVEL_MULTI_SELECT";
    private transient GroovyShell groovyShell;
    private boolean quoteValue;
    private int visibleItemCount;
    private String type;
    private String value;
    private String propertyFile;
    private String groovyScript;
    private String groovyScriptFile;
    private String bindings;
    private String groovyClasspath;
    private String propertyKey;
    private String defaultValue;
    private String defaultPropertyFile;
    private String defaultGroovyScript;
    private String defaultGroovyScriptFile;
    private String defaultBindings;
    private String defaultGroovyClasspath;
    private String defaultPropertyKey;
    private String multiSelectDelimiter;
    private String descriptionPropertyValue;
    private String descriptionPropertyFile;
    private String descriptionGroovyScript;
    private String descriptionGroovyScriptFile;
    private String descriptionBindings;
    private String descriptionGroovyClasspath;
    private String descriptionPropertyKey;

    public ExtendedChoiceParameterDefinition(String name, String type, String value, String propertyFile, String groovyScript, String groovyScriptFile, String bindings, String groovyClasspath, String propertyKey, String defaultValue, String defaultPropertyFile, String defaultGroovyScript, String defaultGroovyScriptFile, String defaultBindings, String defaultGroovyClasspath, String defaultPropertyKey, String descriptionPropertyValue, String descriptionPropertyFile, String descriptionGroovyScript, String descriptionGroovyScriptFile, String descriptionBindings, String descriptionGroovyClasspath, String descriptionPropertyKey, boolean quoteValue, int visibleItemCount, String description, String multiSelectDelimiter) {
        super(name, description);
        this.type = type;
        this.value = value;
        this.propertyFile = propertyFile;
        this.propertyKey = propertyKey;
        this.groovyScript = groovyScript;
        this.groovyScriptFile = groovyScriptFile;
        this.bindings = bindings;
        this.groovyClasspath = groovyClasspath;
        this.defaultValue = defaultValue;
        this.defaultPropertyFile = defaultPropertyFile;
        this.defaultPropertyKey = defaultPropertyKey;
        this.defaultGroovyScript = defaultGroovyScript;
        this.defaultGroovyScriptFile = defaultGroovyScriptFile;
        this.defaultBindings = defaultBindings;
        this.defaultGroovyClasspath = defaultGroovyClasspath;
        this.descriptionPropertyValue = descriptionPropertyValue;
        this.descriptionPropertyFile = descriptionPropertyFile;
        this.descriptionPropertyKey = descriptionPropertyKey;
        this.descriptionGroovyScript = descriptionGroovyScript;
        this.descriptionGroovyScriptFile = descriptionGroovyScriptFile;
        this.descriptionBindings = descriptionBindings;
        this.descriptionGroovyClasspath = descriptionGroovyClasspath;
        this.quoteValue = quoteValue;
        if (visibleItemCount == 0) {
            visibleItemCount = 5;
        }
        this.visibleItemCount = visibleItemCount;
        if (multiSelectDelimiter == null || "".equals(multiSelectDelimiter)) {
            multiSelectDelimiter = ",";
        }
        this.multiSelectDelimiter = multiSelectDelimiter;
    }

    private Map<String, Boolean> computeDefaultValueMap() {
        HashMap<String, Boolean> defaultValueMap = null;
        String effectiveDefaultValue = this.computeEffectiveDefaultValue();
        if (!StringUtils.isBlank((String)effectiveDefaultValue)) {
            String[] defaultValues;
            defaultValueMap = new HashMap<String, Boolean>();
            for (String value : defaultValues = StringUtils.split((String)effectiveDefaultValue, (char)',')) {
                defaultValueMap.put(StringUtils.trim((String)value), true);
            }
        }
        return defaultValueMap;
    }

    private Map<String, String> computeDescriptionPropertyValueMap(String effectiveValue) {
        HashMap<String, String> descriptionPropertyValueMap = null;
        if (effectiveValue != null) {
            String[] values = effectiveValue.split(",");
            String effectiveDescriptionPropertyValue = this.computeEffectiveDescriptionPropertyValue();
            if (!StringUtils.isBlank((String)effectiveDescriptionPropertyValue)) {
                descriptionPropertyValueMap = new HashMap<String, String>();
                String[] descriptionPropertyValues = StringUtils.split((String)effectiveDescriptionPropertyValue, (char)',');
                for (int i = 0; i < values.length && i < descriptionPropertyValues.length; ++i) {
                    descriptionPropertyValueMap.put(values[i], descriptionPropertyValues[i]);
                }
            }
        }
        return descriptionPropertyValueMap;
    }

    public ParameterValue createValue(StaplerRequest request) {
        String[] requestValues = request.getParameterValues(this.getName());
        return this.createValue(requestValues);
    }

    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        String[] requestValues = value != null ? value.split(",") : null;
        return this.createValue(requestValues);
    }

    ParameterValue createValue(String[] requestValues) {
        if (requestValues == null || requestValues.length == 0) {
            return this.getDefaultParameterValue();
        }
        if (PARAMETER_TYPE_TEXT_BOX.equals(this.type)) {
            return new ExtendedChoiceParameterValue(this.getName(), requestValues[0]);
        }
        String valueStr = this.computeEffectiveValue();
        if (valueStr != null) {
            ArrayList<String> result = new ArrayList<String>();
            String[] values = valueStr.split(",");
            HashSet<String> valueSet = new HashSet<String>();
            for (String value : values) {
                valueSet.add(value);
            }
            for (String requestValue : requestValues) {
                if (!valueSet.contains(requestValue)) continue;
                result.add(requestValue);
            }
            return new ExtendedChoiceParameterValue(this.getName(), StringUtils.join(result, (String)this.getMultiSelectDelimiter()));
        }
        return null;
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject jO) {
        Object value = jO.get("value");
        String strValue = "";
        if (value instanceof String) {
            strValue = (String)value;
        } else if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            if (this.type.equals(PARAMETER_TYPE_MULTI_LEVEL_SINGLE_SELECT) || this.type.equals(PARAMETER_TYPE_MULTI_LEVEL_MULTI_SELECT)) {
                int valuesBetweenLevels = this.value.split(",").length;
                Iterator it = jsonValues.iterator();
                int i = 1;
                while (it.hasNext()) {
                    String nextValue = it.next().toString();
                    if (i % valuesBetweenLevels == 0) {
                        if (strValue.length() > 0) {
                            strValue = strValue + this.getMultiSelectDelimiter();
                        }
                        strValue = strValue + nextValue;
                    }
                    ++i;
                }
            } else {
                strValue = StringUtils.join((Iterator)jsonValues.iterator(), (String)this.getMultiSelectDelimiter());
            }
        }
        if (this.quoteValue) {
            strValue = "\"" + strValue + "\"";
        }
        return new ExtendedChoiceParameterValue(this.getName(), strValue);
    }

    public ParameterValue getDefaultParameterValue() {
        String defaultValue = this.computeEffectiveDefaultValue();
        if (!StringUtils.isBlank((String)defaultValue)) {
            if (this.quoteValue) {
                defaultValue = "\"" + defaultValue + "\"";
            }
            return new ExtendedChoiceParameterValue(this.getName(), defaultValue);
        }
        return super.getDefaultParameterValue();
    }

    private String computeValue(String value, String propertyFilePath, String propertyKey, String groovyScript, String groovyScriptFile, String bindings, String groovyClasspath, boolean isDefault) {
        if (!StringUtils.isBlank((String)propertyFilePath) && !StringUtils.isBlank((String)propertyKey)) {
            try {
                File propertyFile = new File(propertyFilePath);
                if (propertyFile.exists()) {
                    Project project = new Project();
                    Property property = new Property();
                    property.setProject(project);
                    property.setFile(propertyFile);
                    property.execute();
                    return project.getProperty(propertyKey);
                }
                Project project = new Project();
                Property property = new Property();
                property.setProject(project);
                URL propertyFileUrl = new URL(propertyFilePath);
                property.setUrl(propertyFileUrl);
                property.execute();
                return project.getProperty(propertyKey);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            if (!StringUtils.isBlank((String)groovyScript)) {
                return this.executeGroovyScript(groovyScript, bindings, groovyClasspath, isDefault);
            }
            if (!StringUtils.isBlank((String)groovyScriptFile)) {
                return this.executeGroovyScriptFile(groovyScriptFile, bindings, groovyClasspath, isDefault);
            }
            if (!StringUtils.isBlank((String)value)) {
                return value;
            }
        }
        return null;
    }

    private String executeGroovyScriptFile(String groovyScriptFile, String bindings, String groovyClasspath, boolean isDefault) {
        String result = null;
        try {
            String groovyScript = Util.loadFile((File)new File(groovyScriptFile));
            result = this.executeGroovyScript(groovyScript, bindings, groovyClasspath, isDefault);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return result;
    }

    private String executeGroovyScript(String groovyScript, String bindings, String groovyClasspath, boolean isDefault) {
        String result = null;
        try {
            GroovyShell groovyShell = this.getGroovyShell(groovyClasspath);
            groovyShell.getClassLoader().parseClass(new GroovyCodeSource(groovyScript, this.computeMD5Hash(groovyScript), "/groovy/shell"), true);
            this.setBindings(groovyShell, bindings);
            Object groovyValue = groovyShell.evaluate(groovyScript);
            result = this.processGroovyValue(isDefault, groovyValue);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return result;
    }

    private String computeMD5Hash(String str) {
        String result = str;
        if (str != null) {
            result = DigestUtils.md5Hex((String)str);
        }
        return result;
    }

    private Binding getGroovyBinding() {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        Binding groovyBinding = (Binding)currentRequest.getAttribute(ATTR_REQUEST_GROOVY_BINDING);
        if (groovyBinding == null) {
            groovyBinding = new Binding();
            currentRequest.setAttribute(ATTR_REQUEST_GROOVY_BINDING, (Object)groovyBinding);
        }
        return groovyBinding;
    }

    private synchronized GroovyShell getGroovyShell(String groovyClasspath) {
        if (this.groovyShell == null) {
            ClassLoader cl = Hudson.getInstance().getPluginManager().uberClassLoader;
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
            if (!StringUtils.isBlank((String)groovyClasspath)) {
                compilerConfiguration.setClasspath(groovyClasspath);
            }
            Binding groovyBinding = this.getGroovyBinding();
            this.groovyShell = new GroovyShell(cl, groovyBinding, compilerConfiguration);
        } else {
            if (!StringUtils.isBlank((String)groovyClasspath)) {
                String[] groovyClasspathElements;
                for (String groovyClasspathElement : groovyClasspathElements = groovyClasspath.split(";")) {
                    this.groovyShell.getClassLoader().addClasspath(groovyClasspathElement);
                }
            }
            try {
                Binding groovyBinding = this.getGroovyBinding();
                Field contextField = this.groovyShell.getClass().getDeclaredField("context");
                contextField.setAccessible(true);
                contextField.set(this.groovyShell, groovyBinding);
            }
            catch (NoSuchFieldException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (SecurityException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.groovyShell;
    }

    private String processGroovyValue(boolean isDefault, Object groovyValue) {
        String value = null;
        if (groovyValue instanceof String[]) {
            String[] groovyValues = (String[])groovyValue;
            if (!isDefault) {
                value = StringUtils.join((Object[])((String[])groovyValue), (String)this.multiSelectDelimiter);
            } else if (groovyValues.length > 0) {
                value = groovyValues[0];
            }
        } else if (groovyValue instanceof List) {
            List groovyValues = (List)groovyValue;
            if (!isDefault) {
                value = StringUtils.join((Collection)groovyValues, (String)this.multiSelectDelimiter);
            } else if (!groovyValues.isEmpty()) {
                value = (String)groovyValues.get(0);
            }
        } else if (groovyValue instanceof String) {
            value = (String)groovyValue;
        }
        return value;
    }

    private void setBindings(GroovyShell shell, String bindings) throws IOException {
        if (bindings != null) {
            Properties p = new Properties();
            p.load(new StringReader(bindings));
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                shell.setVariable((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private String computeEffectiveValue() {
        return this.computeValue(this.value, this.propertyFile, this.propertyKey, this.groovyScript, this.groovyScriptFile, this.bindings, this.groovyClasspath, false);
    }

    private String computeEffectiveDefaultValue() {
        return this.computeValue(this.defaultValue, this.defaultPropertyFile, this.defaultPropertyKey, this.defaultGroovyScript, this.defaultGroovyScriptFile, this.defaultBindings, this.defaultGroovyClasspath, true);
    }

    private String computeEffectiveDescriptionPropertyValue() {
        return this.computeValue(this.descriptionPropertyValue, this.descriptionPropertyFile, this.descriptionPropertyKey, this.descriptionGroovyScript, this.descriptionGroovyScriptFile, this.descriptionBindings, this.descriptionGroovyClasspath, false);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public String getGroovyScript() {
        return this.groovyScript;
    }

    public void setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
    }

    public String getGroovyScriptFile() {
        return this.groovyScriptFile;
    }

    public void setGroovyScriptFile(String groovyScriptFile) {
        this.groovyScriptFile = groovyScriptFile;
    }

    public String getBindings() {
        return this.bindings;
    }

    public void setBindings(String bindings) {
        this.bindings = bindings;
    }

    public String getDefaultPropertyKey() {
        return this.defaultPropertyKey;
    }

    public void setDefaultPropertyKey(String defaultPropertyKey) {
        this.defaultPropertyKey = defaultPropertyKey;
    }

    private ArrayList<Integer> columnIndicesForDropDowns(String[] headerColumns) {
        String[] dropDownNames;
        ArrayList<Integer> columnIndicesForDropDowns = new ArrayList<Integer>();
        for (String dropDownName : dropDownNames = this.value.split(",")) {
            for (int i = 0; i < headerColumns.length; ++i) {
                if (!headerColumns[i].equals(dropDownName)) continue;
                columnIndicesForDropDowns.add(new Integer(i));
            }
        }
        return columnIndicesForDropDowns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkedHashMap<String, LinkedHashSet<String>> calculateChoicesByDropdownId() throws Exception {
        File file = new File(this.propertyFile);
        List fileLines = Collections.emptyList();
        if (file.isFile()) {
            CSVReader csvReader = null;
            try {
                csvReader = new CSVReader((Reader)new FileReader(file), '\t');
                fileLines = csvReader.readAll();
            }
            finally {
                csvReader.close();
            }
        }
        URL propertyFileUrl = new URL(this.propertyFile);
        CSVReader csvReader = null;
        try {
            csvReader = new CSVReader((Reader)new InputStreamReader(propertyFileUrl.openStream()), '\t');
            fileLines = csvReader.readAll();
        }
        finally {
            csvReader.close();
        }
        if (fileLines.size() < 2) {
            throw new Exception("Multi level tab delimited file must have at least 2 lines (one for the header, and one or more for the data)");
        }
        ArrayList<Integer> columnIndicesForDropDowns = this.columnIndicesForDropDowns((String[])fileLines.get(0));
        List dataLines = fileLines.subList(1, fileLines.size());
        LinkedHashMap<String, LinkedHashSet<String>> choicesByDropdownId = new LinkedHashMap<String, LinkedHashSet<String>>();
        String prefix = this.getName() + " dropdown MultiLevelMultiSelect 0";
        choicesByDropdownId.put(prefix, new LinkedHashSet());
        for (int i = 0; i < columnIndicesForDropDowns.size(); ++i) {
            String prettyCurrentColumnName = this.value.split(",")[i];
            prettyCurrentColumnName = prettyCurrentColumnName.toLowerCase();
            prettyCurrentColumnName = prettyCurrentColumnName.replace("_", " ");
            for (String[] dataLine : dataLines) {
                String priorLevelDropdownId = prefix;
                String currentLevelDropdownId = prefix;
                int column = 0;
                for (int j = 0; j <= i; ++j) {
                    column = columnIndicesForDropDowns.get(j);
                    if (j < i) {
                        priorLevelDropdownId = priorLevelDropdownId + " " + dataLine[column];
                    }
                    currentLevelDropdownId = currentLevelDropdownId + " " + dataLine[column];
                }
                if (i != columnIndicesForDropDowns.size() - 1) {
                    choicesByDropdownId.put(currentLevelDropdownId, new LinkedHashSet());
                }
                LinkedHashSet<String> choicesForPriorDropdown = choicesByDropdownId.get(priorLevelDropdownId);
                choicesForPriorDropdown.add("Select a " + prettyCurrentColumnName + "...");
                choicesForPriorDropdown.add(dataLine[column]);
            }
        }
        return choicesByDropdownId;
    }

    public String getMultiLevelDropdownIds() throws Exception {
        String dropdownIds = new String();
        LinkedHashMap<String, LinkedHashSet<String>> choicesByDropdownId = this.calculateChoicesByDropdownId();
        for (String id : choicesByDropdownId.keySet()) {
            if (dropdownIds.length() > 0) {
                dropdownIds = dropdownIds + ",";
            }
            dropdownIds = dropdownIds + id;
        }
        return dropdownIds;
    }

    public Map<String, String> getChoicesByDropdownId() throws Exception {
        LinkedHashMap<String, LinkedHashSet<String>> choicesByDropdownId = this.calculateChoicesByDropdownId();
        LinkedHashMap<String, String> collapsedMap = new LinkedHashMap<String, String>();
        for (String dropdownId : choicesByDropdownId.keySet()) {
            String choices = new String();
            for (String choice : choicesByDropdownId.get(dropdownId)) {
                if (choices.length() > 0) {
                    choices = choices + ",";
                }
                choices = choices + choice;
            }
            collapsedMap.put(dropdownId, choices);
        }
        return collapsedMap;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public void setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public String getDefaultPropertyFile() {
        return this.defaultPropertyFile;
    }

    public String getDefaultGroovyScript() {
        return this.defaultGroovyScript;
    }

    public void setDefaultGroovyScript(String defaultGroovyScript) {
        this.defaultGroovyScript = defaultGroovyScript;
    }

    public String getDefaultGroovyScriptFile() {
        return this.defaultGroovyScriptFile;
    }

    public void setDefaultGroovyScriptFile(String defaultGroovyScriptFile) {
        this.defaultGroovyScriptFile = defaultGroovyScriptFile;
    }

    public String getDefaultBindings() {
        return this.defaultBindings;
    }

    public void setDefaultBindings(String defaultBindings) {
        this.defaultBindings = defaultBindings;
    }

    public String getGroovyClasspath() {
        return this.groovyClasspath;
    }

    public void setGroovyClasspath(String groovyClasspath) {
        this.groovyClasspath = groovyClasspath;
    }

    public String getDefaultGroovyClasspath() {
        return this.defaultGroovyClasspath;
    }

    public void setDefaultGroovyClasspath(String defaultGroovyClasspath) {
        this.defaultGroovyClasspath = defaultGroovyClasspath;
    }

    public String getDescriptionPropertyValue() {
        return this.descriptionPropertyValue;
    }

    public void setDescriptionPropertyValue(String descriptionPropertyValue) {
        this.descriptionPropertyValue = descriptionPropertyValue;
    }

    public String getDescriptionPropertyFile() {
        return this.descriptionPropertyFile;
    }

    public void setDescriptionPropertyFile(String descriptionPropertyFile) {
        this.descriptionPropertyFile = descriptionPropertyFile;
    }

    public String getDescriptionGroovyScript() {
        return this.descriptionGroovyScript;
    }

    public void setDescriptionGroovyScript(String descriptionGroovyScript) {
        this.descriptionGroovyScript = descriptionGroovyScript;
    }

    public String getDescriptionGroovyScriptFile() {
        return this.descriptionGroovyScriptFile;
    }

    public void setDescriptionGroovyScriptFile(String descriptionGroovyScriptFile) {
        this.descriptionGroovyScriptFile = descriptionGroovyScriptFile;
    }

    public String getDescriptionBindings() {
        return this.descriptionBindings;
    }

    public void setDescriptionBindings(String descriptionBindings) {
        this.descriptionBindings = descriptionBindings;
    }

    public String getDescriptionGroovyClasspath() {
        return this.descriptionGroovyClasspath;
    }

    public void setDescriptionGroovyClasspath(String descriptionGroovyClasspath) {
        this.descriptionGroovyClasspath = descriptionGroovyClasspath;
    }

    public String getDescriptionPropertyKey() {
        return this.descriptionPropertyKey;
    }

    public void setDescriptionPropertyKey(String descriptionPropertyKey) {
        this.descriptionPropertyKey = descriptionPropertyKey;
    }

    public boolean isQuoteValue() {
        return this.quoteValue;
    }

    public void setQuoteValue(boolean quoteValue) {
        this.quoteValue = quoteValue;
    }

    public int getVisibleItemCount() {
        return this.visibleItemCount;
    }

    public void setVisibleItemCount(int visibleItemCount) {
        this.visibleItemCount = visibleItemCount;
    }

    public String getMultiSelectDelimiter() {
        return this.multiSelectDelimiter;
    }

    public void setMultiSelectDelimiter(String multiSelectDelimiter) {
        this.multiSelectDelimiter = multiSelectDelimiter;
    }

    public void setDefaultPropertyFile(String defaultPropertyFile) {
        this.defaultPropertyFile = defaultPropertyFile;
    }

    public ParameterDefinitionInfo getParameterDefinitionInfo() {
        ParameterDefinitionInfo result = new ParameterDefinitionInfo();
        String effectiveValue = this.computeEffectiveValue();
        Map<String, Boolean> defaultValueMap = this.computeDefaultValueMap();
        Map<String, String> descriptionPropertyValueMap = this.computeDescriptionPropertyValueMap(effectiveValue);
        result.setEffectiveValue(effectiveValue);
        result.setDefaultValueMap(defaultValueMap);
        result.setDescriptionPropertyValueMap(descriptionPropertyValueMap);
        return result;
    }

    public String getEffectiveDefaultValue() {
        return this.computeEffectiveDefaultValue();
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return Messages.ExtendedChoiceParameterDefinition_DisplayName();
        }

        public FormValidation doCheckPropertyFile(@QueryParameter String propertyFile, @QueryParameter String propertyKey, @QueryParameter String type) throws IOException, ServletException {
            if (StringUtils.isBlank((String)propertyFile)) {
                return FormValidation.ok();
            }
            Project project = new Project();
            Property property = new Property();
            property.setProject(project);
            File prop = new File(propertyFile);
            try {
                if (prop.exists()) {
                    property.setFile(prop);
                } else {
                    URL propertyFileUrl = new URL(propertyFile);
                    property.setUrl(propertyFileUrl);
                }
                property.execute();
            }
            catch (Exception e) {
                return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileDoesntExist(), (Object[])new Object[]{propertyFile});
            }
            if (ExtendedChoiceParameterDefinition.PARAMETER_TYPE_MULTI_LEVEL_SINGLE_SELECT.equals(type) || ExtendedChoiceParameterDefinition.PARAMETER_TYPE_MULTI_LEVEL_MULTI_SELECT.equals(type)) {
                return FormValidation.ok();
            }
            if (StringUtils.isNotBlank((String)propertyKey)) {
                if (project.getProperty(propertyKey) != null) {
                    return FormValidation.ok();
                }
                return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileExistsButProvidedKeyIsInvalid(), (Object[])new Object[]{propertyFile, propertyKey});
            }
            return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileExistsButNoProvidedKey(), (Object[])new Object[]{propertyFile});
        }

        public FormValidation doCheckPropertyKey(@QueryParameter String propertyFile, @QueryParameter String propertyKey, @QueryParameter String type) throws IOException, ServletException {
            return this.doCheckPropertyFile(propertyFile, propertyKey, type);
        }

        public FormValidation doCheckDefaultPropertyFile(@QueryParameter String defaultPropertyFile, @QueryParameter String defaultPropertyKey, @QueryParameter String type) throws IOException, ServletException {
            return this.doCheckPropertyFile(defaultPropertyFile, defaultPropertyKey, type);
        }

        public FormValidation doCheckDefaultPropertyKey(@QueryParameter String defaultPropertyFile, @QueryParameter String defaultPropertyKey, @QueryParameter String type) throws IOException, ServletException {
            return this.doCheckPropertyFile(defaultPropertyFile, defaultPropertyKey, type);
        }

        public ExtendedChoiceParameterDefinition newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String name = null;
            String type = null;
            String description = null;
            String multiSelectDelimiter = null;
            boolean quoteValue = false;
            int visibleItemCount = 5;
            String propertyValue = null;
            String propertyKey = null;
            String propertyFile = null;
            String groovyScript = null;
            String groovyScriptFile = null;
            String bindings = null;
            String groovyClasspath = null;
            String defaultPropertyValue = null;
            String defaultPropertyKey = null;
            String defaultPropertyFile = null;
            String defaultGroovyScript = null;
            String defaultGroovyScriptFile = null;
            String defaultBindings = null;
            String defaultGroovyClasspath = null;
            String descriptionPropertyValue = null;
            String descriptionPropertyKey = null;
            String descriptionPropertyFile = null;
            String descriptionGroovyScript = null;
            String descriptionGroovyScriptFile = null;
            String descriptionBindings = null;
            String descriptionGroovyClasspath = null;
            name = formData.getString("name");
            description = formData.getString("description");
            JSONObject parameterGroup = formData.getJSONObject("parameterGroup");
            if (parameterGroup != null) {
                int value = parameterGroup.getInt("value");
                if (value == 0) {
                    JSONObject descriptionPropertySourceJSON;
                    JSONObject defaultPropertySourceJSON;
                    JSONObject propertySourceJSON;
                    type = parameterGroup.getString("type");
                    quoteValue = parameterGroup.getBoolean("quoteValue");
                    visibleItemCount = parameterGroup.optInt("visibleItemCount", 5);
                    multiSelectDelimiter = parameterGroup.getString("multiSelectDelimiter");
                    if (StringUtils.isEmpty((String)multiSelectDelimiter)) {
                        multiSelectDelimiter = ",";
                    }
                    if ((propertySourceJSON = (JSONObject)parameterGroup.get("propertySource")) != null) {
                        if (propertySourceJSON.getInt("value") == 0) {
                            propertyValue = propertySourceJSON.getString("propertyValue");
                        } else if (propertySourceJSON.getInt("value") == 1) {
                            propertyFile = propertySourceJSON.getString("propertyFile");
                            propertyKey = propertySourceJSON.getString("propertyKey");
                        } else if (propertySourceJSON.getInt("value") == 2) {
                            groovyScript = propertySourceJSON.getString("groovyScript");
                            bindings = propertySourceJSON.getString("bindings");
                            groovyClasspath = propertySourceJSON.getString("groovyClasspath");
                        } else if (propertySourceJSON.getInt("value") == 3) {
                            groovyScriptFile = propertySourceJSON.getString("groovyScriptFile");
                            bindings = propertySourceJSON.getString("bindings");
                            groovyClasspath = propertySourceJSON.getString("groovyClasspath");
                        }
                    }
                    if ((defaultPropertySourceJSON = (JSONObject)parameterGroup.get("defaultPropertySource")) != null) {
                        if (defaultPropertySourceJSON.getInt("value") == 0) {
                            defaultPropertyValue = defaultPropertySourceJSON.getString("defaultPropertyValue");
                        } else if (defaultPropertySourceJSON.getInt("value") == 1) {
                            defaultPropertyFile = defaultPropertySourceJSON.getString("defaultPropertyFile");
                            defaultPropertyKey = defaultPropertySourceJSON.getString("defaultPropertyKey");
                        } else if (defaultPropertySourceJSON.getInt("value") == 2) {
                            defaultGroovyScript = defaultPropertySourceJSON.getString("defaultGroovyScript");
                            defaultBindings = defaultPropertySourceJSON.getString("defaultBindings");
                            defaultGroovyClasspath = defaultPropertySourceJSON.getString("defaultGroovyClasspath");
                        } else if (defaultPropertySourceJSON.getInt("value") == 3) {
                            defaultGroovyScriptFile = defaultPropertySourceJSON.getString("defaultGroovyScriptFile");
                            defaultBindings = defaultPropertySourceJSON.getString("defaultBindings");
                            defaultGroovyClasspath = defaultPropertySourceJSON.getString("defaultGroovyClasspath");
                        }
                    }
                    if ((descriptionPropertySourceJSON = (JSONObject)parameterGroup.get("descriptionPropertySource")) != null) {
                        if (descriptionPropertySourceJSON.getInt("value") == 0) {
                            descriptionPropertyValue = descriptionPropertySourceJSON.getString("descriptionPropertyValue");
                        } else if (descriptionPropertySourceJSON.getInt("value") == 1) {
                            descriptionPropertyFile = descriptionPropertySourceJSON.getString("descriptionPropertyFile");
                            descriptionPropertyKey = descriptionPropertySourceJSON.getString("descriptionPropertyKey");
                        } else if (descriptionPropertySourceJSON.getInt("value") == 2) {
                            descriptionGroovyScript = descriptionPropertySourceJSON.getString("descriptionGroovyScript");
                            descriptionBindings = descriptionPropertySourceJSON.getString("descriptionBindings");
                            descriptionGroovyClasspath = descriptionPropertySourceJSON.getString("descriptionGroovyClasspath");
                        } else if (descriptionPropertySourceJSON.getInt("value") == 3) {
                            descriptionGroovyScriptFile = descriptionPropertySourceJSON.getString("descriptionGroovyScriptFile");
                            descriptionBindings = descriptionPropertySourceJSON.getString("descriptionBindings");
                            descriptionGroovyClasspath = descriptionPropertySourceJSON.getString("descriptionGroovyClasspath");
                        }
                    }
                } else if (value == 1) {
                    type = parameterGroup.getString("type");
                    propertyFile = parameterGroup.getString("propertyFile");
                    propertyValue = parameterGroup.optString("propertyValue");
                }
            } else {
                type = formData.getString("type");
                propertyFile = formData.getString("propertyFile");
                propertyKey = formData.getString("propertyKey");
                propertyValue = formData.optString("value");
                defaultPropertyFile = formData.optString("defaultPropertyFile");
                defaultPropertyKey = formData.optString("defaultPropertyKey");
                defaultPropertyValue = formData.optString("defaultValue");
            }
            return new ExtendedChoiceParameterDefinition(name, type, propertyValue, propertyFile, groovyScript, groovyScriptFile, bindings, groovyClasspath, propertyKey, defaultPropertyValue, defaultPropertyFile, defaultGroovyScript, defaultGroovyScriptFile, defaultBindings, defaultGroovyClasspath, defaultPropertyKey, descriptionPropertyValue, descriptionPropertyFile, descriptionGroovyScript, descriptionGroovyScriptFile, descriptionBindings, descriptionGroovyClasspath, descriptionPropertyKey, quoteValue, visibleItemCount, description, multiSelectDelimiter);
        }
    }
}

