/*
 * Decompiled with CFR 0.152.
 */
package com.cwctravel.hudson.plugins.extended_choice_parameter;

import au.com.bytecode.opencsv.CSVReader;
import com.cwctravel.hudson.plugins.extended_choice_parameter.ExtendedChoiceParameterValue;
import com.cwctravel.hudson.plugins.extended_choice_parameter.Messages;
import groovy.lang.GroovyShell;
import hudson.Extension;
import hudson.RelativePath;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedChoiceParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = -2946187268529865645L;
    public static final String PARAMETER_TYPE_SINGLE_SELECT = "PT_SINGLE_SELECT";
    public static final String PARAMETER_TYPE_MULTI_SELECT = "PT_MULTI_SELECT";
    public static final String PARAMETER_TYPE_CHECK_BOX = "PT_CHECKBOX";
    public static final String PARAMETER_TYPE_RADIO = "PT_RADIO";
    public static final String PARAMETER_TYPE_TEXT_BOX = "PT_TEXTBOX";
    public static final String PARAMETER_TYPE_MULTI_LEVEL_SINGLE_SELECT = "PT_MULTI_LEVEL_SINGLE_SELECT";
    public static final String PARAMETER_TYPE_MULTI_LEVEL_MULTI_SELECT = "PT_MULTI_LEVEL_MULTI_SELECT";
    private boolean quoteValue;
    private int visibleItemCount;
    private String type;
    private String value;
    private String propertyFile;
    private String groovyScript;
    private String groovyScriptFile;
    private String bindings;
    private String propertyKey;
    private String defaultValue;
    private String defaultPropertyFile;
    private String defaultGroovyScript;
    private String defaultGroovyScriptFile;
    private String defaultBindings;
    private String defaultPropertyKey;
    private String multiSelectDelimiter;

    public ExtendedChoiceParameterDefinition(String name, String type, String value, String propertyFile, String groovyScript, String groovyScriptFile, String bindings, String propertyKey, String defaultValue, String defaultPropertyFile, String defaultGroovyScript, String defaultGroovyScriptFile, String defaultBindings, String defaultPropertyKey, boolean quoteValue, int visibleItemCount, String description, String multiSelectDelimiter) {
        super(name, description);
        this.type = type;
        this.value = value;
        this.propertyFile = propertyFile;
        this.propertyKey = propertyKey;
        this.groovyScript = groovyScript;
        this.groovyScriptFile = groovyScriptFile;
        this.bindings = bindings;
        this.defaultValue = defaultValue;
        this.defaultPropertyFile = defaultPropertyFile;
        this.defaultPropertyKey = defaultPropertyKey;
        this.defaultGroovyScript = defaultGroovyScript;
        this.defaultGroovyScriptFile = defaultGroovyScriptFile;
        this.defaultBindings = defaultBindings;
        this.quoteValue = quoteValue;
        if (visibleItemCount == 0) {
            visibleItemCount = 5;
        }
        this.visibleItemCount = visibleItemCount;
        if (multiSelectDelimiter.equals("")) {
            multiSelectDelimiter = ",";
        }
        this.multiSelectDelimiter = multiSelectDelimiter;
    }

    private Map<String, Boolean> computeDefaultValueMap() {
        HashMap<String, Boolean> defaultValueMap = null;
        String effectiveDefaultValue = this.getEffectiveDefaultValue();
        if (!StringUtils.isBlank((String)effectiveDefaultValue)) {
            String[] defaultValues;
            defaultValueMap = new HashMap<String, Boolean>();
            for (String value : defaultValues = StringUtils.split((String)effectiveDefaultValue, (char)',')) {
                defaultValueMap.put(StringUtils.trim((String)value), true);
            }
        }
        return defaultValueMap;
    }

    public ParameterValue createValue(StaplerRequest request) {
        String[] requestValues = request.getParameterValues(this.getName());
        return this.createValue(requestValues);
    }

    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        String[] requestValues = value != null ? value.split(",") : null;
        return this.createValue(requestValues);
    }

    ParameterValue createValue(String[] requestValues) {
        if (requestValues == null || requestValues.length == 0) {
            return this.getDefaultParameterValue();
        }
        if (PARAMETER_TYPE_TEXT_BOX.equals(this.type)) {
            return new ExtendedChoiceParameterValue(this.getName(), requestValues[0]);
        }
        String valueStr = this.getEffectiveValue();
        if (valueStr != null) {
            ArrayList<String> result = new ArrayList<String>();
            String[] values = valueStr.split(",");
            HashSet<String> valueSet = new HashSet<String>();
            for (String value : values) {
                valueSet.add(value);
            }
            for (String requestValue : requestValues) {
                if (!valueSet.contains(requestValue)) continue;
                result.add(requestValue);
            }
            return new ExtendedChoiceParameterValue(this.getName(), StringUtils.join(result, (String)this.getMultiSelectDelimiter()));
        }
        return null;
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject jO) {
        Object value = jO.get("value");
        String strValue = "";
        if (value instanceof String) {
            strValue = (String)value;
        } else if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            if (this.type.equals(PARAMETER_TYPE_MULTI_LEVEL_SINGLE_SELECT) || this.type.equals(PARAMETER_TYPE_MULTI_LEVEL_MULTI_SELECT)) {
                int valuesBetweenLevels = this.value.split(",").length;
                Iterator it = jsonValues.iterator();
                int i = 1;
                while (it.hasNext()) {
                    String nextValue = it.next().toString();
                    if (i % valuesBetweenLevels == 0) {
                        if (strValue.length() > 0) {
                            strValue = strValue + this.getMultiSelectDelimiter();
                        }
                        strValue = strValue + nextValue;
                    }
                    ++i;
                }
            } else {
                strValue = StringUtils.join((Iterator)jsonValues.iterator(), (String)this.getMultiSelectDelimiter());
            }
        }
        if (this.quoteValue) {
            strValue = "\"" + strValue + "\"";
        }
        return new ExtendedChoiceParameterValue(this.getName(), strValue);
    }

    public ParameterValue getDefaultParameterValue() {
        String defaultValue = this.getEffectiveDefaultValue();
        if (!StringUtils.isBlank((String)defaultValue)) {
            if (this.quoteValue) {
                defaultValue = "\"" + defaultValue + "\"";
            }
            return new ExtendedChoiceParameterValue(this.getName(), defaultValue);
        }
        return super.getDefaultParameterValue();
    }

    private String computeValue(String value, String propertyFilePath, String propertyKey, String groovyScript, String groovyScriptFile, String bindings) {
        if (!StringUtils.isBlank((String)propertyFilePath) && !StringUtils.isBlank((String)propertyKey)) {
            try {
                File propertyFile = new File(propertyFilePath);
                if (propertyFile.exists()) {
                    Project project = new Project();
                    Property property = new Property();
                    property.setProject(project);
                    property.setFile(propertyFile);
                    property.execute();
                    return project.getProperty(propertyKey);
                }
                Project project = new Project();
                Property property = new Property();
                property.setProject(project);
                URL propertyFileUrl = new URL(propertyFilePath);
                property.setUrl(propertyFileUrl);
                property.execute();
                return project.getProperty(propertyKey);
            }
            catch (Exception e) {}
        } else if (!StringUtils.isBlank((String)groovyScript)) {
            try {
                GroovyShell groovyShell = new GroovyShell();
                this.setBindings(groovyShell, bindings);
                return (String)groovyShell.evaluate(groovyScript);
            }
            catch (Exception e) {}
        } else if (!StringUtils.isBlank((String)groovyScriptFile)) {
            try {
                GroovyShell groovyShell = new GroovyShell();
                this.setBindings(groovyShell, bindings);
                groovyScript = Util.loadFile((File)new File(groovyScriptFile));
                return (String)groovyShell.evaluate(groovyScript);
            }
            catch (Exception e) {}
        } else if (!StringUtils.isBlank((String)value)) {
            return value;
        }
        return null;
    }

    private void setBindings(GroovyShell shell, String bindings) throws IOException {
        if (bindings != null) {
            Properties p = new Properties();
            p.load(new StringReader(bindings));
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                shell.setVariable((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEffectiveDefaultValue() {
        return this.computeValue(this.defaultValue, this.defaultPropertyFile, this.defaultPropertyKey, this.defaultGroovyScript, this.defaultGroovyScriptFile, this.defaultBindings);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public String getGroovyScript() {
        return this.groovyScript;
    }

    public void setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
    }

    public String getGroovyScriptFile() {
        return this.groovyScriptFile;
    }

    public void setGroovyScriptFile(String groovyScriptFile) {
        this.groovyScriptFile = groovyScriptFile;
    }

    public String getBindings() {
        return this.bindings;
    }

    public void setBindings(String bindings) {
        this.bindings = bindings;
    }

    public String getDefaultPropertyKey() {
        return this.defaultPropertyKey;
    }

    public void setDefaultPropertyKey(String defaultPropertyKey) {
        this.defaultPropertyKey = defaultPropertyKey;
    }

    public String getEffectiveValue() {
        return this.computeValue(this.value, this.propertyFile, this.propertyKey, this.groovyScript, this.groovyScriptFile, this.bindings);
    }

    private ArrayList<Integer> columnIndicesForDropDowns(String[] headerColumns) {
        String[] dropDownNames;
        ArrayList<Integer> columnIndicesForDropDowns = new ArrayList<Integer>();
        for (String dropDownName : dropDownNames = this.value.split(",")) {
            for (int i = 0; i < headerColumns.length; ++i) {
                if (!headerColumns[i].equals(dropDownName)) continue;
                columnIndicesForDropDowns.add(new Integer(i));
            }
        }
        return columnIndicesForDropDowns;
    }

    LinkedHashMap<String, LinkedHashSet<String>> calculateChoicesByDropdownId() throws Exception {
        List fileLines = new CSVReader((Reader)new FileReader(this.propertyFile), '\t').readAll();
        if (fileLines.size() < 2) {
            throw new Exception("Multi level tab delimited file must have at least 2 lines (one for the header, and one or more for the data)");
        }
        ArrayList<Integer> columnIndicesForDropDowns = this.columnIndicesForDropDowns((String[])fileLines.get(0));
        List dataLines = fileLines.subList(1, fileLines.size());
        LinkedHashMap<String, LinkedHashSet<String>> choicesByDropdownId = new LinkedHashMap<String, LinkedHashSet<String>>();
        String prefix = this.getName() + " dropdown MultiLevelMultiSelect 0";
        choicesByDropdownId.put(prefix, new LinkedHashSet());
        for (int i = 0; i < columnIndicesForDropDowns.size(); ++i) {
            String prettyCurrentColumnName = this.value.split(",")[i];
            prettyCurrentColumnName = prettyCurrentColumnName.toLowerCase();
            prettyCurrentColumnName = prettyCurrentColumnName.replace("_", " ");
            for (String[] dataLine : dataLines) {
                String priorLevelDropdownId = prefix;
                String currentLevelDropdownId = prefix;
                int column = 0;
                for (int j = 0; j <= i; ++j) {
                    column = columnIndicesForDropDowns.get(j);
                    if (j < i) {
                        priorLevelDropdownId = priorLevelDropdownId + " " + dataLine[column];
                    }
                    currentLevelDropdownId = currentLevelDropdownId + " " + dataLine[column];
                }
                if (i != columnIndicesForDropDowns.size() - 1) {
                    choicesByDropdownId.put(currentLevelDropdownId, new LinkedHashSet());
                }
                LinkedHashSet<String> choicesForPriorDropdown = choicesByDropdownId.get(priorLevelDropdownId);
                choicesForPriorDropdown.add("Select a " + prettyCurrentColumnName + "...");
                choicesForPriorDropdown.add(dataLine[column]);
            }
        }
        return choicesByDropdownId;
    }

    public String getMultiLevelDropdownIds() throws Exception {
        String dropdownIds = new String();
        LinkedHashMap<String, LinkedHashSet<String>> choicesByDropdownId = this.calculateChoicesByDropdownId();
        for (String id : choicesByDropdownId.keySet()) {
            if (dropdownIds.length() > 0) {
                dropdownIds = dropdownIds + ",";
            }
            dropdownIds = dropdownIds + id;
        }
        return dropdownIds;
    }

    public Map<String, String> getChoicesByDropdownId() throws Exception {
        LinkedHashMap<String, LinkedHashSet<String>> choicesByDropdownId = this.calculateChoicesByDropdownId();
        LinkedHashMap<String, String> collapsedMap = new LinkedHashMap<String, String>();
        for (String dropdownId : choicesByDropdownId.keySet()) {
            String choices = new String();
            for (String choice : choicesByDropdownId.get(dropdownId)) {
                if (choices.length() > 0) {
                    choices = choices + ",";
                }
                choices = choices + choice;
            }
            collapsedMap.put(dropdownId, choices);
        }
        return collapsedMap;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public void setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public String getDefaultPropertyFile() {
        return this.defaultPropertyFile;
    }

    public String getDefaultGroovyScript() {
        return this.defaultGroovyScript;
    }

    public void setDefaultGroovyScript(String defaultGroovyScript) {
        this.defaultGroovyScript = defaultGroovyScript;
    }

    public String getDefaultGroovyScriptFile() {
        return this.defaultGroovyScriptFile;
    }

    public void setDefaultGroovyScriptFile(String defaultGroovyScriptFile) {
        this.defaultGroovyScriptFile = defaultGroovyScriptFile;
    }

    public String getDefaultBindings() {
        return this.defaultBindings;
    }

    public void setDefaultBindings(String defaultBindings) {
        this.defaultBindings = defaultBindings;
    }

    public boolean isQuoteValue() {
        return this.quoteValue;
    }

    public void setQuoteValue(boolean quoteValue) {
        this.quoteValue = quoteValue;
    }

    public int getVisibleItemCount() {
        return this.visibleItemCount;
    }

    public void setVisibleItemCount(int visibleItemCount) {
        this.visibleItemCount = visibleItemCount;
    }

    public String getMultiSelectDelimiter() {
        return this.multiSelectDelimiter;
    }

    public void setMultiSelectDelimiter(String multiSelectDelimiter) {
        this.multiSelectDelimiter = multiSelectDelimiter;
    }

    public void setDefaultPropertyFile(String defaultPropertyFile) {
        this.defaultPropertyFile = defaultPropertyFile;
    }

    public Map<String, Boolean> getDefaultValueMap() {
        return this.computeDefaultValueMap();
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return Messages.ExtendedChoiceParameterDefinition_DisplayName();
        }

        public FormValidation doCheckPropertyFile(@QueryParameter String propertyFile, @QueryParameter String propertyKey, @RelativePath(value="..") @QueryParameter String type) throws IOException, ServletException {
            if (StringUtils.isBlank((String)propertyFile)) {
                return FormValidation.ok();
            }
            Project project = new Project();
            Property property = new Property();
            property.setProject(project);
            File prop = new File(propertyFile);
            try {
                if (prop.exists()) {
                    property.setFile(prop);
                } else {
                    URL propertyFileUrl = new URL(propertyFile);
                    property.setUrl(propertyFileUrl);
                }
                property.execute();
            }
            catch (Exception e) {
                return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileDoesntExist(), (Object[])new Object[]{propertyFile});
            }
            if (ExtendedChoiceParameterDefinition.PARAMETER_TYPE_MULTI_LEVEL_SINGLE_SELECT.equals(type) || ExtendedChoiceParameterDefinition.PARAMETER_TYPE_MULTI_LEVEL_MULTI_SELECT.equals(type)) {
                return FormValidation.ok();
            }
            if (StringUtils.isNotBlank((String)propertyKey)) {
                if (project.getProperty(propertyKey) != null) {
                    return FormValidation.ok();
                }
                return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileExistsButProvidedKeyIsInvalid(), (Object[])new Object[]{propertyFile, propertyKey});
            }
            return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileExistsButNoProvidedKey(), (Object[])new Object[]{propertyFile});
        }

        public FormValidation doCheckPropertyKey(@QueryParameter String propertyFile, @QueryParameter String propertyKey, @RelativePath(value="..") @QueryParameter String type) throws IOException, ServletException {
            return this.doCheckPropertyFile(propertyFile, propertyKey, type);
        }

        public FormValidation doCheckDefaultPropertyFile(@QueryParameter String defaultPropertyFile, @QueryParameter String defaultPropertyKey, @RelativePath(value="..") @QueryParameter String type) throws IOException, ServletException {
            return this.doCheckPropertyFile(defaultPropertyFile, defaultPropertyKey, type);
        }

        public FormValidation doCheckDefaultPropertyKey(@QueryParameter String defaultPropertyFile, @QueryParameter String defaultPropertyKey, @RelativePath(value="..") @QueryParameter String type) throws IOException, ServletException {
            return this.doCheckPropertyFile(defaultPropertyFile, defaultPropertyKey, type);
        }

        public ExtendedChoiceParameterDefinition newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String name = null;
            String type = null;
            String description = null;
            String multiSelectDelimiter = null;
            boolean quoteValue = false;
            int visibleItemCount = 5;
            String propertyValue = null;
            String propertyKey = null;
            String propertyFile = null;
            String groovyScript = null;
            String groovyScriptFile = null;
            String bindings = null;
            String defaultPropertyValue = null;
            String defaultPropertyKey = null;
            String defaultPropertyFile = null;
            String defaultGroovyScript = null;
            String defaultGroovyScriptFile = null;
            String defaultBindings = null;
            name = formData.getString("name");
            type = formData.getString("type");
            description = formData.getString("description");
            quoteValue = formData.getBoolean("quoteValue");
            visibleItemCount = formData.optInt("visibleItemCount");
            multiSelectDelimiter = formData.getString("multiSelectDelimiter");
            JSONObject propertySourceJSON = (JSONObject)formData.get("propertySource");
            if (propertySourceJSON != null) {
                if (propertySourceJSON.getInt("value") == 0) {
                    propertyValue = propertySourceJSON.getString("propertyValue");
                } else if (propertySourceJSON.getInt("value") == 1) {
                    propertyFile = propertySourceJSON.getString("propertyFile");
                    propertyKey = propertySourceJSON.getString("propertyKey");
                } else if (propertySourceJSON.getInt("value") == 2) {
                    groovyScript = propertySourceJSON.getString("groovyScript");
                    bindings = propertySourceJSON.getString("bindings");
                } else if (propertySourceJSON.getInt("value") == 3) {
                    groovyScriptFile = propertySourceJSON.getString("groovyScriptFile");
                    bindings = propertySourceJSON.getString("bindings");
                }
            } else {
                propertyFile = formData.getString("propertyFile");
                propertyKey = formData.getString("propertyKey");
                propertyValue = formData.optString("value");
            }
            JSONObject defaultPropertySourceJSON = (JSONObject)formData.get("defaultPropertySource");
            if (defaultPropertySourceJSON != null) {
                if (defaultPropertySourceJSON.getInt("value") == 0) {
                    defaultPropertyValue = defaultPropertySourceJSON.getString("defaultPropertyValue");
                } else if (defaultPropertySourceJSON.getInt("value") == 1) {
                    defaultPropertyFile = defaultPropertySourceJSON.getString("defaultPropertyFile");
                    defaultPropertyKey = defaultPropertySourceJSON.getString("defaultPropertyKey");
                } else if (defaultPropertySourceJSON.getInt("value") == 2) {
                    defaultGroovyScript = defaultPropertySourceJSON.getString("defaultGroovyScript");
                    defaultBindings = defaultPropertySourceJSON.getString("defaultBindings");
                } else if (defaultPropertySourceJSON.getInt("value") == 3) {
                    defaultGroovyScriptFile = defaultPropertySourceJSON.getString("defaultGroovyScriptFile");
                    defaultBindings = defaultPropertySourceJSON.getString("defaultBindings");
                }
            } else {
                defaultPropertyFile = formData.getString("defaultPropertyFile");
                defaultPropertyKey = formData.getString("defaultPropertyKey");
                defaultPropertyValue = formData.optString("defaultValue");
            }
            return new ExtendedChoiceParameterDefinition(name, type, propertyValue, propertyFile, groovyScript, groovyScriptFile, bindings, propertyKey, defaultPropertyValue, defaultPropertyFile, defaultGroovyScript, defaultGroovyScriptFile, defaultBindings, defaultPropertyKey, quoteValue, visibleItemCount, description, multiSelectDelimiter);
        }
    }
}

