/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.environmentdashboard;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.environmentdashboard.ListItem;
import org.jenkinsci.plugins.environmentdashboard.utils.DBConnection;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class DashboardBuilder
extends BuildWrapper {
    private final String nameOfEnv;
    private final String componentName;
    private final String buildNumber;
    private final String buildJob;
    private final String packageName;
    private ArrayList<ListItem> data = new ArrayList();
    public boolean addColumns = false;

    @DataBoundConstructor
    public DashboardBuilder(String nameOfEnv, String componentName, String buildNumber, String buildJob, String packageName, boolean addColumns, ArrayList<ListItem> data) {
        this.nameOfEnv = nameOfEnv;
        this.componentName = componentName;
        this.buildNumber = buildNumber;
        this.buildJob = buildJob;
        this.packageName = packageName;
        this.addColumns = addColumns ? addColumns : false;
        if (this.addColumns) {
            for (ListItem i : data) {
                if (i.getColumnName().isEmpty()) continue;
                this.data.add(i);
            }
        }
    }

    public String getNameOfEnv() {
        return this.nameOfEnv;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getBuildJob() {
        return this.buildJob;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<ListItem> getData() {
        return this.data;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        final Integer numberOfDays = this.getDescriptor().getNumberOfDays() == null ? 30 : this.getDescriptor().getNumberOfDays();
        String passedBuildNumber = build.getEnvironment((TaskListener)listener).expand(this.buildNumber);
        String passedEnvName = build.getEnvironment((TaskListener)listener).expand(this.nameOfEnv);
        String passedCompName = build.getEnvironment((TaskListener)listener).expand(this.componentName);
        String passedBuildJob = build.getEnvironment((TaskListener)listener).expand(this.buildJob);
        String passedPackageName = build.getEnvironment((TaskListener)listener).expand(this.packageName);
        ArrayList<ListItem> passedColumnData = new ArrayList<ListItem>();
        if (this.addColumns) {
            for (ListItem item : this.data) {
                passedColumnData.add(new ListItem(build.getEnvironment((TaskListener)listener).expand(item.columnName), build.getEnvironment((TaskListener)listener).expand(item.contents)));
            }
        }
        String returnComment = null;
        if (passedPackageName == null) {
            passedPackageName = "";
        }
        if (!(passedBuildNumber.matches("^\\s*$") || passedEnvName.matches("^\\s*$") || passedCompName.matches("^\\s*$"))) {
            returnComment = this.writeToDB(build, listener, passedEnvName, passedCompName, passedBuildNumber, "PRE", passedBuildJob, numberOfDays, passedPackageName, passedColumnData);
            listener.getLogger().println("Pre-Build Update: " + returnComment);
        } else {
            listener.getLogger().println("Environment dashboard not updated: one or more required values were blank");
        }
        class TearDownImpl
        extends BuildWrapper.Environment {
            TearDownImpl() {
                super((BuildWrapper)DashboardBuilder.this);
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                String passedBuildNumber = build.getEnvironment((TaskListener)listener).expand(DashboardBuilder.this.buildNumber);
                String passedEnvName = build.getEnvironment((TaskListener)listener).expand(DashboardBuilder.this.nameOfEnv);
                String passedCompName = build.getEnvironment((TaskListener)listener).expand(DashboardBuilder.this.componentName);
                String passedBuildJob = build.getEnvironment((TaskListener)listener).expand(DashboardBuilder.this.buildJob);
                String passedPackageName = build.getEnvironment((TaskListener)listener).expand(DashboardBuilder.this.packageName);
                String doDeploy = build.getEnvironment((TaskListener)listener).expand("$UPDATE_ENV_DASH");
                List passedColumnData = Collections.emptyList();
                String returnComment = null;
                if (passedPackageName == null) {
                    passedPackageName = "";
                }
                if (doDeploy == null || !doDeploy.equals("true") && !doDeploy.equals("false")) {
                    doDeploy = "true";
                }
                if (doDeploy.equals("true")) {
                    if (!(passedBuildNumber.matches("^\\s*$") || passedEnvName.matches("^\\s*$") || passedCompName.matches("^\\s*$"))) {
                        returnComment = DashboardBuilder.this.writeToDB(build, listener, passedEnvName, passedCompName, passedBuildNumber, "POST", passedBuildJob, numberOfDays, passedPackageName, passedColumnData);
                        listener.getLogger().println("Post-Build Update: " + returnComment);
                    }
                } else if (!(passedBuildNumber.matches("^\\s*$") || passedEnvName.matches("^\\s*$") || passedCompName.matches("^\\s*$"))) {
                    returnComment = DashboardBuilder.this.writeToDB(build, listener, passedEnvName, passedCompName, passedBuildNumber, "NODEPLOY", passedBuildJob, numberOfDays, passedPackageName, passedColumnData);
                    listener.getLogger().println("Post-Build Update: " + returnComment);
                }
                return super.tearDown(build, listener);
            }
        }
        return new TearDownImpl();
    }

    private String writeToDB(AbstractBuild build, BuildListener listener, String envName, String compName, String currentBuildNum, String runTime, String buildJob, Integer numberOfDays, String packageName, List<ListItem> passedColumnData) {
        String returnComment = null;
        if (envName.matches("^\\s*$") || compName.matches("^\\s*$")) {
            returnComment = "WARN: Either Environment name or Component name is empty.";
            return returnComment;
        }
        Connection conn = DBConnection.getConnection();
        Statement stat = null;
        try {
            stat = conn.createStatement();
        }
        catch (SQLException e) {
            returnComment = "WARN: Could not execute statement.";
            return returnComment;
        }
        try {
            stat.execute("CREATE TABLE IF NOT EXISTS env_dashboard (envComp VARCHAR(255), jobUrl VARCHAR(255), buildNum VARCHAR(255), buildStatus VARCHAR(255), envName VARCHAR(255), compName VARCHAR(255), created_at TIMESTAMP,  buildJobUrl VARCHAR(255), packageName VARCHAR(255));");
        }
        catch (SQLException e) {
            returnComment = "WARN: Could not create table env_dashboard.";
            return returnComment;
        }
        try {
            stat.execute("ALTER TABLE env_dashboard ADD IF NOT EXISTS packageName VARCHAR(255);");
        }
        catch (SQLException e) {
            returnComment = "WARN: Could not alter table env_dashboard.";
            return returnComment;
        }
        String columns = "";
        String contents = "";
        for (ListItem item : passedColumnData) {
            columns = columns + ", " + item.columnName;
            contents = contents + "', '" + item.contents;
            try {
                stat.execute("ALTER TABLE env_dashboard ADD IF NOT EXISTS " + item.columnName + " VARCHAR;");
            }
            catch (SQLException e) {
                returnComment = "WARN: Could not alter table env_dashboard to add column " + item.columnName + ".";
                return returnComment;
            }
        }
        String indexValueofTable = envName + '=' + compName;
        String currentBuildResult = "UNKNOWN";
        currentBuildResult = build.getResult() == null && runTime.equals("PRE") ? "RUNNING" : (build.getResult() == null && runTime.equals("POST") ? "SUCCESS" : (runTime.equals("NODEPLOY") ? "NODEPLOY" : build.getResult().toString()));
        String currentBuildUrl = build.getUrl();
        String buildJobUrl = buildJob.isEmpty() ? "" : "job/" + buildJob + "/" + currentBuildNum;
        String runQuery = null;
        if (runTime.equals("PRE")) {
            runQuery = "INSERT INTO env_dashboard (envComp, jobUrl, buildNum, buildStatus, envName, compName, created_at, buildJobUrl, packageName" + columns + ") VALUES( '" + indexValueofTable + "', '" + currentBuildUrl + "', '" + currentBuildNum + "', '" + currentBuildResult + "', '" + envName + "', '" + compName + "' , + current_timestamp, '" + buildJobUrl + "' , '" + packageName + contents + "');";
        } else if (runTime.equals("POST")) {
            runQuery = "UPDATE env_dashboard SET buildStatus = '" + currentBuildResult + "', created_at = current_timestamp WHERE envComp = '" + indexValueofTable + "' AND joburl = '" + currentBuildUrl + "';";
        } else if (runTime.equals("NODEPLOY")) {
            runQuery = "DELETE FROM env_dashboard where envComp = '" + indexValueofTable + "' AND joburl = '" + currentBuildUrl + "';";
        }
        try {
            stat.execute(runQuery);
        }
        catch (SQLException e) {
            returnComment = "Error running query " + runQuery + ".";
            return returnComment;
        }
        if (numberOfDays > 0) {
            runQuery = "DELETE FROM env_dashboard where created_at <= current_timestamp - " + numberOfDays;
            try {
                stat.execute(runQuery);
            }
            catch (SQLException e) {
                returnComment = "Error running delete query " + runQuery + ".";
                return returnComment;
            }
        }
        try {
            stat.close();
            conn.close();
        }
        catch (SQLException e) {
            returnComment = "Error closing connection.";
            return returnComment;
        }
        return "Updated Dashboard DB";
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private String numberOfDays = "30";
        private Integer parseNumberOfDays;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Details for Environment dashboard";
        }

        public FormValidation doCheckNameOfEnv(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set an Environment name.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckComponentName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a Component name.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBuildNumber(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the Build variable e.g: ${BUILD_NUMBER}.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNumberOfDays(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the number of days to retain the DB data.");
            }
            try {
                this.parseNumberOfDays = Integer.parseInt(value);
            }
            catch (Exception parseEx) {
                return FormValidation.error((String)"Please provide an integer value.");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.numberOfDays = formData.getString("numberOfDays");
            if (this.numberOfDays == null || this.numberOfDays.equals("")) {
                this.numberOfDays = "30";
            }
            this.save();
            return super.configure(req, formData);
        }

        public Integer getNumberOfDays() {
            return this.parseNumberOfDays;
        }
    }
}

