/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.PasswordParameterValue;
import hudson.model.Run;
import hudson.tasks.BuildWrapper;
import hudson.util.DescribableList;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectGlobalPasswordEntry;
import org.jenkinsci.plugins.envinject.EnvInjectPasswordEntry;
import org.jenkinsci.plugins.envinject.EnvInjectPasswordWrapper;
import org.jenkinsci.plugins.envinject.service.EnvInjectGlobalPasswordRetriever;

public class EnvInjectPasswordsMasker
implements Serializable {
    @Deprecated
    public void maskPasswordsIfAny(@Nonnull AbstractBuild run, @Nonnull EnvInjectLogger logger, @Nonnull Map<String, String> envVars) {
        this.maskPasswordParametersIfAny((Run<?, ?>)run, envVars, logger);
    }

    public void maskPasswordParametersIfAny(@Nonnull Run<?, ?> run, @Nonnull Map<String, String> envVars, @Nonnull EnvInjectLogger logger) {
        this.maskPasswordsJobParameterIfAny(run, logger, envVars);
        this.maskPasswordsEnvInjectIfAny(run, logger, envVars);
    }

    private void maskPasswordsJobParameterIfAny(@Nonnull Run<?, ?> run, @Nonnull EnvInjectLogger logger, @Nonnull Map<String, String> envVarsTarget) {
        List parameters;
        ParametersAction parametersAction = (ParametersAction)run.getAction(ParametersAction.class);
        if (parametersAction != null && (parameters = parametersAction.getParameters()) != null) {
            for (ParameterValue parameter : parameters) {
                if (!(parameter instanceof PasswordParameterValue)) continue;
                PasswordParameterValue passwordParameterValue = (PasswordParameterValue)parameter;
                envVarsTarget.put(passwordParameterValue.getName(), passwordParameterValue.getValue().getEncryptedValue());
            }
        }
    }

    private void maskPasswordsEnvInjectIfAny(@Nonnull Run<?, ?> build, @Nonnull EnvInjectLogger logger, @Nonnull Map<String, String> envVars) {
        try {
            EnvInjectPasswordWrapper envInjectPasswordWrapper = this.getEnvInjectPasswordWrapper(build);
            if (envInjectPasswordWrapper == null) {
                return;
            }
            if (envInjectPasswordWrapper.isInjectGlobalPasswords()) {
                this.maskGlobalPasswords(envVars);
            }
            this.maskJobPasswords(envVars, envInjectPasswordWrapper.getPasswordEntryList());
        }
        catch (EnvInjectException ee) {
            logger.error("Can't mask global password :" + ee.getMessage());
        }
    }

    @CheckForNull
    private EnvInjectPasswordWrapper getEnvInjectPasswordWrapper(@Nonnull Run<?, ?> build) throws EnvInjectException {
        DescribableList wrappersProject;
        if (build instanceof MatrixRun) {
            MatrixProject project = (MatrixProject)((MatrixRun)build).getParentBuild().getProject();
            wrappersProject = project.getBuildWrappersList();
        } else {
            Job job = build.getParent();
            if (job instanceof BuildableItemWithBuildWrappers) {
                BuildableItemWithBuildWrappers project = (BuildableItemWithBuildWrappers)job;
                wrappersProject = project.getBuildWrappersList();
            } else {
                throw new EnvInjectException(String.format("Job type %s is not supported", job));
            }
        }
        for (BuildWrapper buildWrapper : wrappersProject) {
            if (!EnvInjectPasswordWrapper.class.equals(buildWrapper.getClass())) continue;
            return (EnvInjectPasswordWrapper)buildWrapper;
        }
        return null;
    }

    private void maskGlobalPasswords(Map<String, String> envVarsTarget) throws EnvInjectException {
        EnvInjectGlobalPasswordRetriever globalPasswordRetriever = new EnvInjectGlobalPasswordRetriever();
        EnvInjectGlobalPasswordEntry[] globalPasswordEntries = globalPasswordRetriever.getGlobalPasswords();
        if (globalPasswordEntries != null) {
            for (EnvInjectGlobalPasswordEntry globalPasswordEntry : globalPasswordEntries) {
                envVarsTarget.put(globalPasswordEntry.getName(), globalPasswordEntry.getValue().getEncryptedValue());
            }
        }
    }

    private void maskJobPasswords(@Nonnull Map<String, String> envVarsTarget, @Nonnull List<EnvInjectPasswordEntry> passwordEntries) {
        for (EnvInjectPasswordEntry passwordEntry : passwordEntries) {
            envVarsTarget.put(passwordEntry.getName(), passwordEntry.getValue().getEncryptedValue());
        }
    }
}

