/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Run;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.EnvInjectPluginAction;
import org.jenkinsci.plugins.envinject.util.RunHelper;

public class EnvInjectActionSetter
implements Serializable {
    @CheckForNull
    private FilePath rootPath;

    public EnvInjectActionSetter(@CheckForNull FilePath rootPath) {
        this.rootPath = rootPath;
    }

    @Deprecated
    public void addEnvVarsToEnvInjectBuildAction(@Nonnull AbstractBuild<?, ?> build, @CheckForNull Map<String, String> envMap) throws EnvInjectException, IOException, InterruptedException {
        this.addEnvVarsToRun((Run<?, ?>)build, envMap);
    }

    public void addEnvVarsToRun(@Nonnull Run<?, ?> run, @CheckForNull Map<String, String> envMap) throws EnvInjectException, IOException, InterruptedException {
        EnvInjectPluginAction envInjectAction = (EnvInjectPluginAction)run.getAction(EnvInjectPluginAction.class);
        if (envInjectAction != null) {
            envInjectAction.overrideAll(RunHelper.getSensitiveBuildVariables(run), envMap);
        } else if (this.rootPath != null) {
            envInjectAction = new EnvInjectPluginAction((Map)this.rootPath.act((Callable)new MapEnvInjectExceptionMasterToSlaveCallable()));
            envInjectAction.overrideAll(RunHelper.getSensitiveBuildVariables(run), envMap);
            run.addAction((Action)envInjectAction);
        }
    }

    private static class MapEnvInjectExceptionMasterToSlaveCallable
    extends MasterToSlaveCallable<Map<String, String>, EnvInjectException> {
        private static final long serialVersionUID = 1L;

        private MapEnvInjectExceptionMasterToSlaveCallable() {
        }

        public Map<String, String> call() throws EnvInjectException {
            HashMap<String, String> result = new HashMap<String, String>();
            result.putAll(EnvVars.masterEnvVars);
            return result;
        }
    }
}

