/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.ComputerListener;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.util.DescribableList;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectNodeProperty;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVars;
import org.jenkinsci.plugins.envinject.service.EnvInjectMasterEnvVarsSetter;

@Extension
public class EnvInjectComputerListener
extends ComputerListener
implements Serializable {
    private EnvVars getNewMasterEnvironmentVariables(@Nonnull Computer c, @Nonnull FilePath nodePath, @Nonnull TaskListener listener) throws EnvInjectException, IOException, InterruptedException {
        Map nodeEnvVars = (Map)nodePath.act((Callable)new MasterToSlaveCallable<Map<String, String>, IOException>(){

            public Map<String, String> call() throws IOException {
                return EnvVars.masterEnvVars;
            }
        });
        EnvInjectLogger logger = new EnvInjectLogger(listener);
        EnvInjectEnvVars envInjectEnvVarsService = new EnvInjectEnvVars(logger);
        boolean unsetSystemVariables = false;
        HashMap<String, String> globalPropertiesEnvVars = new HashMap<String, String>();
        for (NodeProperty nodeProperty : Jenkins.getActiveInstance().getGlobalNodeProperties()) {
            Node node;
            if (nodeProperty instanceof EnvironmentVariablesNodeProperty) {
                globalPropertiesEnvVars.putAll((Map<String, String>)((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars());
            }
            if ((node = c.getNode()) == null || !(nodeProperty instanceof EnvInjectNodeProperty)) continue;
            EnvInjectNodeProperty envInjectNodeProperty = (EnvInjectNodeProperty)nodeProperty;
            unsetSystemVariables = envInjectNodeProperty.isUnsetSystemVariables();
            FilePath rootPath = node.getRootPath();
            if (rootPath == null) {
                throw new EnvInjectException("Node is offline, cannot calculate the injected variables");
            }
            globalPropertiesEnvVars.putAll(envInjectEnvVarsService.getEnvVarsFileProperty(rootPath, logger, envInjectNodeProperty.getPropertiesFilePath(), null, nodeEnvVars));
        }
        envInjectEnvVarsService.resolveVars(globalPropertiesEnvVars, nodeEnvVars);
        EnvVars envVars2Set = new EnvVars();
        if (!unsetSystemVariables) {
            envVars2Set.putAll(nodeEnvVars);
        }
        envVars2Set.putAll(globalPropertiesEnvVars);
        return envVars2Set;
    }

    private EnvVars getNewSlaveEnvironmentVariables(@Nonnull Computer c, @Nonnull FilePath nodePath, @Nonnull TaskListener listener) throws EnvInjectException, IOException, InterruptedException {
        HashMap<String, String> currentEnvVars = new HashMap<String, String>();
        EnvInjectLogger logger = new EnvInjectLogger(listener);
        EnvInjectEnvVars envInjectEnvVarsService = new EnvInjectEnvVars(logger);
        Node node = c.getNode();
        if (node == null) {
            throw new EnvInjectException("Node is removed, but the computer has not gone yet");
        }
        Map nodeEnvVars = (Map)nodePath.act((Callable)new MasterToSlaveCallable<Map<String, String>, IOException>(){

            public Map<String, String> call() throws IOException {
                return EnvVars.masterEnvVars;
            }
        });
        boolean unsetSystemVariables = false;
        for (NodeProperty nodeProperty : node.getNodeProperties()) {
            if (nodeProperty instanceof EnvironmentVariablesNodeProperty) {
                currentEnvVars.putAll((Map<String, String>)((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars());
            }
            if (!(nodeProperty instanceof EnvInjectNodeProperty)) continue;
            EnvInjectNodeProperty envInjectNodeProperty = (EnvInjectNodeProperty)nodeProperty;
            unsetSystemVariables = envInjectNodeProperty.isUnsetSystemVariables();
            FilePath rootPath = node.getRootPath();
            if (rootPath == null) {
                throw new EnvInjectException("Node is offline, cannot calculate the injected variables");
            }
            currentEnvVars.putAll(envInjectEnvVarsService.getEnvVarsFileProperty(rootPath, logger, envInjectNodeProperty.getPropertiesFilePath(), null, nodeEnvVars));
        }
        envInjectEnvVarsService.resolveVars(currentEnvVars, nodeEnvVars);
        EnvVars envVars2Set = new EnvVars();
        if (!unsetSystemVariables) {
            envVars2Set.putAll(nodeEnvVars);
        }
        envVars2Set.putAll(currentEnvVars);
        return envVars2Set;
    }

    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        FilePath nodePath;
        Node node = c.getNode();
        FilePath filePath = nodePath = node != null ? node.getRootPath() : null;
        if (nodePath == null) {
            return;
        }
        if (this.isActiveSlave(c)) {
            try {
                EnvVars envVars2Set = this.getNewSlaveEnvironmentVariables(c, nodePath, listener);
                nodePath.act((Callable)new EnvInjectMasterEnvVarsSetter(envVars2Set));
            }
            catch (EnvInjectException e) {
                throw new IOException(e);
            }
        }
        if (this.isGlobalEnvInjectActivatedOnMaster()) {
            try {
                EnvVars envVars2Set = this.getNewMasterEnvironmentVariables(c, nodePath, listener);
                nodePath.act((Callable)new EnvInjectMasterEnvVarsSetter(envVars2Set));
            }
            catch (EnvInjectException e) {
                throw new IOException(e);
            }
        }
    }

    private boolean isActiveSlave(@CheckForNull Computer c) {
        if (c == null) {
            return false;
        }
        Node slave = Jenkins.getActiveInstance().getNode(c.getName());
        return slave != null;
    }

    private boolean isGlobalEnvInjectActivatedOnMaster() {
        DescribableList globalNodeProperties = Jenkins.getActiveInstance().getGlobalNodeProperties();
        for (NodeProperty nodeProperty : globalNodeProperties) {
            if (!(nodeProperty instanceof EnvInjectNodeProperty)) continue;
            return true;
        }
        return false;
    }
}

