/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.EnvironmentContributingAction;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class EnvInjectBuilderContributionAction
implements EnvironmentContributingAction {
    public static final String ENVINJECT_BUILDER_ACTION_NAME = "EnvInjectBuilderAction";
    @CheckForNull
    private transient Map<String, String> resultVariables;

    public EnvInjectBuilderContributionAction(@CheckForNull Map<String, String> resultVariables) {
        this.resultVariables = resultVariables;
    }

    public void buildEnvVars(@Nonnull AbstractBuild<?, ?> build, @CheckForNull EnvVars envVars) {
        if (envVars == null) {
            return;
        }
        if (this.resultVariables == null) {
            return;
        }
        for (Map.Entry<String, String> entry : this.resultVariables.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || value == null) continue;
            envVars.put(key, value);
        }
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return ENVINJECT_BUILDER_ACTION_NAME;
    }

    public String getUrlName() {
        return null;
    }
}

