/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.XmlFile;
import hudson.model.Descriptor;
import java.io.File;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.EnvInjectPlugin;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class EnvInjectPluginConfiguration
extends GlobalConfiguration {
    private static final EnvInjectPluginConfiguration DEFAULT = new EnvInjectPluginConfiguration(false, false);
    private boolean hideInjectedVars;
    private boolean enablePermissions;
    private boolean enableLoadingFromMaster;

    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.0")
    public EnvInjectPluginConfiguration() {
        this.load();
    }

    @Deprecated
    public EnvInjectPluginConfiguration(boolean hideInjectedVars, boolean enablePermissions) {
        this(hideInjectedVars, enablePermissions, false);
    }

    EnvInjectPluginConfiguration(boolean hideInjectedVars, boolean enablePermissions, boolean enableLoadingFromMaster) {
        this.hideInjectedVars = hideInjectedVars;
        this.enablePermissions = enablePermissions;
        this.enableLoadingFromMaster = enableLoadingFromMaster;
    }

    public boolean isHideInjectedVars() {
        return this.hideInjectedVars;
    }

    public boolean isEnablePermissions() {
        return this.enablePermissions;
    }

    public boolean isEnableLoadingFromMaster() {
        return this.enableLoadingFromMaster;
    }

    @Nonnull
    public static final EnvInjectPluginConfiguration getDefault() {
        return DEFAULT;
    }

    protected XmlFile getConfigFile() {
        return new XmlFile(Jenkins.XSTREAM, new File(Jenkins.getActiveInstance().getRootDir(), "envinject-plugin-configuration.xml"));
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        boolean newEnablePermissions = json.getBoolean("enablePermissions");
        boolean newHideInjectedVars = json.getBoolean("hideInjectedVars");
        boolean enableLoadingFromMaster = json.getBoolean("enableLoadingFromMaster");
        return EnvInjectPluginConfiguration.configure(newHideInjectedVars, newEnablePermissions, enableLoadingFromMaster);
    }

    @VisibleForTesting
    static boolean configure(boolean hideInjectedVars, boolean enablePermissions, boolean enableLoadingFromMaster) {
        EnvInjectPluginConfiguration instance = EnvInjectPluginConfiguration.getInstance();
        if (instance == null) {
            throw new IllegalStateException("Cannot retrieve the plugin config instance");
        }
        instance.hideInjectedVars = hideInjectedVars;
        instance.enablePermissions = enablePermissions;
        instance.enableLoadingFromMaster = enableLoadingFromMaster;
        EnvInjectPlugin.getInstance().onConfigChange(instance);
        instance.save();
        return true;
    }

    @CheckForNull
    public static EnvInjectPluginConfiguration getInstance() {
        return (EnvInjectPluginConfiguration)((Object)EnvInjectPluginConfiguration.all().get(EnvInjectPluginConfiguration.class));
    }

    @Nonnull
    public static EnvInjectPluginConfiguration getOrFail() throws EnvInjectException {
        EnvInjectPluginConfiguration c = (EnvInjectPluginConfiguration)((Object)EnvInjectPluginConfiguration.all().get(EnvInjectPluginConfiguration.class));
        if (c == null) {
            throw new EnvInjectException("Cannot retrieve the EnvInject plugin configuration");
        }
        return c;
    }

    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }
}

