/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.Plugin;
import hudson.model.Run;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.envinject.EnvInjectPluginConfiguration;
import org.jenkinsci.plugins.envinject.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class EnvInjectPlugin
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(EnvInjectPlugin.class.getName());
    public static final PermissionGroup PERMISSIONS = new PermissionGroup(EnvInjectPlugin.class, Messages._envinject_permissions_title());
    public static final String DEFAULT_MASK = "[*******]";
    public static final Permission VIEW_INJECTED_VARS = new Permission(PERMISSIONS, "ViewVars", Messages._envinject_permissions_viewVars_description(), null, PermissionScope.RUN);

    @Nonnull
    public static EnvInjectPlugin getInstance() {
        EnvInjectPlugin plugin = (EnvInjectPlugin)Jenkins.getActiveInstance().getPlugin(EnvInjectPlugin.class);
        if (plugin == null) {
            throw new IllegalStateException("Cannot get the plugin's instance. Jenkins or the plugin have not been initialized yet");
        }
        return plugin;
    }

    void onConfigChange(@Nonnull EnvInjectPluginConfiguration config) {
        VIEW_INJECTED_VARS.setEnabled(config.isEnablePermissions());
    }

    @Nonnull
    public EnvInjectPluginConfiguration getConfiguration() {
        EnvInjectPluginConfiguration config = EnvInjectPluginConfiguration.getInstance();
        return config != null ? config : EnvInjectPluginConfiguration.getDefault();
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean canViewInjectedVars(@Nonnull Run<?, ?> run) {
        if (VIEW_INJECTED_VARS.getEnabled() && !run.hasPermission(VIEW_INJECTED_VARS)) {
            return false;
        }
        EnvInjectPluginConfiguration configuration = EnvInjectPlugin.getInstance().getConfiguration();
        return !configuration.isHideInjectedVars();
    }

    public void start() throws Exception {
        VIEW_INJECTED_VARS.setEnabled(this.getConfiguration().isEnablePermissions());
    }
}

