/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import hudson.FilePath;
import hudson.Util;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.service.PropertiesGetter;
import org.jenkinsci.plugins.envinject.service.PropertiesLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesVariablesRetriever
implements FilePath.FileCallable<Map<String, String>> {
    private String propertiesFilePath;
    private Map<String, String> propertiesContent;
    private Map<String, String> currentEnvVars;
    private EnvInjectLogger logger;

    public PropertiesVariablesRetriever(String propertiesFilePath, Map<String, String> propertiesContent, Map<String, String> currentEnvVars, EnvInjectLogger logger) {
        this.propertiesFilePath = propertiesFilePath;
        this.propertiesContent = propertiesContent;
        this.currentEnvVars = currentEnvVars;
        this.logger = logger;
    }

    public Map<String, String> invoke(File base, VirtualChannel channel) throws IOException, InterruptedException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            PropertiesLoader loader = new PropertiesLoader();
            if (this.propertiesFilePath != null) {
                String propertiesFilePathResolved = Util.replaceMacro((String)this.propertiesFilePath, this.currentEnvVars);
                File propertiesFile = this.getFile(base, propertiesFilePathResolved = propertiesFilePathResolved.replace("\\", "/"));
                if (propertiesFile == null) {
                    String message = String.format("The given properties file path '%s' doesn't exist.", propertiesFilePathResolved);
                    this.logger.error(message);
                    String patternMessage = String.format("Missing file path was resolved from pattern '%s' .", this.propertiesFilePath);
                    this.logger.error(patternMessage);
                    throw new EnvInjectException(message);
                }
                this.logger.info(String.format("Injecting as environment variables the properties file path '%s'", propertiesFilePathResolved));
                result.putAll(loader.getVarsFromPropertiesFile(propertiesFile, this.currentEnvVars));
                this.logger.info("Variables injected successfully.");
            }
            if (this.propertiesContent != null) {
                PropertiesGetter propertiesGetter = new PropertiesGetter();
                this.logger.info(String.format("Injecting as environment variables the properties content \n%s\n", propertiesGetter.getPropertiesContentFromMapObject(this.propertiesContent)));
                result.putAll(this.propertiesContent);
                this.logger.info("Variables injected successfully.");
            }
        }
        catch (EnvInjectException envEx) {
            throw new IOException(envEx.getMessage());
        }
        return result;
    }

    private File getFile(File base, String scriptFilePath) {
        File file = new File(scriptFilePath);
        if (file.exists()) {
            return file;
        }
        file = new File(base, scriptFilePath);
        return file.exists() ? file : null;
    }
}

