/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.PasswordParameterValue;
import hudson.tasks.BuildWrapper;
import hudson.util.DescribableList;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectGlobalPasswordEntry;
import org.jenkinsci.plugins.envinject.EnvInjectPasswordEntry;
import org.jenkinsci.plugins.envinject.EnvInjectPasswordWrapper;
import org.jenkinsci.plugins.envinject.service.EnvInjectGlobalPasswordRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectPasswordsMasker
implements Serializable {
    public void maskPasswordsIfAny(AbstractBuild build, EnvInjectLogger logger, Map<String, String> envVars) {
        this.maskPasswordsJobParameterIfAny(build, logger, envVars);
        this.maskPasswordsEnvInjectIfAny(build, logger, envVars);
    }

    private void maskPasswordsJobParameterIfAny(AbstractBuild build, EnvInjectLogger logger, Map<String, String> envVars) {
        List parameters;
        ParametersAction parametersAction = (ParametersAction)build.getAction(ParametersAction.class);
        if (parametersAction != null && (parameters = parametersAction.getParameters()) != null) {
            for (ParameterValue parameter : parameters) {
                if (!(parameter instanceof PasswordParameterValue)) continue;
                PasswordParameterValue passwordParameterValue = (PasswordParameterValue)parameter;
                envVars.put(passwordParameterValue.getName(), passwordParameterValue.getValue().getEncryptedValue());
            }
        }
    }

    private void maskPasswordsEnvInjectIfAny(AbstractBuild build, EnvInjectLogger logger, Map<String, String> envVars) {
        try {
            EnvInjectPasswordEntry[] passwordEntries;
            EnvInjectPasswordWrapper envInjectPasswordWrapper = this.getEnvInjectPasswordWrapper(build);
            if (envInjectPasswordWrapper == null) {
                return;
            }
            if (envInjectPasswordWrapper.isInjectGlobalPasswords()) {
                this.maskGlobalPasswords(envVars);
            }
            if ((passwordEntries = envInjectPasswordWrapper.getPasswordEntries()) != null) {
                this.maskJobPasswords(envVars, passwordEntries);
            }
        }
        catch (EnvInjectException ee) {
            logger.error("Can't mask global password :" + ee.getMessage());
        }
    }

    private EnvInjectPasswordWrapper getEnvInjectPasswordWrapper(AbstractBuild build) throws EnvInjectException {
        DescribableList wrappersProject;
        if (build instanceof MatrixRun) {
            MatrixProject project = (MatrixProject)((MatrixRun)build).getParentBuild().getProject();
            wrappersProject = project.getBuildWrappersList();
        } else {
            AbstractProject abstractProject = build.getProject();
            if (abstractProject instanceof BuildableItemWithBuildWrappers) {
                BuildableItemWithBuildWrappers project = (BuildableItemWithBuildWrappers)abstractProject;
                wrappersProject = project.getBuildWrappersList();
            } else {
                throw new EnvInjectException(String.format("Job type %s is not supported", abstractProject));
            }
        }
        for (BuildWrapper buildWrapper : wrappersProject) {
            if (!EnvInjectPasswordWrapper.class.equals(buildWrapper.getClass())) continue;
            return (EnvInjectPasswordWrapper)buildWrapper;
        }
        return null;
    }

    private void maskGlobalPasswords(Map<String, String> envVars) throws EnvInjectException {
        EnvInjectGlobalPasswordRetriever globalPasswordRetriever = new EnvInjectGlobalPasswordRetriever();
        EnvInjectGlobalPasswordEntry[] globalPasswordEntries = globalPasswordRetriever.getGlobalPasswords();
        if (globalPasswordEntries != null) {
            for (EnvInjectGlobalPasswordEntry globalPasswordEntry : globalPasswordEntries) {
                envVars.put(globalPasswordEntry.getName(), globalPasswordEntry.getValue().getEncryptedValue());
            }
        }
    }

    private void maskJobPasswords(Map<String, String> envVars, EnvInjectPasswordEntry[] passwordEntries) {
        for (EnvInjectPasswordEntry passwordEntry : passwordEntries) {
            envVars.put(passwordEntry.getName(), passwordEntry.getValue().getEncryptedValue());
        }
    }
}

