/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.service.EnvInjectScriptExecutor;
import org.jenkinsci.plugins.envinject.service.PropertiesVariablesRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectEnvVars
implements Serializable {
    EnvInjectLogger logger;

    public EnvInjectEnvVars(EnvInjectLogger logger) {
        this.logger = logger;
    }

    public Map<String, String> getEnvVarsPropertiesJobProperty(FilePath rootPath, EnvInjectLogger logger, boolean loadFilesFromMaster, String propertiesFilePath, Map<String, String> propertiesContent, Map<String, String> infraEnvVarsMaster, Map<String, String> infraEnvVarsNode) throws EnvInjectException {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        try {
            if (loadFilesFromMaster) {
                resultMap.putAll((Map)Hudson.getInstance().getRootPath().act((FilePath.FileCallable)new PropertiesVariablesRetriever(propertiesFilePath, propertiesContent, infraEnvVarsMaster, logger)));
            } else {
                resultMap.putAll((Map)rootPath.act((FilePath.FileCallable)new PropertiesVariablesRetriever(propertiesFilePath, propertiesContent, infraEnvVarsNode, logger)));
            }
        }
        catch (IOException e) {
            throw new EnvInjectException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new EnvInjectException((Throwable)e);
        }
        return resultMap;
    }

    public Map<String, String> getEnvVarsFileProperty(FilePath rootPath, EnvInjectLogger logger, String propertiesFilePath, Map<String, String> propertiesContent, Map<String, String> currentEnvVars) throws EnvInjectException {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        try {
            resultMap.putAll((Map)rootPath.act((FilePath.FileCallable)new PropertiesVariablesRetriever(propertiesFilePath, propertiesContent, currentEnvVars, logger)));
        }
        catch (IOException e) {
            throw new EnvInjectException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new EnvInjectException((Throwable)e);
        }
        return resultMap;
    }

    public int executeScript(boolean loadFromMaster, String scriptContent, FilePath scriptExecutionRoot, String scriptFilePath, Map<String, String> infraEnvVarsMaster, Map<String, String> infraEnvVarsNode, Launcher launcher, BuildListener listener) throws EnvInjectException {
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        EnvInjectScriptExecutor scriptExecutor = new EnvInjectScriptExecutor(launcher, logger);
        HashMap<String, String> scriptExecutionEnvVars = new HashMap<String, String>();
        scriptExecutionEnvVars.putAll(infraEnvVarsNode);
        if (loadFromMaster) {
            HashMap<String, String> scriptPathExecutionEnvVars = new HashMap<String, String>();
            scriptPathExecutionEnvVars.putAll(infraEnvVarsMaster);
            return scriptExecutor.executeScriptSection(scriptExecutionRoot, scriptFilePath, scriptContent, scriptPathExecutionEnvVars, scriptExecutionEnvVars);
        }
        return scriptExecutor.executeScriptSection(scriptExecutionRoot, scriptFilePath, scriptContent, scriptExecutionEnvVars, scriptExecutionEnvVars);
    }

    public Map<String, String> executeAndGetMapGroovyScript(String scriptContent, Map<String, String> envVars) throws EnvInjectException {
        if (scriptContent == null) {
            return new HashMap<String, String>();
        }
        if (scriptContent.trim().length() == 0) {
            return new HashMap<String, String>();
        }
        this.logger.info(String.format("Evaluation the following Groovy script content: \n%s\n", scriptContent));
        Binding binding = new Binding();
        String jobName = envVars.get("JOB_NAME");
        if (jobName != null) {
            Item job = Jenkins.getInstance().getItemByFullName(jobName);
            binding.setProperty("currentJob", (Object)job);
            String b = envVars.get("BUILD_NUMBER");
            if (b != null && job instanceof AbstractProject) {
                Run r = ((AbstractProject)job).getBuildByNumber(Integer.parseInt(b));
                binding.setProperty("currentBuild", (Object)r);
            }
        }
        GroovyShell groovyShell = new GroovyShell(Hudson.getInstance().getPluginManager().uberClassLoader, binding);
        for (Map.Entry<String, String> entryVariable : envVars.entrySet()) {
            groovyShell.setVariable(entryVariable.getKey(), (Object)entryVariable.getValue());
        }
        Object groovyResult = groovyShell.evaluate(scriptContent);
        if (groovyResult != null && !(groovyResult instanceof Map)) {
            throw new EnvInjectException("The evaluated Groovy script must return a Map object.");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (groovyResult == null) {
            return result;
        }
        for (Map.Entry entry : ((Map)groovyResult).entrySet()) {
            result.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return result;
    }

    public int executeScript(String scriptContent, FilePath scriptExecutionRoot, String scriptFilePath, Map<String, String> envVars, Launcher launcher, BuildListener listener) throws EnvInjectException {
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        EnvInjectScriptExecutor scriptExecutor = new EnvInjectScriptExecutor(launcher, logger);
        return scriptExecutor.executeScriptSection(scriptExecutionRoot, scriptFilePath, scriptContent, envVars, envVars);
    }

    public Map<String, String> getMergedVariables(Map<String, String> infraEnvVars, Map<String, String> propertiesEnvVars) {
        return this.getMergedVariables(infraEnvVars, propertiesEnvVars, new HashMap<String, String>(), new HashMap<String, String>());
    }

    public Map<String, String> getMergedVariables(Map<String, String> infraEnvVars, Map<String, String> propertiesEnvVars, Map<String, String> groovyMapEnvVars, Map<String, String> contribEnvVars) {
        this.resolveVars(infraEnvVars, infraEnvVars);
        this.resolveVars(propertiesEnvVars, infraEnvVars);
        this.resolveVars(propertiesEnvVars, groovyMapEnvVars);
        this.resolveVars(propertiesEnvVars, contribEnvVars);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>(infraEnvVars);
        variables.putAll(groovyMapEnvVars);
        variables.putAll(contribEnvVars);
        variables.putAll(propertiesEnvVars);
        return variables;
    }

    public void resolveVars(Map<String, String> variables, Map<String, String> env) {
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String value = Util.replaceMacro((String)entry.getValue(), env);
            entry.setValue(value);
        }
        boolean stopToResolveVars = false;
        int nbUnresolvedVar = 0;
        while (!stopToResolveVars) {
            int previousNbUnresolvedVar = nbUnresolvedVar;
            nbUnresolvedVar = 0;
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                String value = Util.replaceMacro((String)entry.getValue(), variables);
                entry.setValue(value);
                if (!this.isUnresolvedVar(value)) continue;
                ++nbUnresolvedVar;
            }
            if (previousNbUnresolvedVar != nbUnresolvedVar) continue;
            stopToResolveVars = true;
        }
    }

    public Map<String, String> removeUnsetVars(Map<String, String> envVars) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : envVars.entrySet()) {
            String value = entry.getValue();
            if (!this.isUnresolvedVar(value = this.removeUnsetVars(value))) {
                result.put(entry.getKey(), this.removeEscapeDollar(value));
                continue;
            }
            this.logger.info(String.format("Unset unresolved '%s' variable.", entry.getKey()));
        }
        return result;
    }

    private String removeUnsetVars(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        if (!value.contains("$") || value.contains("\\$")) {
            return value;
        }
        return Util.replaceMacro((String)value, (VariableResolver)new VariableResolver<String>(){

            public String resolve(String name) {
                return "";
            }
        });
    }

    private boolean isUnresolvedVar(String value) {
        if (value == null) {
            return true;
        }
        if (value.trim().length() == 0) {
            return false;
        }
        return value.contains("$") && !value.contains("\\$");
    }

    private String removeEscapeDollar(String value) {
        if ('/' == File.separatorChar) {
            return value.replace("\\$", "$");
        }
        return value;
    }
}

