/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Descriptor;
import hudson.tasks.BuildWrapper;
import hudson.util.DescribableList;
import java.io.IOException;
import java.io.Serializable;
import org.jenkinsci.lib.envinject.EnvInjectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildWrapperService
implements Serializable {
    public void addBuildWrapper(AbstractBuild build, BuildWrapper buildWrapper) throws EnvInjectException {
        if (buildWrapper == null) {
            throw new NullPointerException("A build wrapper object is required.");
        }
        try {
            DescribableList<BuildWrapper, Descriptor<BuildWrapper>> wrappersProject = this.getBuildWrapperDescriptorDescribableList(build);
            wrappersProject.add((Object)buildWrapper);
        }
        catch (IOException ioe) {
            throw new EnvInjectException((Throwable)ioe);
        }
    }

    public void removeBuildWrappers(AbstractBuild build, Class<? extends BuildWrapper> ... wrappersClass) throws EnvInjectException {
        if (wrappersClass == null) {
            throw new NullPointerException("A class wrappers is required.");
        }
        DescribableList<BuildWrapper, Descriptor<BuildWrapper>> wrappersProject = this.getBuildWrapperDescriptorDescribableList(build);
        for (BuildWrapper buildWrapper : wrappersProject) {
            for (Class<? extends BuildWrapper> wrapperClass : wrappersClass) {
                if (!wrapperClass.getName().equals(buildWrapper.getClass().getName())) continue;
                try {
                    wrappersProject.remove((Object)buildWrapper);
                }
                catch (IOException ioe) {
                    throw new EnvInjectException((Throwable)ioe);
                }
            }
        }
    }

    private DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrapperDescriptorDescribableList(AbstractBuild build) throws EnvInjectException {
        if (build instanceof MatrixRun) {
            MatrixProject project = (MatrixProject)((MatrixRun)build).getParentBuild().getProject();
            return project.getBuildWrappersList();
        }
        AbstractProject abstractProject = build.getProject();
        if (abstractProject instanceof BuildableItemWithBuildWrappers) {
            BuildableItemWithBuildWrappers project = (BuildableItemWithBuildWrappers)abstractProject;
            return project.getBuildWrappersList();
        }
        throw new EnvInjectException(String.format("Job type %s is not supported", abstractProject));
    }
}

