/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge.extensions;

import hudson.Extension;
import hudson.model.Actionable;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.badge.extensionpoints.ParameterResolverExtensionPoint;

@Extension
public class BuildParameterResolverExtension
implements ParameterResolverExtensionPoint {
    private static Pattern pattern = Pattern.compile("params\\.([^\\{\\}\\s]+)");
    private static Pattern defaultPattern = Pattern.compile("params\\.([^\\{\\}\\s\\|]+)\\|([^\\}\\|]+)");

    @Override
    public String resolve(Actionable actionable, String parameter) {
        if (actionable instanceof Run) {
            Run run = (Run)actionable;
            ParametersAction params = (ParametersAction)run.getAction(ParametersAction.class);
            if (params != null) {
                String valueStr;
                ParameterValue value;
                Matcher matcher = defaultPattern.matcher(parameter);
                while (matcher.find()) {
                    value = params.getParameter(matcher.group(1));
                    if (value != null) {
                        valueStr = value.getValue().toString();
                        parameter = matcher.replaceAll(valueStr);
                        matcher = defaultPattern.matcher(parameter);
                        continue;
                    }
                    parameter = matcher.replaceAll("$2");
                    matcher = defaultPattern.matcher(parameter);
                }
                matcher = pattern.matcher(parameter);
                while (matcher.find()) {
                    value = params.getParameter(matcher.group(1));
                    if (value != null) {
                        valueStr = value.getValue().toString();
                        parameter = matcher.replaceFirst(valueStr);
                        matcher = pattern.matcher(parameter);
                        continue;
                    }
                    parameter = matcher.replaceFirst("");
                    matcher = pattern.matcher(parameter);
                }
            }
        } else if (actionable instanceof Job) {
            parameter = this.resolve((Actionable)((Job)actionable).getLastBuild(), parameter);
        }
        return parameter;
    }
}

