/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge;

import hudson.model.BallColor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.plugins.badge.StatusImage;

public class ImageResolver {
    private final Map<String, String> statuses = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("red", "failing");
            this.put("brightgreen", "passing");
            this.put("yellow", "unstable");
            this.put("aborted", "aborted");
            this.put("blue", "running");
            this.put("disabled", "disabled");
            this.put("notbuilt", "not run");
        }
    };

    public StatusImage getImage(BallColor color, String style, String subject, String status, String colorName, String animatedOverlayColor, String link) {
        String[] styleParts;
        String statusColorName = color.noAnime().toString();
        String statusAnimatedOverlayColorName = null;
        if (style != null && (styleParts = style.split("-")).length == 2 && styleParts[0].equals("ball")) {
            String url = color.getImageOf(styleParts[1]);
            if (url == null) {
                url = color.getImageOf("32x32");
            }
            if (url != null) {
                try {
                    return new StatusImage(url);
                }
                catch (IOException ioe) {
                    return new StatusImage();
                }
            }
        }
        if (color.isAnimated() && colorName == null) {
            statusAnimatedOverlayColorName = "blue";
        }
        if (statusColorName.equals("blue")) {
            statusColorName = "brightgreen";
        }
        if (colorName == null) {
            colorName = statusColorName.equals("aborted") || statusColorName.equals("disabled") || statusColorName.equals("notbuilt") ? "lightgrey" : statusColorName;
            if (animatedOverlayColor == null) {
                animatedOverlayColor = statusAnimatedOverlayColorName;
            }
        }
        if (subject == null) {
            subject = "build";
        }
        if (status == null && (status = this.statuses.get(statusAnimatedOverlayColorName != null ? statusAnimatedOverlayColorName : statusColorName)) == null) {
            status = "unknown";
        }
        try {
            return new StatusImage(subject, status, colorName, animatedOverlayColor, style, link);
        }
        catch (IOException ioe) {
            return new StatusImage();
        }
    }
}

