/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.User;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.plugins.emailext.plugins.recipients.RecipientProviderUtilities;
import hudson.tasks.Mailer;
import jakarta.mail.internet.InternetAddress;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class ContributorMetadataRecipientProvider
extends RecipientProvider {
    @DataBoundConstructor
    public ContributorMetadataRecipientProvider() {
    }

    @Override
    public void addRecipients(final ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        final class Debug
        implements RecipientProviderUtilities.IDebug {
            private final ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
            private final PrintStream logger = context.getListener().getLogger();

            Debug() {
            }

            @Override
            public void send(String format, Object ... args) {
                this.descriptor.debug(this.logger, format, args);
            }
        }
        Debug debug = new Debug();
        ContributorMetadataAction action = (ContributorMetadataAction)context.getRun().getAction(ContributorMetadataAction.class);
        if (action != null) {
            User user = this.findUser(debug, action.getContributor(), action.getContributorEmail());
            if (user != null) {
                RecipientProviderUtilities.addUsers(Collections.singleton(user), context, env, to, cc, bcc, (RecipientProviderUtilities.IDebug)debug);
            }
        } else {
            debug.send("No ContributorMetadataAction is available", new Object[0]);
            context.getListener().getLogger().print(Messages.ContributorMetadataRecipientProvider_NoContributorInformationAvailable());
        }
    }

    public User findUser(RecipientProviderUtilities.IDebug debug, String author, String authorEmail) {
        User user = null;
        if (!StringUtils.isBlank((CharSequence)author)) {
            debug.send("Trying username to get user account from Jenkins", new Object[0]);
            user = User.get((String)author, (boolean)false, Collections.emptyMap());
        }
        if (user == null && !StringUtils.isBlank((CharSequence)authorEmail)) {
            debug.send("Trying email address to get user account from Jenkins", new Object[0]);
            user = User.get((String)authorEmail, (boolean)false, Collections.emptyMap());
            if (user == null) {
                debug.send("Looking through all users for a matching email address", new Object[0]);
                for (User existingUser : User.getAll()) {
                    if (!authorEmail.equalsIgnoreCase(this.getMail(existingUser))) continue;
                    user = existingUser;
                    break;
                }
            }
        }
        if (user == null) {
            debug.send("Could not find user with information provided", new Object[0]);
        }
        return user;
    }

    private String getMail(User user) {
        Mailer.UserProperty property = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
        if (property == null) {
            return null;
        }
        if (!property.hasExplicitlyConfiguredAddress()) {
            return null;
        }
        return property.getExplicitlyConfiguredAddress();
    }

    @Extension
    @Symbol(value={"contributor"})
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.ContributorMetadataRecipientProvider_DisplayName();
        }
    }
}

