/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class FailedTestsContent
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter
    public boolean showStack = true;
    @DataBoundTokenMacro.Parameter
    public boolean showMessage = true;
    @DataBoundTokenMacro.Parameter
    public int maxTests = Integer.MAX_VALUE;
    @DataBoundTokenMacro.Parameter
    public boolean onlyRegressions = false;
    @DataBoundTokenMacro.Parameter
    public int maxLength = Integer.MAX_VALUE;
    @DataBoundTokenMacro.Parameter
    public String outputFormat = "";
    @DataBoundTokenMacro.Parameter
    public String testNamePattern = "";
    public static final String MACRO_NAME = "FAILED_TESTS";

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException {
        return this.evaluate((Run<?, ?>)build, build.getWorkspace(), listener, macroName);
    }

    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException {
        AbstractTestResultAction testResult = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
        SummarizedTestResult result = this.prepareSummarizedTestResult(testResult);
        if ("yaml".equals(this.outputFormat)) {
            try {
                return result.toYamlString();
            }
            catch (JsonProcessingException e) {
                throw new MacroEvaluationException("Unable to serialize to yaml", MACRO_NAME, e.getCause());
            }
        }
        return result.toString();
    }

    private boolean regressionFilter(TestResult failedTest) {
        return !this.onlyRegressions || this.getTestAge(failedTest) == 1;
    }

    private void setMaxLength() {
        if (this.maxLength < Integer.MAX_VALUE) {
            this.maxLength *= 1024;
        }
    }

    private int getTestAge(TestResult result) {
        if (result.isPassed()) {
            return 0;
        }
        if (result.getRun() != null) {
            return result.getRun().getNumber() - result.getFailedSince() + 1;
        }
        return 0;
    }

    private SummarizedTestResult prepareSummarizedTestResult(AbstractTestResultAction<?> testResult) {
        if (null == testResult) {
            SummarizedTestResult result = new SummarizedTestResult(0, this.getLineBreak());
            result.summary = "No tests ran.";
            return result;
        }
        int failCount = testResult.getFailCount();
        List<? extends TestResult> failedAndFilteredTests = this.filterTests(testResult.getFailedTests(), this.testNamePattern);
        failCount = this.testNamePattern.length() == 0 ? failCount : failedAndFilteredTests.size();
        SummarizedTestResult result = new SummarizedTestResult(failCount, this.getLineBreak());
        if (failCount == 0) {
            result.summary = "All tests passed";
        } else {
            result.summary = String.format("%d tests failed.", failCount);
            this.setMaxLength();
            if (this.maxTests > 0) {
                int printSize = 0;
                for (TestResult testResult2 : failedAndFilteredTests) {
                    if (!this.regressionFilter(testResult2)) continue;
                    printSize = this.addTest(result, printSize, testResult2);
                }
                result.otherFailedTests = failCount > result.tests.size();
                result.truncatedOutput = printSize > this.maxLength;
            }
        }
        return result;
    }

    private int addTest(SummarizedTestResult result, int printSize, TestResult failedTest) {
        String stackTrace;
        String string = this.showStack ? (this.escapeHtml ? StringEscapeUtils.escapeHtml((String)failedTest.getErrorStackTrace()) : failedTest.getErrorStackTrace()) : (stackTrace = null);
        String errorDetails = this.showMessage ? (this.escapeHtml ? StringEscapeUtils.escapeHtml((String)failedTest.getErrorDetails()) : failedTest.getErrorDetails()) : null;
        String name = String.format("%s.%s", failedTest instanceof CaseResult ? ((CaseResult)failedTest).getClassName() : failedTest.getFullName(), failedTest.getDisplayName());
        FailedTest t = new FailedTest(name, failedTest.isPassed(), errorDetails, stackTrace);
        String testYaml = t.toString();
        if (printSize <= this.maxLength && result.tests.size() < this.maxTests) {
            result.tests.add(t);
            printSize += testYaml.length();
        }
        return printSize;
    }

    public String getLineBreak() {
        return this.escapeHtml ? "<br/>" : "\n";
    }

    public boolean handlesHtmlEscapeInternally() {
        return true;
    }

    private List<? extends TestResult> filterTests(List<? extends TestResult> failedTests, String regexPattern) {
        if (regexPattern.length() != 0) {
            Pattern pattern = Pattern.compile(regexPattern);
            failedTests = failedTests.stream().filter(t -> pattern.matcher(t.getFullName()).matches()).collect(Collectors.toList());
        }
        return failedTests;
    }

    private static class SummarizedTestResult {
        public String summary;
        public List<FailedTest> tests = new ArrayList<FailedTest>();
        public boolean otherFailedTests;
        public boolean truncatedOutput;
        private int totalFailCount;
        private String lineBreak;

        public SummarizedTestResult(int failCount, String lineBreak) {
            this.totalFailCount = failCount;
            this.lineBreak = lineBreak;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.summary);
            if (!this.tests.isEmpty()) {
                builder.append(this.lineBreak);
            }
            for (FailedTest t : this.tests) {
                this.outputTest(builder, this.lineBreak, t);
            }
            if (this.otherFailedTests) {
                builder.append("... and ").append(this.totalFailCount - this.tests.size()).append(" other failed tests.").append(this.lineBreak);
            }
            if (this.truncatedOutput) {
                builder.append(this.lineBreak).append("... output truncated.").append(this.lineBreak);
            }
            return builder.toString();
        }

        public String toYamlString() throws JsonProcessingException {
            ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).configure(YAMLGenerator.Feature.LITERAL_BLOCK_STYLE, true));
            return om.writeValueAsString((Object)this);
        }

        private void outputTest(StringBuilder buffer, String lineBreak, FailedTest failedTest) {
            StringBuilder local = new StringBuilder();
            local.append(failedTest.status).append(":  ");
            local.append(failedTest.name).append(lineBreak);
            if (failedTest.errorMessage != null) {
                local.append(lineBreak).append("Error Message:").append(lineBreak).append(failedTest.errorMessage).append(lineBreak);
            }
            if (failedTest.stackTrace != null) {
                local.append(lineBreak).append("Stack Trace:").append(lineBreak).append(failedTest.stackTrace).append(lineBreak);
            }
            if (failedTest.stackTrace != null || failedTest.errorMessage != null) {
                local.append(lineBreak);
            }
            buffer.append((CharSequence)local);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static class FailedTest {
        String name;
        String status;
        String errorMessage;
        String stackTrace;

        public FailedTest(String name, boolean status, String errorMessage, String stackTrace) {
            this.errorMessage = errorMessage;
            this.name = name;
            this.stackTrace = stackTrace;
            this.status = status ? "PASSED" : "FAILED";
        }

        public String toString() {
            return String.format("Name:%s, Status:%s, Error message: %s, Stack trace:%s", this.name, this.status, this.errorMessage, this.stackTrace);
        }
    }
}

