/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.EnvVars;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.scm.ChangeLogSet;
import hudson.tasks.MailSender;
import jakarta.mail.internet.InternetAddress;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.scm.RunWithSCM;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public final class RecipientProviderUtilities {
    private static final Logger LOGGER = Logger.getLogger(RecipientProviderUtilities.class.getName());
    static boolean SEND_TO_USERS_WITHOUT_READ = Boolean.getBoolean(MailSender.class.getName() + ".SEND_TO_USERS_WITHOUT_READ");
    static boolean SEND_TO_UNKNOWN_USERS = Boolean.getBoolean(MailSender.class.getName() + ".SEND_TO_UNKNOWN_USERS");

    private RecipientProviderUtilities() {
    }

    public static Set<User> getChangeSetAuthors(Collection<Run<?, ?>> runs, IDebug debug) {
        debug.send("  Collecting change authors...", new Object[0]);
        HashSet<User> users = new HashSet<User>();
        for (Run<?, ?> run : runs) {
            debug.send("    build: %d", run.getNumber());
            if (!(run instanceof RunWithSCM)) continue;
            List changeSets = ((RunWithSCM)run).getChangeSets();
            for (ChangeLogSet changeSet : changeSets) {
                RecipientProviderUtilities.addChangeSetUsers(changeSet, users, debug);
            }
        }
        return users;
    }

    private static void addChangeSetUsers(ChangeLogSet<?> changeLogSet, Set<User> users, IDebug debug) {
        HashSet<User> changeAuthors = new HashSet<User>();
        for (ChangeLogSet.Entry change : changeLogSet) {
            User changeAuthor = change.getAuthor();
            if (!changeAuthors.add(changeAuthor)) continue;
            debug.send("      adding author: %s", changeAuthor.getFullName());
        }
        users.addAll(changeAuthors);
    }

    public static Set<User> getUsersTriggeringTheBuilds(Collection<Run<?, ?>> runs, IDebug debug) {
        debug.send("  Collecting build requestors...", new Object[0]);
        HashSet<User> users = new HashSet<User>();
        for (Run<?, ?> run : runs) {
            debug.send("    build: %d", run.getNumber());
            User buildRequestor = RecipientProviderUtilities.getUserTriggeringTheBuild(run);
            if (buildRequestor != null) {
                debug.send("      adding requestor: %s", buildRequestor.getFullName());
                users.add(buildRequestor);
                continue;
            }
            debug.send("      buildRequestor was null", new Object[0]);
        }
        return users;
    }

    private static User getByUserIdCause(Run<?, ?> run) {
        try {
            Cause.UserIdCause cause = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
            if (cause != null) {
                String id = cause.getUserId();
                return User.get((String)id, (boolean)false, Collections.emptyMap());
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    private static User getByLegacyUserCause(Run<?, ?> run) {
        try {
            Cause.UserCause userCause = (Cause.UserCause)run.getCause(Cause.UserCause.class);
            if (userCause != null) {
                Field authenticationName = Cause.UserCause.class.getDeclaredField("authenticationName");
                authenticationName.setAccessible(true);
                String name = (String)authenticationName.get(userCause);
                return User.get((String)name, (boolean)false, Collections.emptyMap());
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    public static User getUserTriggeringTheBuild(Run<?, ?> run) {
        User user = RecipientProviderUtilities.getByUserIdCause(run);
        if (user == null) {
            user = RecipientProviderUtilities.getByLegacyUserCause(run);
        }
        return user;
    }

    @Deprecated
    public static void addUsers(Set<User> users, TaskListener listener, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, IDebug debug) {
        RecipientProviderUtilities.addUsers(users, listener, null, env, to, cc, bcc, debug);
    }

    public static void addUsers(Set<User> users, ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, IDebug debug) {
        RecipientProviderUtilities.addUsers(users, context.getListener(), context.getRun(), env, to, cc, bcc, debug);
    }

    private static void addUsers(Set<User> users, TaskListener listener, @CheckForNull Run<?, ?> run, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, IDebug debug) {
        for (User user : users) {
            if (EmailRecipientUtils.isExcludedRecipient(user, listener)) {
                debug.send("User %s is an excluded recipient.", user.getFullName());
                continue;
            }
            String userAddress = EmailRecipientUtils.getUserConfiguredEmail(user);
            if (userAddress != null) {
                block10: {
                    if (Jenkins.get().isUseSecurity()) {
                        try {
                            Authentication auth = user.impersonate2();
                            if (run == null || run.getACL().hasPermission2(auth, Item.READ)) break block10;
                            if (SEND_TO_USERS_WITHOUT_READ) {
                                listener.getLogger().printf("Warning: user %s has no permission to view %s, but sending mail anyway%n", userAddress, run.getFullDisplayName());
                                break block10;
                            }
                            listener.getLogger().printf("Not sending mail to user %s with no permission to view %s", userAddress, run.getFullDisplayName());
                        }
                        catch (AuthenticationException x) {
                            if (SEND_TO_UNKNOWN_USERS || ExtendedEmailPublisher.descriptor().isAllowUnregisteredEnabled()) {
                                listener.getLogger().printf("Warning: %s is not a recognized user, but sending mail anyway%n", userAddress);
                                break block10;
                            }
                            listener.getLogger().printf("Not sending mail to unregistered user %s because your SCM claimed this was associated with a user ID \u2018", userAddress);
                            try {
                                listener.hyperlink('/' + user.getUrl(), user.getDisplayName());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            listener.getLogger().printf("' which your security realm does not recognize; you may need changes in your SCM plugin%n", new Object[0]);
                        }
                        continue;
                    }
                }
                debug.send("Adding %s with address %s", user.getFullName(), userAddress);
                EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, userAddress, env, listener);
                continue;
            }
            listener.getLogger().println("Failed to send e-mail to " + user.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
        }
    }

    public static interface IDebug {
        public void send(String var1, Object ... var2);
    }
}

