/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnamePortRequirement;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.GroovyScriptPath;
import hudson.plugins.emailext.MailAccount;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.trigger.FailureTrigger;
import hudson.security.Permission;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import jakarta.mail.Authenticator;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Symbol(value={"email-ext", "extendedEmailPublisher"})
public final class ExtendedEmailPublisherDescriptor
extends BuildStepDescriptor<Publisher> {
    public static final Logger LOGGER = Logger.getLogger(ExtendedEmailPublisherDescriptor.class.getName());
    private String defaultSuffix;
    private transient String hudsonUrl;
    private MailAccount mailAccount = new MailAccount();
    private List<MailAccount> addAccounts = new ArrayList<MailAccount>();
    private transient String adminAddress;
    private String charset;
    private String defaultContentType;
    private String defaultSubject;
    private String defaultBody;
    private String defaultPresendScript = "";
    private String defaultPostsendScript = "";
    private List<GroovyScriptPath> defaultClasspath = new ArrayList<GroovyScriptPath>();
    private transient List<EmailTriggerDescriptor> defaultTriggers = new ArrayList<EmailTriggerDescriptor>();
    private List<String> defaultTriggerIds = new ArrayList<String>();
    private String emergencyReroute;
    private long maxAttachmentSize = -1L;
    private String recipientList = "";
    private String defaultReplyTo = "";
    private String allowedDomains = null;
    private String excludedCommitters = "";
    private transient boolean overrideGlobalSettings;
    private String listId;
    private boolean precedenceBulk;
    private boolean debugMode = false;
    private transient boolean enableSecurity = false;
    private boolean requireAdminForTemplateTesting = false;
    private boolean enableWatching;
    private boolean enableAllowUnregistered;
    private transient String smtpHost;
    private transient String smtpPort;
    private transient String smtpAuthUsername;
    private transient Secret smtpAuthPassword;
    private transient boolean useSsl = false;
    private transient BiFunction<MailAccount, Run<?, ?>, Authenticator> authenticatorProvider = (acc, run) -> new Authenticator((MailAccount)((Object)acc), (Run)run){
        final /* synthetic */ MailAccount val$acc;
        final /* synthetic */ Run val$run;
        {
            this.val$acc = mailAccount;
            this.val$run = run;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            StandardUsernamePasswordCredentials c;
            HostnamePortRequirement domainRequirement = null;
            if (StringUtils.isNotBlank((String)this.val$acc.getSmtpHost()) && StringUtils.isNotBlank((String)this.val$acc.getSmtpPort())) {
                domainRequirement = new HostnamePortRequirement(this.val$acc.getSmtpHost(), Integer.parseInt(this.val$acc.getSmtpPort()));
            }
            if ((c = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)this.val$acc.getCredentialsId(), StandardUsernamePasswordCredentials.class, (Run)this.val$run, (DomainRequirement[])new DomainRequirement[]{domainRequirement})) == null) {
                return null;
            }
            return new PasswordAuthentication(c.getUsername(), Secret.toString((Secret)c.getPassword()));
        }
    };

    private Object readResolve() {
        if (this.smtpHost != null) {
            this.mailAccount.setSmtpHost(this.smtpHost);
        }
        if (this.smtpPort != null) {
            this.mailAccount.setSmtpPort(this.smtpPort);
        }
        if (this.smtpAuthUsername != null) {
            this.mailAccount.setSmtpUsername(this.smtpAuthUsername);
        }
        if (this.smtpAuthPassword != null) {
            this.mailAccount.setSmtpPassword(this.smtpAuthPassword);
        }
        if (this.useSsl) {
            this.mailAccount.setUseSsl(this.useSsl);
        }
        if (this.mailAccount.getAddress() != null) {
            this.mailAccount.setAddress(null);
        }
        return this;
    }

    public ExtendedEmailPublisherDescriptor() {
        super(ExtendedEmailPublisher.class);
        this.load();
        if (this.defaultBody == null && this.defaultSubject == null && this.emergencyReroute == null) {
            this.defaultBody = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
            this.defaultSubject = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
            this.emergencyReroute = "";
        }
        if (this.mailAccount == null) {
            this.mailAccount = new MailAccount();
        }
        this.mailAccount.setDefaultAccount(true);
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED, before=InitMilestone.JOB_LOADED)
    public static void autoConfigure() {
        block8: {
            ExtendedEmailPublisherDescriptor descriptor = ExtendedEmailPublisher.descriptor();
            if (Jenkins.get().isUseSecurity() && !StringUtils.isBlank((String)descriptor.getDefaultPostsendScript()) || !StringUtils.isBlank((String)descriptor.getDefaultPresendScript())) {
                descriptor.setDefaultPostsendScript(descriptor.getDefaultPostsendScript());
                descriptor.setDefaultPresendScript(descriptor.getDefaultPresendScript());
                try {
                    descriptor.setDefaultClasspath(descriptor.getDefaultClasspath());
                }
                catch (Descriptor.FormException e) {
                    ArrayList<GroovyScriptPath> newList = new ArrayList<GroovyScriptPath>();
                    for (GroovyScriptPath path : descriptor.getDefaultClasspath()) {
                        URL u = path.asURL();
                        if (u == null) continue;
                        try {
                            new ClasspathEntry(u.toString());
                            newList.add(path);
                        }
                        catch (MalformedURLException mfue) {
                            LOGGER.log(Level.WARNING, "The default classpath contained a malformed url, will be ignored.", mfue);
                        }
                    }
                    try {
                        descriptor.setDefaultClasspath(newList);
                    }
                    catch (Descriptor.FormException e1) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError((Object)e1);
                    }
                }
            }
        }
    }

    @NonNull
    public String getDisplayName() {
        return Messages.ExtendedEmailPublisherDescriptor_DisplayName();
    }

    public String getAdminAddress() {
        JenkinsLocationConfiguration config = JenkinsLocationConfiguration.get();
        if (config != null && StringUtils.isBlank((String)this.mailAccount.getAddress())) {
            return config.getAdminAddress();
        }
        return this.mailAccount.getAddress();
    }

    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }

    @DataBoundSetter
    public void setDefaultSuffix(String defaultSuffix) {
        this.defaultSuffix = Util.fixEmptyAndTrim((String)defaultSuffix);
    }

    @Restricted(value={NoExternalUse.class})
    Session createSession(MailAccount acc, ExtendedEmailPublisherContext context) {
        String port;
        String SMTP_PORT_PROPERTY = "mail.smtp.port";
        String SMTP_SOCKETFACTORY_PORT_PROPERTY = "mail.smtp.socketFactory.port";
        Properties props = new Properties(System.getProperties());
        if (acc.getSmtpHost() != null) {
            props.put("mail.smtp.host", acc.getSmtpHost());
        }
        if (acc.getSmtpPort() != null) {
            props.put("mail.smtp.port", acc.getSmtpPort());
        }
        if (acc.isUseSsl()) {
            if (props.getProperty("mail.smtp.socketFactory.port") == null) {
                port = acc.getSmtpPort() == null ? "465" : this.mailAccount.getSmtpPort();
                props.put("mail.smtp.port", port);
                props.put("mail.smtp.socketFactory.port", port);
            }
            if (props.getProperty("mail.smtp.socketFactory.class") == null) {
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            props.put("mail.smtp.socketFactory.fallback", "false");
            if (props.getProperty("mail.smtp.ssl.checkserveridentity") == null) {
                props.put("mail.smtp.ssl.checkserveridentity", "true");
            }
        }
        if (acc.isUseTls()) {
            if (props.getProperty("mail.smtp.socketFactory.port") == null) {
                port = acc.getSmtpPort() == null ? "587" : this.mailAccount.getSmtpPort();
                props.put("mail.smtp.port", port);
                props.put("mail.smtp.socketFactory.port", port);
            }
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.starttls.required", "true");
        }
        if (!StringUtils.isBlank((String)acc.getCredentialsId())) {
            props.put("mail.smtp.auth", "true");
        }
        props.put("mail.smtp.timeout", "60000");
        props.put("mail.smtp.connectiontimeout", "60000");
        try {
            String ap = acc.getAdvProperties();
            if (ap != null && !StringUtils.isBlank((String)ap.trim())) {
                props.load(new StringReader(ap));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Parameters parse fail.", e);
        }
        return Session.getInstance((Properties)props, (Authenticator)this.getAuthenticator(acc, context));
    }

    private Authenticator getAuthenticator(MailAccount acc, ExtendedEmailPublisherContext context) {
        if (acc == null || StringUtils.isBlank((String)acc.getCredentialsId())) {
            return null;
        }
        return this.authenticatorProvider.apply(acc, context.getRun());
    }

    public String getHudsonUrl() {
        return Jenkins.get().getRootUrl();
    }

    public List<MailAccount> getAddAccounts() {
        return this.addAccounts;
    }

    @DataBoundSetter
    public void setAddAccounts(List<MailAccount> addAccounts) {
        this.addAccounts = addAccounts;
    }

    @Deprecated
    public String getSmtpServer() {
        return this.mailAccount.getSmtpHost();
    }

    @Deprecated
    public void setSmtpServer(String smtpServer) {
        this.mailAccount.setSmtpHost(smtpServer);
    }

    @Deprecated
    public String getSmtpUsername() {
        return this.mailAccount.getSmtpUsername();
    }

    @Deprecated
    public void setSmtpUsername(String username) {
        this.mailAccount.setSmtpUsername(username);
    }

    @Deprecated
    public Secret getSmtpPassword() {
        return this.mailAccount.getSmtpPassword();
    }

    @DataBoundSetter
    @Deprecated
    public void setSmtpPassword(String password) {
        this.mailAccount.setSmtpPassword(password);
    }

    public void setSmtpAuth(String userName, String password) {
        this.mailAccount.setSmtpUsername(userName);
        this.mailAccount.setSmtpPassword(password);
    }

    @Deprecated
    public boolean getUseSsl() {
        return this.mailAccount.isUseSsl();
    }

    @Deprecated
    public void setUseSsl(boolean useSsl) {
        this.mailAccount.setUseSsl(useSsl);
    }

    @Deprecated
    public String getSmtpPort() {
        return this.mailAccount.getSmtpPort();
    }

    @Deprecated
    public void setSmtpPort(String port) {
        this.mailAccount.setSmtpPort(this.nullify(port));
    }

    @Deprecated
    public String getAdvProperties() {
        return this.mailAccount.getAdvProperties();
    }

    @Deprecated
    public void setAdvProperties(String advProperties) {
        this.mailAccount.setAdvProperties(advProperties);
    }

    public String getCharset() {
        String c = this.charset;
        if (StringUtils.isBlank((String)c)) {
            c = "UTF-8";
        }
        return c;
    }

    @DataBoundSetter
    public void setCharset(String charset) {
        this.charset = Util.fixEmptyAndTrim((String)charset);
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    @DataBoundSetter
    public void setDefaultContentType(String contentType) {
        this.defaultContentType = StringUtils.isBlank((String)contentType) ? "text/plain" : contentType;
    }

    public FormValidation doCheckDefaultSuffix(@QueryParameter String value) {
        if (value.matches("@[A-Za-z0-9.\\-]+") || Util.fixEmptyAndTrim((String)value) == null) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.Mailer_Suffix_Error());
    }

    public String getDefaultSubject() {
        return this.defaultSubject;
    }

    @DataBoundSetter
    public void setDefaultSubject(String subject) {
        this.defaultSubject = subject == null ? "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!" : subject;
    }

    public String getDefaultBody() {
        return this.defaultBody;
    }

    @DataBoundSetter
    public void setDefaultBody(String body) {
        this.defaultBody = StringUtils.isBlank((String)body) ? "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results." : body;
    }

    public String getEmergencyReroute() {
        return this.emergencyReroute;
    }

    @DataBoundSetter
    public void setEmergencyReroute(String emergencyReroute) {
        this.emergencyReroute = StringUtils.isBlank((String)emergencyReroute) ? "" : Util.fixEmptyAndTrim((String)emergencyReroute);
    }

    public long getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    @DataBoundSetter
    public void setMaxAttachmentSize(long bytes) {
        if (bytes < 0L) {
            bytes = -1L;
        }
        this.maxAttachmentSize = bytes;
    }

    public MailAccount getMailAccount() {
        return this.mailAccount;
    }

    @DataBoundSetter
    public void setMailAccount(MailAccount mailAccount) {
        this.mailAccount = mailAccount;
        this.mailAccount.setDefaultAccount(true);
    }

    public long getMaxAttachmentSizeMb() {
        if (this.maxAttachmentSize < 0L) {
            return -1L;
        }
        return this.maxAttachmentSize / 0x100000L;
    }

    @DataBoundSetter
    public void setMaxAttachmentSizeMb(long mb) {
        if (mb < 0L) {
            this.setMaxAttachmentSize(mb);
        } else {
            this.setMaxAttachmentSize(mb * 0x100000L);
        }
    }

    public String getDefaultRecipients() {
        return this.recipientList;
    }

    @DataBoundSetter
    public void setDefaultRecipients(String recipients) {
        this.recipientList = recipients == null ? "" : recipients;
    }

    public String getAllowedDomains() {
        return this.allowedDomains;
    }

    @DataBoundSetter
    public void setAllowedDomains(String allowed) {
        this.allowedDomains = allowed == null ? "" : allowed;
    }

    public String getExcludedCommitters() {
        return this.excludedCommitters;
    }

    @DataBoundSetter
    public void setExcludedCommitters(String excluded) {
        this.excludedCommitters = excluded == null ? "" : excluded;
    }

    @Deprecated
    public boolean getOverrideGlobalSettings() {
        return this.overrideGlobalSettings;
    }

    public String getListId() {
        return this.listId;
    }

    @DataBoundSetter
    public void setListId(String id) {
        this.listId = id;
    }

    public boolean getPrecedenceBulk() {
        return this.precedenceBulk;
    }

    @DataBoundSetter
    public void setPrecedenceBulk(boolean bulk) {
        this.precedenceBulk = bulk;
    }

    public String getDefaultReplyTo() {
        return this.defaultReplyTo;
    }

    @DataBoundSetter
    public void setDefaultReplyTo(String to) {
        this.defaultReplyTo = to == null ? "" : to;
    }

    public boolean isSecurityEnabled() {
        return false;
    }

    public boolean isAdminRequiredForTemplateTesting() {
        return this.requireAdminForTemplateTesting;
    }

    @DataBoundSetter
    public void setAdminRequiredForTemplateTesting(boolean requireAdmin) {
        this.requireAdminForTemplateTesting = requireAdmin;
    }

    public boolean isWatchingEnabled() {
        return this.enableWatching;
    }

    public boolean isAllowUnregisteredEnabled() {
        return this.enableAllowUnregistered;
    }

    @DataBoundSetter
    public void setWatchingEnabled(boolean enabled) {
        this.enableWatching = enabled;
    }

    @DataBoundSetter
    public void setAllowUnregisteredEnabled(boolean enabled) {
        this.enableAllowUnregistered = enabled;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getDefaultPresendScript() {
        return this.defaultPresendScript;
    }

    @DataBoundSetter
    public void setDefaultPresendScript(String script) {
        script = StringUtils.trim((String)script);
        this.defaultPresendScript = ScriptApproval.get().configuring(script == null ? "" : script, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser());
    }

    public String getDefaultPostsendScript() {
        return this.defaultPostsendScript;
    }

    @DataBoundSetter
    public void setDefaultPostsendScript(String script) {
        script = StringUtils.trim((String)script);
        this.defaultPostsendScript = ScriptApproval.get().configuring(script == null ? "" : script, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser());
    }

    public List<GroovyScriptPath> getDefaultClasspath() {
        return this.defaultClasspath;
    }

    @DataBoundSetter
    public void setDefaultClasspath(List<GroovyScriptPath> defaultClasspath) throws Descriptor.FormException {
        if (Jenkins.get().isUseSecurity()) {
            ScriptApproval approval = ScriptApproval.get();
            ApprovalContext context = ApprovalContext.create().withCurrentUser();
            for (GroovyScriptPath path : defaultClasspath) {
                URL u = path.asURL();
                if (u == null) continue;
                try {
                    approval.configuring(new ClasspathEntry(u.toString()), context);
                }
                catch (MalformedURLException e) {
                    throw new Descriptor.FormException((Throwable)e, "defaultClasspath");
                }
            }
        }
        this.defaultClasspath = defaultClasspath;
    }

    public List<String> getDefaultTriggerIds() {
        if (this.defaultTriggerIds.isEmpty()) {
            if (!this.defaultTriggers.isEmpty()) {
                for (EmailTriggerDescriptor t : this.defaultTriggers) {
                    EmailTriggerDescriptor d = (EmailTriggerDescriptor)Jenkins.get().getDescriptorByType(((Object)((Object)t)).getClass());
                    if (d == null || this.defaultTriggerIds.contains(d.getId())) continue;
                    this.defaultTriggerIds.add(d.getId());
                }
            } else {
                FailureTrigger.DescriptorImpl f = (FailureTrigger.DescriptorImpl)Jenkins.get().getDescriptorByType(FailureTrigger.DescriptorImpl.class);
                if (f != null) {
                    this.defaultTriggerIds.add(f.getId());
                }
            }
            this.save();
        }
        return this.defaultTriggerIds;
    }

    @DataBoundSetter
    public void setDefaultTriggerIds(List<String> triggerIds) {
        this.defaultTriggerIds = triggerIds;
    }

    public ListBoxModel doFillDefaultContentTypeItems() {
        ListBoxModel items = new ListBoxModel();
        items.add(Messages.contentType_plainText(), "text/plain");
        items.add(Messages.contentType_html(), "text/html");
        return items;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        req.bindJSON((Object)this, formData);
        this.save();
        return super.configure(req, formData);
    }

    private String nullify(String v) {
        if (v != null && v.length() == 0) {
            v = null;
        }
        return v;
    }

    public String getHelpFile() {
        return "/plugin/email-ext/help/main.html";
    }

    public FormValidation doAddressCheck(@QueryParameter String value) {
        try {
            new InternetAddress(value);
            return FormValidation.ok();
        }
        catch (AddressException e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public FormValidation doRecipientListRecipientsCheck(@QueryParameter String value) {
        return new EmailRecipientUtils().validateFormRecipientList(value);
    }

    public FormValidation doMaxAttachmentSizeCheck(@QueryParameter String value) {
        try {
            String testValue = value.trim();
            if (testValue.length() > 0) {
                Long.parseLong(testValue);
            }
            return FormValidation.ok();
        }
        catch (Exception e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public boolean isMatrixProject(Object project) {
        return project instanceof MatrixProject;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void debug(PrintStream logger, String format, Object ... args) {
        if (this.debugMode) {
            logger.format(format, args);
            logger.println();
        }
    }

    @NonNull
    public Permission getRequiredGlobalConfigPagePermission() {
        return Jenkins.MANAGE;
    }

    BiFunction<MailAccount, Run<?, ?>, Authenticator> getAuthenticatorProvider() {
        return this.authenticatorProvider;
    }

    void setAuthenticatorProvider(BiFunction<MailAccount, Run<?, ?>, Authenticator> authenticatorProvider) {
        this.authenticatorProvider = authenticatorProvider;
    }
}

