/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.plugins.emailext.plugins.recipients.RecipientProviderUtilities;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class FailingTestSuspectsRecipientProvider
extends RecipientProvider {
    @DataBoundConstructor
    public FailingTestSuspectsRecipientProvider() {
    }

    @Override
    public void addRecipients(final ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        final class Debug
        implements RecipientProviderUtilities.IDebug {
            private final ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
            private final PrintStream logger = context.getListener().getLogger();

            Debug() {
            }

            @Override
            public void send(String format, Object ... args) {
                this.descriptor.debug(this.logger, format, args);
            }
        }
        Debug debug = new Debug();
        HashSet<User> users = null;
        Run<?, ?> currentRun = context.getRun();
        if (currentRun == null) {
            debug.send("currentRun was null", new Object[0]);
        } else {
            AbstractTestResultAction testResultAction = (AbstractTestResultAction)currentRun.getAction(AbstractTestResultAction.class);
            if (testResultAction == null) {
                debug.send("testResultAction was null", new Object[0]);
            } else if (testResultAction.getFailCount() <= 0) {
                debug.send("getFailCount() returned <= 0", new Object[0]);
            } else {
                users = new HashSet<User>();
                debug.send("Collecting builds where a test started failing...", new Object[0]);
                HashSet<Run> buildsWhereATestStartedFailing = new HashSet<Run>();
                for (TestResult caseResult : testResultAction.getFailedTests()) {
                    Run runWhereTestStartedFailing = caseResult.getFailedSinceRun();
                    if (runWhereTestStartedFailing != null) {
                        debug.send("  runWhereTestStartedFailing: %d", runWhereTestStartedFailing.getNumber());
                        buildsWhereATestStartedFailing.add(runWhereTestStartedFailing);
                        continue;
                    }
                    context.getListener().error("getFailedSinceRun returned null for %s", new Object[]{caseResult.getFullDisplayName()});
                }
                debug.send("Collecting builds with suspects...", new Object[0]);
                HashSet buildsWithSuspects = new HashSet();
                block1: for (Run buildWhereATestStartedFailing : buildsWhereATestStartedFailing) {
                    debug.send("  buildWhereATestStartedFailing: %d", buildWhereATestStartedFailing.getNumber());
                    buildsWithSuspects.add(buildWhereATestStartedFailing);
                    Run previousBuildToCheck = buildWhereATestStartedFailing.getPreviousCompletedBuild();
                    if (previousBuildToCheck != null) {
                        debug.send("    previousBuildToCheck: %d", previousBuildToCheck.getNumber());
                    }
                    while (previousBuildToCheck != null) {
                        if (buildsWithSuspects.contains(previousBuildToCheck)) {
                            debug.send("      already contained in buildsWithSuspects; stopping search", new Object[0]);
                            continue block1;
                        }
                        Result previousResult = previousBuildToCheck.getResult();
                        if (previousResult == null) {
                            debug.send("      previousResult was null", new Object[0]);
                            continue;
                        }
                        debug.send("      previousResult: %s", previousResult.toString());
                        if (previousResult.isBetterThan(Result.FAILURE)) {
                            debug.send("      previousResult was better than FAILURE; stopping search", new Object[0]);
                            continue block1;
                        }
                        debug.send("      previousResult was not better than FAILURE; adding to buildsWithSuspects; continuing search", new Object[0]);
                        buildsWithSuspects.add(previousBuildToCheck);
                        if ((previousBuildToCheck = previousBuildToCheck.getPreviousCompletedBuild()) == null) continue;
                        debug.send("    previousBuildToCheck: %d", previousBuildToCheck.getNumber());
                    }
                }
                debug.send("Collecting suspects...", new Object[0]);
                users.addAll(RecipientProviderUtilities.getChangeSetAuthors(buildsWithSuspects, debug));
                users.addAll(RecipientProviderUtilities.getUsersTriggeringTheBuilds(buildsWithSuspects, debug));
            }
        }
        if (users != null) {
            RecipientProviderUtilities.addUsers(users, context, env, to, cc, bcc, (RecipientProviderUtilities.IDebug)debug);
        }
    }

    @Extension
    @Symbol(value={"brokenTestsSuspects"})
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.FailingTestSuspectsRecipientProvider_DisplayName();
        }
    }
}

