/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class EmailExtRecipientStep
extends Step {
    private List<RecipientProvider> recipientProviders;

    @DataBoundConstructor
    public EmailExtRecipientStep(List<RecipientProvider> recipientProviders) {
        this.recipientProviders = recipientProviders;
    }

    public List<RecipientProvider> getRecipientProviders() {
        return this.recipientProviders;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Executor(this, context);
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, Run.class, TaskListener.class, EnvVars.class);
            return Collections.unmodifiableSet(context);
        }

        public String getFunctionName() {
            return "emailextrecipients";
        }

        @NonNull
        public String getDisplayName() {
            return "Extended Email Recipients";
        }

        public List<RecipientProviderDescriptor> getRecipientProvidersDescriptors() {
            return RecipientProvider.allSupporting(WorkflowJob.class);
        }
    }

    public static class Executor
    extends SynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1L;
        private final transient EmailExtRecipientStep step;

        protected Executor(EmailExtRecipientStep step, @NonNull StepContext context) {
            super(context);
            this.step = step;
        }

        protected String run() throws Exception {
            if (this.step.recipientProviders == null || this.step.recipientProviders.isEmpty()) {
                throw new IllegalArgumentException("You must provide at least one recipient provider");
            }
            ExtendedEmailPublisher publisher = new ExtendedEmailPublisher();
            ExtendedEmailPublisherContext context = new ExtendedEmailPublisherContext(publisher, (Run)this.getContext().get(Run.class), null, null, (TaskListener)this.getContext().get(TaskListener.class));
            HashSet<InternetAddress> to = new HashSet<InternetAddress>();
            RecipientProvider.checkAllSupport(this.step.recipientProviders, ((Run)this.getContext().get(Run.class)).getParent().getClass());
            for (RecipientProvider provider : this.step.recipientProviders) {
                provider.addRecipients(context, (EnvVars)this.getContext().get(EnvVars.class), to, to, to);
            }
            StringBuilder rt = new StringBuilder();
            Iterator iterator = to.iterator();
            while (iterator.hasNext()) {
                rt.append(((InternetAddress)iterator.next()).toString());
                if (!iterator.hasNext()) continue;
                rt.append(" ");
            }
            return rt.toString();
        }
    }
}

