/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.groovy.sandbox;

import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.GroovyObject;
import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.content.EmailExtScript;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.AbstractWhitelist;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public class EmailExtScriptTokenMacroWhitelist
extends AbstractWhitelist {
    private final List<TokenMacro> macros;

    public EmailExtScriptTokenMacroWhitelist() {
        ArrayList<TokenMacro> list = new ArrayList<TokenMacro>();
        list.addAll((Collection<TokenMacro>)TokenMacro.all());
        list.addAll(ContentBuilder.getPrivateMacros());
        this.macros = Collections.unmodifiableList(list);
    }

    public boolean permitsMethod(@NonNull Method method, @NonNull Object receiver, @NonNull Object[] args) {
        if (method.getDeclaringClass() == GroovyObject.class && receiver instanceof EmailExtScript && "invokeMethod".equals(method.getName()) && args.length > 0) {
            EmailExtScript script = (EmailExtScript)((Object)receiver);
            String name = String.valueOf(args[0]);
            for (TokenMacro m : this.macros) {
                if (!m.acceptsMacroName(name)) continue;
                return true;
            }
            Run build = (Run)script.getBinding().getVariable("build");
            TaskListener listener = (TaskListener)script.getBinding().getVariable("listener");
            try {
                EnvVars vars = build.getEnvironment(listener);
                return vars.containsKey((Object)name);
            }
            catch (IOException | InterruptedException e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Failed to expand environment when evaluating " + name + " on " + build.getExternalizableId(), e);
            }
        }
        return false;
    }
}

